#include <sys/types.h>
#include "bytes.h"

#ifndef _FLOW_PROFILE_H
#define _FLOW_PROFILE_H

#define OPT_PERCENT 1   /* use percent's */
#define OPT_NAMES   2   /* use symbolic names */
#define OPT_LONG    4   /* long output */

/* save memory */
#define PROF_UDP_TCP_COMBINED 

#define DIR_OUT 0
#define DIR_IN 1

#ifdef PROF_UDP_TCP_COMBINED
#define udp_port_packets tcp_port_packets
#define udp_port_octets tcp_port_octets
#endif /* PROF_UDP_TCP_COMBINED */

struct string_list {
  size_t entries;
  char **ptr;
};

#define PROF_NAME_LEN 64+1

struct profile {

#ifndef PROF_UDP_TCP_COMBINED
  /* udp port counters */
  u_int64 udp_port_packets[2][1024];
  u_int64 udp_port_octets[2][1024];
#endif

  /* tcp port counters */
  u_int64 tcp_port_packets[2][1024];
  u_int64 tcp_port_octets[2][1024];

  /* tcp flag counters */
  u_int64 tcp_flag_syn[2];
  u_int64 tcp_flag_syn_ack[2];

  /* ip protocol counters */
  u_int64 ip_prot_octets[2][256];
  u_int64 ip_prot_packets[2][256];

}; /* 81952 (73760) bytes */

/*
01234567890123456789012345678901234567890123456789012345678901234567890123456789
TTTTTTTTTTTTTTTTTTTTTTTTTTTTTT  NNNNNNNNNN  NNNNNNNNNN   NNNNNNNNN  NNNNNNNNNN
 NNNNNNNNNN NNNNNNNNNN NNNNNNNNNN NNNNNNNNNN   NNNNNNNNNN NNNNNNNNNN NNNNNNNNNN
*/
#endif

