#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <fcntl.h>
#include "flow.h"
#include "acl2.h"

/*
/* TODO
/* extended ACL's
*/

int debug;
int ip_net_only;

struct acl_list acl_list;

void usage();

int main(argc, argv)
int argc;
char **argv;
{

  int i, ret, z_level, k;
  struct flow_data *fdata;
  struct flow_stream fs_in, fs_out;
  extern char *optarg;
  extern int errno;
  extern struct acl_list acl_list;
  extern FILE *yyin;
  char *acl_fname, *acl_std_src_name, *acl_std_dst_name;
  char *acl_ext_name;
  int acl_std_src_index, acl_std_src_index2;
  int acl_std_dst_index, acl_std_dst_index2;
  int acl_ext_index, acl_ext_index2;
  struct acl_ip_ext_entry tmp_ext;
  struct flow_profile fp;
  struct flow_header fh_new;
  int out_byte_order;
  int filter_input, filter_output, filter_srcport, filter_dstport;
  int filter_prot, filter_srcas, filter_dstas;
  char in_tbl[65536], out_tbl[65536], src_tbl[65536], dst_tbl[65536];
  char srcas_tbl[65536], dstas_tbl[65536];
  char prot_tbl[256];

  /* profile */
  if (profile_start (&fp) == -1) {
    fprintf(stderr, "profile_start(): failed\n");
    exit (1);
  }

  /* init */
  bzero(&acl_list, sizeof acl_list);
  acl_fname = acl_std_src_name = acl_std_dst_name = (char*)0L;
  acl_ext_name = (char*)0L;
  acl_std_src_index = acl_std_dst_index = -1;
  acl_ext_index = -1;
  bzero(&tmp_ext, sizeof tmp_ext);
  bzero(&fs_in, sizeof fs_in);
  bzero(&fs_out, sizeof fs_out);
  bzero (&fh_new, sizeof fh_new);
  z_level = Z_NO_COMPRESSION;
#if BYTE_ORDER == BIG_ENDIAN
  out_byte_order = BIG_ENDIAN;
#endif /* BYTE_ORDER == BIG_ENDIAN */
#if BYTE_ORDER == LITTLE_ENDIAN
  out_byte_order = LITTLE_ENDIAN;
#endif /* BYTE_ORDER == LITTLE_ENDIAN */

  filter_input = filter_output = filter_srcport = filter_dstport = 0;
  filter_prot = filter_srcas = filter_dstas = 0;

  while ((i = getopt(argc, argv, "a:A:b:C:d:f:p:P:r:S:D:E:z:i:I:")) != -1)
    switch (i) {

    case 'a': /* src AS filter list */

      if (load_lookup(optarg, 65536, &srcas_tbl)) {
        fprintf(stderr, "error parsing list\n");
        exit (1);
      }

      filter_srcas = 1;
      break;

    case 'A': /* dst AS filter list */

      if (load_lookup(optarg, 65536, &dstas_tbl)) {
        fprintf(stderr, "error parsing list\n");
        exit (1);
      }

      filter_dstas = 1;
      break;

    case 'b': /* output byte order */
      if (!strcasecmp(optarg, "little"))
        out_byte_order = LITTLE_ENDIAN;
      else if (!strcasecmp(optarg, "big"))
        out_byte_order = BIG_ENDIAN;
      else {
        fprintf(stderr, "expecting \"big\" or \"little\" at -b\n");
        exit (1);
      }
      break;

    case 'C': /* comment field */
      if (strlen(optarg) > (FH_COMMENTS_LEN-1)) {
        fprintf(stderr, "comments limited to %d bytes.\n",
          (FH_COMMENTS_LEN-1));
        exit (1);
      }
      strcpy((char*)&fh_new.comments, optarg);
      break;

    case 'd': /* debug */
      debug = atoi(optarg);
      break;

    case 'f': /* acl file name */
      acl_fname = optarg;
      break;

    case 'i': /* input filter interface list */

      if (load_lookup(optarg, 65536, &in_tbl)) {
        fprintf(stderr, "error parsing list\n");
        exit (1);
      }

      filter_input = 1;
      break;

    case 'I': /* output filter interface list */

      if (load_lookup(optarg, 65536, &out_tbl)) {
        fprintf(stderr, "error parsing list\n");
        exit (1);
      }

      filter_output = 1;
      break;

    case 'P': /* filter dstport */

      if (load_lookup(optarg, 65536, &dst_tbl)) {
        fprintf(stderr, "error parsing list\n");
        exit (1);
      }

      filter_dstport = 1;
      break;

    case 'p': /* filter srcport */

      if (load_lookup(optarg, 65536, &src_tbl)) {
        fprintf(stderr, "error parsing list\n");
        exit (1);
      }

      filter_srcport = 1;
      break;

    case 'r': /* filter protocol */

      if (load_lookup(optarg, 256, &prot_tbl)) {
        fprintf(stderr, "error parsing list\n");
        exit (1);
      }

      filter_prot = 1;
      break;

    case 'S': /* src ip standard access list filter */
      acl_std_src_name = optarg;
      break;

    case 'D': /* dst ip standard access list filter */
      acl_std_dst_name = optarg;
      break;

    case 'E': /* extended access list filter */
      acl_ext_name = optarg;
      break;

    case 'h': /* help */
    case '?':
      usage();
      exit (0);
      break;

    case 'z': /* compression */
      z_level = atoi(optarg);
      if ((z_level < 0) || (z_level > 9)) {
        fprintf(stderr, "Compression level must be between 0 and 9\n");
        exit (1);
      }
      break;

    default:
      usage();
      exit (1);
      break;

    } /* switch */

  /* input from stdin */
  fs_in.fd = 0;

  /* output to stdout */
  fs_out.fd = 1;

  /* set compression level in output stream */
  if (z_level != Z_NO_COMPRESSION) {
    fs_out.flags = FS_FLAG_COMPRESS;
    fs_out.z_level = z_level;
    fh_new.flags = FF_FLAG_COMPRESS;
  } else
    fs_out.flags = 0;

  /*
  /* load acl's
  /* XXX add fname check and close
  */
  if ((yyin = fopen(acl_fname ? acl_fname : "flow.acl", "r")))
    while (!feof(yyin))
      yyparse();

  /*
  /* normalize masks
  */
  /* XXX TODO */

  if (debug > 5) 
    acl_dump(acl_list);

  if (acl_std_src_name) {
    if ((acl_std_src_index = acl_find(acl_list, acl_std_src_name)) == -1) {
      fprintf(stderr, "Couldn't find list %s\n", acl_std_src_name);
      exit (1);
    }

    acl_std_src_index2 = acl_list.names[acl_std_src_index].num;

  }

  if (acl_std_dst_name) {
    if ((acl_std_dst_index = acl_find(acl_list, acl_std_dst_name)) == -1) {
      fprintf(stderr, "Couldn't find list %s\n", acl_std_dst_name);
      exit (1);
    }

    acl_std_dst_index2 = acl_list.names[acl_std_dst_index].num;
  }

  if (acl_ext_name) {
    if ((acl_ext_index = acl_find(acl_list, acl_ext_name)) == -1) {
      fprintf(stderr, "Couldn't find list %s\n", acl_ext_name);
      exit (1);
    }

    acl_ext_index2 = acl_list.names[acl_ext_index].num;
  }

  if (flow_read_header(&fs_in) == -1) {
    fprintf(stderr, "flow_read_header(): failed.\n");
    exit (1);
  }

  fh_new.magic1 = FF_MAGIC1;
  fh_new.magic2 = FF_MAGIC2;
  fh_new.s_version = FSTREAM_VERSION;
  fh_new.d_version = FF_D_VERSION_UNKNOWN;


#if BYTE_ORDER == LITTLE_ENDIAN
  fh_new.byte_order = FF_LITTLE_ENDIAN;

  if (out_byte_order == BIG_ENDIAN)
    swap_flow_header(&fh_new);
#endif /* BYTE_ORDER == LITTLE_ENDIAN */

#if BYTE_ORDER == BIG_ENDIAN
  fh_new.byte_order = FF_BIG_ENDIAN;

  if (out_byte_order == LITTLE_ENDIAN)
    swap_flow_header(&fh_new);
#endif /* BYTE_ORDER == BIG_ENDIAN */


  if ((writen(1, &fh_new, sizeof(struct flow_header))) == -1) {
    fprintf(stderr, "writen(): %s\n", strerror(errno));
    exit (1);
  }

  /* grab 1 flow */
  while ((fdata = flow_read(&fs_in))) {

    ++fp.nflows;

    /* filter on input interface */
    if (filter_input) 
      if (!in_tbl[fdata->input])
        continue;

    /* filter on output interface */
    if (filter_output)
      if (!out_tbl[fdata->output])
        continue;

    /* filter on src port */
    if (filter_srcport)
      if (!src_tbl[fdata->srcport])
        continue;

    /* filter on dst port */
    if (filter_dstport)
      if (!dst_tbl[fdata->dstport])
        continue;

    /* filter on protocol */
    if (filter_prot)
      if (!prot_tbl[fdata->prot])
        continue;

    /* filter on src AS */
    if (filter_srcas)
      if (!srcas_tbl[fdata->src_as])
        continue;

    /* filter on src AS */
    if (filter_dstas)
      if (!dstas_tbl[fdata->dst_as])
        continue;

    /* eval flow src addr and source standard acl */
    if (acl_std_src_index != -1) {
      ret = acl_eval_std(acl_list, acl_std_src_index2, fdata->srcaddr);
      if (ret == 1)
        continue;
    }

    /* eval flow dst addr and destination standard acl */
    if (acl_std_dst_index != -1) {
      ret = acl_eval_std(acl_list, acl_std_dst_index2, fdata->dstaddr);
      if (ret == 1)
        continue;
    }

    /* eval flow and extended acl */
    if (acl_ext_index != -1) {

      tmp_ext.protocol = fdata->prot;
      tmp_ext.tos = fdata->tos;

      /* XXX */
      tmp_ext.type = 0;
      tmp_ext.type_code = 0;
      tmp_ext.message = 0;

      tmp_ext.src_addr = fdata->srcaddr;
      tmp_ext.src_port = fdata->srcport;


      tmp_ext.dst_addr = fdata->dstaddr;
      tmp_ext.dst_port = fdata->dstport;

      ret = acl_eval_ext(acl_list, acl_ext_index2, tmp_ext);
      if (ret == 1)
        continue;
    }

    /*
    /* made it by the filters, write it
    */

#if BYTE_ORDER == BIG_ENDIAN
    if (out_byte_order == LITTLE_ENDIAN)
      swap_flow_data(fdata);
#endif /* BYTE_ORDER == BIG_ENDIAN */

#if BYTE_ORDER == LITTLE_ENDIAN
    if (out_byte_order == BIG_ENDIAN)
      swap_flow_data(fdata);
#endif /* BYTE_ORDER == LITTLE_ENDIAN */


    if (flow_write(fdata, &fs_out) == -1) {
      fprintf(stderr, "flow_write(): failed.\n");
      exit (1);
    }

  } /* while more flows to read */

  if (flow_flush(&fs_out) == -1) {
    fprintf(stderr, "flow_flush(): failed.\n");
    exit (1);
  }

  flow_write_end(&fs_out);
  flow_read_end(&fs_in);

  if (debug > 0) {
    if (profile_end(argv[0], &fp) == -1) {
      fprintf(stderr, "profile_end(): failed\n");
      exit (1);
    }
  }

  if (debug > 1) {
    acl_dump_std(acl_list, acl_std_src_index);
    acl_dump_std(acl_list, acl_std_dst_index);
  }

  return 0;

} /* main */

void usage() {

  fprintf(stderr, "flow-filter:\n\n");
  fprintf(stderr, " -a [!](list) src AS list filter\n");
  fprintf(stderr, " -A [!](list) dst AS list filter\n");
  fprintf(stderr, " -b s set output byte order (little or big)\n");
  fprintf(stderr, " -C s set comment field in output\n");
  fprintf(stderr, " -d # set debug level.\n");
  fprintf(stderr, " -i [!](list) input interface list filter\n");
  fprintf(stderr, " -I [!](list) output interface list filter\n");
  fprintf(stderr, " -f access-list file (defaults to flow.acl).\n");
  fprintf(stderr, " -p [!](list) src port list filter\n");
  fprintf(stderr, " -P [!](list) dst port list filter\n");
  fprintf(stderr, " -r [!](list) IP protocol list filter\n");
  fprintf(stderr, " -S acl_name  specify src address filter.\n");
  fprintf(stderr, " -D acl_name  specify dst address filter.\n");
  fprintf(stderr, " -E acl_name  specify extended acl filter.\n");
  fprintf(stderr, "  ! to invert a list\n");
  fprintf(stderr, "  , to seperate list items\n");
  fprintf(stderr, "  - to define a list ranges\n");
  fprintf(stderr, "  ie 1-1024,6000\n");
  fprintf(stderr, "\n\n");

} /* usage */

