#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include "flow.h"
#include "bytes.h"
#include "queue.h"
#include "support.h"

char *progname = "flow-expire";
int detach, debug;

main(argc, argv)
int argc;
char **argv;
{
  extern char *optarg;
  extern int optind, debug, errno;
  struct file_ager fa;
  int i, fexpire, doit;
  char wpname[MAXPATHNAME+1];

  bzero(&fa, sizeof fa);

  fa.max_files = 0;
  fa.max_bytes = 0;
  wpname[0] = '.'; wpname[1] = 0;

  while ((i = getopt(argc, argv, "w:d:e:E:h?")) != -1)

    switch (i) {

    case 'd': /* debug */
      debug = atoi(optarg);
      break;

    case 'e': /* expire */
      fa.max_files = atoi(optarg);
      break;

    case 'E': /* size of flow files */
      if ((fa.max_bytes = scan_size(optarg)) == -1) {
        fprintf(stderr, "error scanning size\n");
        exit (1);
      }
      break;

    case 'w': /* output pathname */
      if (strlen(optarg) > (MAXPATHNAME)) {
        fprintf(stderr, "Pathname too long\n");
        exit (1);
      }
      strcpy(wpname, optarg);
      break;

    case '?':
    case 'h':
      usage();
      exit (0);

    default:
      usage();
      exit (1);

    } /* switch */

  if (debug) {
    doit = 0;
    detach = 0;
    report_init(1);
  }
  else {
    doit = 1;
    detach = 1;
    report_init(0);
  }


  if (file_scandir(&fa, wpname)) {
    report(LOG_ERR, "file_scandir(): failed");
    exit (1);
  }
  if (debug)
    file_dump(&fa);
  if (file_expire(&fa, doit, (u_int32)0)) {
    report(LOG_ERR, "file_expire(): failed");
    exit (1);
  }
  if (debug)
    file_dump(&fa);

}

usage() {

  fprintf(stderr, "flow expire:\n\n");
  fprintf(stderr, " -d #  debug level.\n");
  fprintf(stderr, " -e #  flow files to keep before expire. (0=disable)\n");
  fprintf(stderr, " -E #  size of flow files to keep before expire. (0=disable)\n");
  fprintf(stderr, "       use b,K,M,G as multipliers, ie 16M for 16*1024*1024\n"); 
  fprintf(stderr, " -w x  working directory pathname.\n");
  fprintf(stderr, "\n\n");

}
