#include "bytes.h"
#include "flow.h"


/*
/* swap the byte order of a flow_pdu
*/
void swap_flow_pdu(fpdu, byte_order)
struct flow_pdu *fpdu;
int byte_order;
{
	int16 x;

	x = fpdu->count;

#if BYTE_ORDER == LITTLE_ENDIAN
	if (byte_order == BIG_ENDIAN) {
		SWAPINT16(x);
	}
#endif /* BYTE_ORDER == LITTLE_ENDIAN */

#if BYTE_ORDER == BIG_ENDIAN
	if (byte_order == LITTLE_ENDIAN) {
		SWAPINT16(x);
	}
#endif /*  BYTE_ORDER == BIG_ENDIAN */

	SWAPINT16(fpdu->version);
	SWAPINT16(fpdu->count);
	SWAPINT32(fpdu->sysUpTime);
	SWAPINT32(fpdu->unix_secs);
	SWAPINT32(fpdu->unix_nsecs);


	for (; x; --x) {
		SWAPINT32(fpdu->records[x].srcaddr)
		SWAPINT32(fpdu->records[x].dstaddr)
		SWAPINT32(fpdu->records[x].nexthop)
		SWAPINT16(fpdu->records[x].input)
		SWAPINT16(fpdu->records[x].output)
		SWAPINT32(fpdu->records[x].dPkts)
		SWAPINT32(fpdu->records[x].dOctets)
		SWAPINT32(fpdu->records[x].First)
		SWAPINT32(fpdu->records[x].Last)
		SWAPINT16(fpdu->records[x].dstport)
		SWAPINT16(fpdu->records[x].srcport)
	}
}

/*
/* swap the byte order of a flow_header
*/
void swap_flow_header(fh)
struct flow_header *fh;

{
	if (fh->byte_order == LITTLE_ENDIAN)
		fh->byte_order = 2;
	else
		fh->byte_order = 1;

	SWAPINT16(fh->version);
	SWAPINT32(fh->start);
	SWAPINT32(fh->end);
	SWAPINT32(fh->flags);
	SWAPINT32(fh->rotation);
	SWAPINT32(fh->nflows);
}

/*
/* swap the byte order of a flow_data
*/
void swap_flow_data(fdata)
struct flow_data *fdata;
{
	SWAPINT32(fdata->unix_secs);
	SWAPINT32(fdata->unix_msecs);
	SWAPINT32(fdata->srcaddr);
	SWAPINT32(fdata->dstaddr);
	SWAPINT32(fdata->nexthop);
	SWAPINT16(fdata->input);
	SWAPINT16(fdata->output);

	SWAPINT32(fdata->dPkts);
	SWAPINT32(fdata->dOctets);
	SWAPINT32(fdata->First);
	SWAPINT32(fdata->Last);

	SWAPINT16(fdata->srcport);
	SWAPINT16(fdata->dstport);
	SWAPINT16(fdata->pad);

	SWAPINT32(fdata->reserved);
}

/*
/* swap the byte order of a flow_pdu, but only the header
*/
void swap_flow_pdu2(fpdu, byte_order)
struct flow_pdu *fpdu;
int byte_order;
{
	int16 x;

	x = fpdu->count;

#if BYTE_ORDER == LITTLE_ENDIAN
	if (byte_order == BIG_ENDIAN) {
		SWAPINT16(x);
	}
#endif /* BYTE_ORDER == LITTLE_ENDIAN */

#if BYTE_ORDER == BIG_ENDIAN
	if (byte_order == LITTLE_ENDIAN) {
		SWAPINT16(x);
	}
#endif /*  BYTE_ORDER == BIG_ENDIAN */

	SWAPINT16(fpdu->version);
	SWAPINT16(fpdu->count);
	SWAPINT32(fpdu->sysUpTime);
	SWAPINT32(fpdu->unix_secs);
	SWAPINT32(fpdu->unix_nsecs);

}
