#include "bytes.h"
#include <netinet/in.h>

int acl_find();
int acl_dump();
int acl_eval_std();
int acl_eval_ext();
int acl_dump_std();

#define ACL_FLAG_PERMIT     0x1     /* else deny */
#define ACL_FLAG_SRC_PORT   0x2     /* do source port filtering */
#define ACL_FLAG_DST_PORT   0x4     /* do destination port filtering */
#define ACL_FLAG_ESTABLISHED  0x8   /* do "established" filtering */
#define ACL_FLAG_PRECEDENCE   0x10  /* do "precedence" filtering */
#define ACL_FLAG_TOS      0x20      /* do "tos" filtering */
#define ACL_FLAG_IP_ALL     0x40    /* all ip protocols */

#define ACL_OP_LT   1
#define ACL_OP_GT   1
#define ACL_OP_EQ   1
#define ACL_OP_NEQ    1
#define ACL_OP_RANGE  1

#define ACL_TYPE_STD  1
#define ACL_TYPE_EXT  2

struct acl_list {
  int num;                          /* number of entries */
  int num_std;                      /* number of standard acl entries */
  int num_ext;                      /* number of extended acl entries */
  struct acl_names *names;          /* name of acl (num of these) */
  struct acl_ip_std *acl_ip_std;    /* list of standard acl's (not || names) */
                                    /* num_std of these */
  struct acl_ip_ext *acl_ip_ext;    /* list of extended acl's (not || names) */
                                    /* num_ext of these */
};

struct acl_names {
  int num;       /* index into standard or extended list */
  char *name;    /* name of this acl */
  int type;      /* ACL_TYPE_* */
};

struct acl_ip_std {
  int           num_lines;        /* # of allocated entries */
  struct acl_ip_std_entry *line;
};

struct acl_ip_std_entry {
  u_int32   src_addr;       /* source address */
  u_int32   src_mask;       /* source address mask */
  u_int64   matches;        /* # of matches */
  int     flag;             /* permit/deny */
};

struct acl_ip_ext {
  int           num_lines;  /* # of allocated entries */
  struct acl_ip_ext_entry *line;
};

struct acl_ip_ext_entry {

  u_int8    protocol;      /* IP protocol */
  u_int8    precedence;    /* IP precedence */
  u_int8    tos;           /* IP type of service */

  u_int8    type;
  u_int8    type_code;
  u_int8    message;

  u_int8    src_op;
  u_int8    dst_op;

  u_int32   src_addr;    /* source address */
  u_int32   src_mask;    /* source address mask */
  u_int16   src_port;    /* source port */
  u_int16   src_port2;   /* source port (end of range) */

  u_int32   dst_addr;    /* destination address */
  u_int32   dst_mask;    /* destinan address mask */
  u_int16   dst_port;    /* destination port */
  u_int16   dst_port2;   /* destination port (end of range) */

  u_int64   matches;     /* # of matches */
  int     flag;          /* permit/deny, etc */
};


