
/* Test flawfinder.  This program won't compile or run; that's not necessary
   for this to be a useful test. */

main() {
  char d[20];
  char s[20];
  int n;

  _mbscpy(d,s); /* like strcpy, this doesn't check for buffer overflow */
  memcpy(d,s);
  CopyMemory(d,s);
  lstrcat(d,s);
  strncpy(d,s);
  _tcsncpy(d,s);
  strncat(d,s,10);
  strncat(d,s,sizeof(d)); /* Misuse - this should be flagged as riskier. */
  _tcsncat(d,s,sizeof(d)); /* Misuse - flag as riskier */
  n = strlen(d);
  /* This is wrong, and should be flagged as risky: */
  MultiByteToWideChar(CP_ACP,0,szName,-1,wszUserName,sizeof(wszUserName));
  /* This is much better: */
  MultiByteToWideChar(CP_ACP,0,szName,-1,wszUserName,sizeof(wszUserName)/sizeof(wszUserName[0]));
}

/*



  # TODO: Need to detect varying levels of danger.
  "execl|execlp|execle|execv|execvp|system|popen|WinExec|ShellExecute":
     (normal, 4,
      "this causes a new program to execute and is difficult to use safely",
      "try using a library call that implements the same functionality " +
      "if available.",
      "shell", "", {}),

  # TODO: Be more specific.  The biggest problem involves "first" param NULL,
  # second param with embedded space.
  "CreateProcess|CreateProcessAsUser|CreateProcessWithLogon":
     (normal, 3,
      "this causes a new process to execute and is difficult to use safely",
      "Specify the application path in the first argument, NOT as part of the second, " +
        "or embedded spaces could allow an attacker to force a different program to run.",
      "shell", "", {}),

  # These are Windows-unique:

  "SetSecurityDescriptorDacl":
     (c_hit_if_null, 5,
      "Never create NULL ACLs; an attacker can set it to Everyone (Deny All Access), " +
        "which would even forbid administrator access.",
      "",
      "misc", "", {'check_for_null' : 3}),

  "AddAccessAllowedAce":
     (normal, 3,
      "This doesn't set the inheritance bits in the access control entry (ACE) header.",
      "Make sure that you set inheritance by hand if you wish it to inherit.",
 3     "misc", "", {}),

*/

