// generated by Fast Light User Interface Designer (fluid) version 2.0001

#include "multiple.h"
void AddToWindowMenu(Fl_FancyMultiEditor *editor, long sessid, const char *menuname, Fl_Menu_ *menu);
void RemoveFromWindowMenu(Fl_FancyMultiEditor *editor, long sessid, Fl_Menu_* menu, Fl_Item_Group *winmenu);

static Fl_Item_Group *WindowMenu = NULL;

bool CloseSession(Fl_Menu_ *menu, Fl_Item_Group *WindowMenu, Fl_FancyMultiEditor *ed);
bool ExitOK(Fl_Menu_ *menu, Fl_Item_Group *WinMenu, Fl_FancyMultiEditor *ed);
void ChangeWindowMenu(Fl_FancyMultiEditor *editor, const char *oldname, Fl_Menu_* mainmenu, Fl_Item_Group* winmenu);
static char *Win23Dummy = "........................................................................................................................................";
// Win32Dummy is a kludge for Win32 release compile, see the readme

Fl_Window* myWindow;

static Fl_FancyMultiEditor* myEditor;

Fl_Menu_Bar* MenuBar;

static void cb_New(Fl_Item*, Fl_FancyMultiEditor* v)
{
	long sessid = v->NewSession();
	if(sessid >= 0)
	   AddToWindowMenu(v, sessid, "&Window", MenuBar);
	myWindow->label(v->SessionName());
}

static void cb_Open(Fl_Item*, Fl_FancyMultiEditor* v)
{
	char *fn;
	fn = fl_file_chooser("Open File", NULL, NULL);
	if(fn)
	{
	      long sessid = v->NewSession(fn);
	      AddToWindowMenu(v, sessid, "&Window", MenuBar);
	      myWindow->label(v->SessionName());
	}
;}

static void cb_Insert(Fl_Item*, Fl_FancyMultiEditor* v)
{
	char *fn;
	fn = fl_file_chooser("Open File", NULL, NULL);
	if(fn)
	   {
	       FILE *file = fopen(fn, "r");
	       if(file)
	          {
	               v->LoadFrom(file);
	               fclose(file);
	          }
	   }
;}

static void cb_Save(Fl_Item* o, Fl_FancyMultiEditor* v)
{
	const char *fn = v->CurrentFileName();
	if (!fn || (!fn[0]))
	{
	   fn = fl_file_chooser("Save As", NULL, NULL);
	   if(fn)
	   {
	      wString oldname = v->SessionName();
	      v->SaveCurrent(fn);
	      ChangeWindowMenu(v, oldname.Get(), MenuBar, WindowMenu);
	   }
	}
	else
	   v->SaveCurrent(fn);
}

static void cb_Save1(Fl_Item* o, Fl_FancyMultiEditor * v)
{
	const char *fn = fl_file_chooser("Save As", NULL, NULL);
	if(fn)
	{
	   wString oldname = v->SessionName();
	   v->SaveCurrent(fn);
	   ChangeWindowMenu(v, oldname.Get(), MenuBar, WindowMenu);
	}
;}

static void cb_Close(Fl_Item* o, Fl_FancyMultiEditor* v)
{
	CloseSession(MenuBar, WindowMenu, v);
}

static void cb_E(Fl_Item* o, Fl_FancyMultiEditor* v)
{
	if(ExitOK((Fl_Menu_*)o, WindowMenu, v))
	   myWindow->hide();
}

static void cb_Cu(Fl_Item*, Fl_FancyMultiEditor* v)
{
	v->Cut();
}

static void cb_Copy(Fl_Item*, Fl_FancyMultiEditor* v)
{
	v->Copy();
}

static void cb_Paste(Fl_Item*, Fl_FancyMultiEditor* v)
{
	v->Paste();
}

static void cb_Toggle(Fl_Item*, Fl_FancyMultiEditor* v)
{
	v->readonly(!v->readonly());
}

static void cb_Find(Fl_Item*, Fl_FancyMultiEditor* v)
{
	v->Find();
}

static void cb_Find1(Fl_Item*, Fl_FancyMultiEditor* v)
{
	v->FindNext();
}

static void cb_Replace(Fl_Item*, Fl_FancyMultiEditor* v)
{
	v->Replace();
}

static void cb_Next(Fl_Item*, Fl_FancyMultiEditor* v)
{
	v->NextSession();
	myWindow->label(v->SessionName());
}

static void cb_Previous(Fl_Item*, Fl_FancyMultiEditor* v)
{
	v->PreviousSession();
	myWindow->label(v->SessionName());
}

int main (int argc, char **argv)
{

	Fl_Window* w;
	
	{
Fl_Window* o = myWindow = new Fl_Window(306, 240, "Test Window");
		w = o;
		
		{
Fl_FancyMultiEditor* o = myEditor = new Fl_FancyMultiEditor(3, 23, 299, 212);
			o->box(FL_DOWN_BOX);
			o->color((Fl_Color)7);
			o->selection_color((Fl_Color)14);
			Fl_Group::current()->resizable(o);
			o->textfont(FL_HELVETICA);
			o->textsize(14);
		}
		
		{
Fl_Menu_Bar* o = MenuBar = new Fl_Menu_Bar(-2, -1, 310, 21); o->begin();
			o->box(FL_THIN_UP_BOX);
			
			{
Fl_Item_Group* o = new Fl_Item_Group("&File");
				
				{
Fl_Item* o = new Fl_Item("&New");
					o->callback((Fl_Callback*)cb_New, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				
				{
Fl_Item* o = new Fl_Item("&Open");
					o->callback((Fl_Callback*)cb_Open, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				
				{
Fl_Item* o = new Fl_Item("&Insert File");
					o->callback((Fl_Callback*)cb_Insert, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				new Fl_Divider();
				
				{
Fl_Item* o = new Fl_Item("&Save");
					o->callback((Fl_Callback*)cb_Save, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				
				{
Fl_Item* o = new Fl_Item("Save &As");
					o->callback((Fl_Callback*)cb_Save1, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				
				{
Fl_Item* o = new Fl_Item("&Close");
					o->callback((Fl_Callback*)cb_Close, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				new Fl_Divider();
				
				{
Fl_Item* o = new Fl_Item("E&xit");
					o->callback((Fl_Callback*)cb_E, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				o->end();
			}
			
			{
Fl_Item_Group* o = new Fl_Item_Group("&Edit");
				
				{
Fl_Item* o = new Fl_Item("Cu&t");
					o->callback((Fl_Callback*)cb_Cu, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				
				{
Fl_Item* o = new Fl_Item("&Copy");
					o->callback((Fl_Callback*)cb_Copy, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				
				{
Fl_Item* o = new Fl_Item("&Paste");
					o->callback((Fl_Callback*)cb_Paste, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				
				{
Fl_Item* o = new Fl_Item("Toggle &Read-Only");
					o->callback((Fl_Callback*)cb_Toggle);
					o->user_data((void *)myEditor);
				}
				o->end();
			}
			
			{
Fl_Item_Group* o = new Fl_Item_Group("&Search");
				
				{
Fl_Item* o = new Fl_Item("&Find");
					o->shortcut(0x40066);
					o->callback((Fl_Callback*)cb_Find, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				
				{
Fl_Item* o = new Fl_Item("Find &Again");
					o->shortcut(0xffc0);
					o->callback((Fl_Callback*)cb_Find1, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				new Fl_Divider();
				
				{
Fl_Item* o = new Fl_Item("&Replace");
					o->callback((Fl_Callback*)cb_Replace, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				o->end();
			}
			
			{
Fl_Item_Group* o = WindowMenu = new Fl_Item_Group("&Window");
				
				{
Fl_Item* o = new Fl_Item("&Next");
					o->callback((Fl_Callback*)cb_Next, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				
				{
Fl_Item* o = new Fl_Item("&Previous");
					o->callback((Fl_Callback*)cb_Previous, (void*)(NULL));
					o->user_data((void *)myEditor);
				}
				o->end();
			}
			o->end();
		}
		o->end();
	}
	long sessid = myEditor->Fl_MultiEditor::Session();
	AddToWindowMenu(myEditor, sessid, "&Window", MenuBar);
	myWindow->label(myEditor->SessionName());
	w->show(argc, argv);
	return  (Fl::run());
}
