#include "multiple.h"
#include <stdlib.h>
#include <fltk/fl_ask.h>

#define HOTKEYS "01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ"

// **************************************************
//						Callbacks
// **************************************************


static void cb_WindowMenu(Fl_Item *o, Fl_FancyMultiEditor *v) 
{
	fledit_SessionInfo *inf = v->FindSession(&o->label()[3]);
	if(inf)
	{
		v->Session(inf);
		myWindow->label(inf->SessionName->Get());
	}
}

void AddToWindowMenu(Fl_FancyMultiEditor *editor, long sessid, const char *menuname, Fl_Menu_ *menu)
{
	fledit_SessionInfo *info = editor->FindSession(sessid);
	if(info)
	{
		wString newmenuname(menuname);
		if(editor->GetSessionCount() < 36)
		{
			char buffer[2];
			buffer[1] = '\0';
			buffer[0] =  HOTKEYS[editor->GetSessionCount()];
			newmenuname += "/&";
			newmenuname += buffer;
			newmenuname += " ";
			newmenuname += info->SessionName->Get();
		}
		else
		{			// next line needs spaces so session name starts in right place
			newmenuname += "/   ";
			newmenuname += info->SessionName->Get();
		}
		*info->Caption = newmenuname;
		menu->add(info->Caption->Get(),0,(Fl_Callback *)cb_WindowMenu, (void *)editor, 0);
	}
}

void RemoveFromWindowMenu(Fl_FancyMultiEditor *editor, long sessid, Fl_Menu_* mainmenu, Fl_Item_Group* winmenu)
{
	int index = 0;
	fledit_SessionInfo *info = editor->FindSession(sessid);
	if(info)
	{
		int hkIndex = 0;
		for(int i=0; i < winmenu->children(); i++)
		{
			Fl_Widget *pWidget = winmenu->child(i);
			char *lbl = (char *)pWidget->label();
			if(strcmp(&lbl[3], info->Caption->Get()) == 0)
			{
				winmenu->remove(*pWidget);
				delete pWidget;
				continue;
			}
			if((lbl[0] == '&') && (lbl[2] == ' '))
				lbl[1] = HOTKEYS[hkIndex++];
		}
	}
	// have to remove this *last* since it may change our menu pointers
	if(index)
		mainmenu->remove(index);
}

void ChangeWindowMenu(Fl_FancyMultiEditor *editor, const char *oldname, Fl_Menu_* mainmenu, Fl_Item_Group* winmenu)
{
	fledit_SessionInfo *info = editor->FindSession(editor->Fl_MultiEditor::Session());
	if(info)
	{
		for(int i=0; i < winmenu->children(); i++)
		{
			Fl_Widget *pWidget = winmenu->child(i);
			char *lbl = (char *)pWidget->label();
			if(strcmp(&lbl[3], oldname) == 0)
			{
				wString newname(pWidget->label());
				newname.ChopAt(3);
				newname += info->SessionName->Get();
				*info->Caption = newname;
				myWindow->label(info->SessionName->Get());
				pWidget->copy_label(newname.Get());
				break;
			}
		}
	}
}

bool CloseSession(Fl_Menu_ *menu, Fl_Item_Group *WindowMenu, Fl_FancyMultiEditor *ed)
{
	bool OKtoclose = false;
	if(ed->changed())
	{
		int choice = fl_choice("\"%s\" has been modified.  Do you want to save it?",
 								"&Cancel", "&Yes", "&No", ed->SessionName());
		if(choice == 1)
		{
			const char *fn = ed->CurrentFileName();
			if (!fn || (!fn[0]))
			   fn = fl_file_chooser("Save As", NULL, NULL);
			if(fn)
			{
				ed->SaveCurrent(fn);
				OKtoclose = true;
			}
		}
		else if(choice == 2)
			OKtoclose = true;
	}
	else 
		OKtoclose = true;
	if(OKtoclose)
	{
		RemoveFromWindowMenu(ed, ed->Session(), menu, WindowMenu);
		ed->CloseCurrent();
		myWindow->label(ed->SessionName());
	}
	return(OKtoclose);
}

bool ExitOK(Fl_Menu_ *menu, Fl_Item_Group *WindowMenu, Fl_FancyMultiEditor *ed)
{
	bool OKtoExit = true;
	long sc = ed->ActiveSessions();
	while(sc-- && OKtoExit)
	{
		if(!CloseSession(menu, WindowMenu, ed))
			OKtoExit = false;
	}
	return(OKtoExit);
}


