/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Oct  4 10:30:58 EDT 2008 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 8 -dit -name hf2_8 -include hf.h */

/*
 * This function contains 74 FP additions, 50 FP multiplications,
 * (or, 44 additions, 20 multiplications, 30 fused multiply/add),
 * 70 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hf.h"

static const R *hf2_8(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 6, MAKE_VOLATILE_STRIDE(ios)) {
	  E T1m, T1l, T1k, Tw, T1w, T1u, T1v, TT, T1n, T1o;
	  {
	       E T2, T3, Tl, Tn, T5, T4, Tm, Tr, T6;
	       T2 = W[0];
	       T3 = W[2];
	       Tl = W[4];
	       Tn = W[5];
	       T5 = W[1];
	       T4 = T2 * T3;
	       Tm = T2 * Tl;
	       Tr = T2 * Tn;
	       T6 = W[3];
	       {
		    E T1, T1s, TG, TC, Tu, TY, Tk, TW, Td, T1r, Tx, TH, T1d, T14, TS;
		    E T18, T12, TD, TA;
		    {
			 E To, Ts, Tf, T7, Tp, Ti, Tb, Tq, Tt, Ta, TF, TB, T8, T9, Tc;
			 T1 = rio[0];
			 To = FMA(T5, Tn, Tm);
			 Ts = FNMS(T5, Tl, Tr);
			 Tf = FMA(T5, T6, T4);
			 T7 = FNMS(T5, T6, T4);
			 Ta = T2 * T6;
			 T1s = iio[-WS(ios, 7)];
			 Tp = rio[WS(ios, 6)];
			 TF = Tf * Tn;
			 TB = Tf * Tl;
			 Ti = FNMS(T5, T3, Ta);
			 Tb = FMA(T5, T3, Ta);
			 Tq = To * Tp;
			 Tt = iio[-WS(ios, 1)];
			 TG = FNMS(Ti, Tl, TF);
			 TC = FMA(Ti, Tn, TB);
			 {
			      E Tg, TX, Tj, Th, TV;
			      Tg = rio[WS(ios, 2)];
			      Tu = FMA(Ts, Tt, Tq);
			      TX = To * Tt;
			      Tj = iio[-WS(ios, 5)];
			      Th = Tf * Tg;
			      T8 = rio[WS(ios, 4)];
			      TY = FNMS(Ts, Tp, TX);
			      TV = Tf * Tj;
			      Tk = FMA(Ti, Tj, Th);
			      T9 = T7 * T8;
			      Tc = iio[-WS(ios, 3)];
			      TW = FNMS(Ti, Tg, TV);
			 }
			 {
			      E TK, TQ, TL, T1b, TM, TO, T1q, Ty, Tz;
			      TK = rio[WS(ios, 7)];
			      TQ = iio[-WS(ios, 4)];
			      Td = FMA(Tb, Tc, T9);
			      T1q = T7 * Tc;
			      TL = Tl * TK;
			      T1b = T3 * TQ;
			      TM = iio[0];
			      T1r = FNMS(Tb, T8, T1q);
			      TO = rio[WS(ios, 3)];
			      {
				   E TN, T1c, T1a, TR, T19, TP;
				   Tx = rio[WS(ios, 1)];
				   TN = FMA(Tn, TM, TL);
				   T19 = Tl * TM;
				   T1c = FNMS(T6, TO, T1b);
				   TP = T3 * TO;
				   Ty = T2 * Tx;
				   T1a = FNMS(Tn, TK, T19);
				   TH = iio[-WS(ios, 2)];
				   TR = FMA(T6, TQ, TP);
				   Tz = iio[-WS(ios, 6)];
				   T1m = T1a + T1c;
				   T1d = T1a - T1c;
				   T14 = TC * TH;
				   TS = TN + TR;
				   T18 = TN - TR;
				   T12 = T2 * Tz;
				   TD = rio[WS(ios, 5)];
			      }
			      TA = FMA(T5, Tz, Ty);
			 }
		    }
		    {
			 E Te, T1p, T1t, T10, T1g, Tv, TJ, T1i, T1e, T1z, T1B, T17, T1h;
			 {
			      E T1x, T16, T1y, T11;
			      {
				   E TU, T13, T15, TE, TZ, TI;
				   Te = T1 + Td;
				   TU = T1 - Td;
				   T13 = FNMS(T5, Tx, T12);
				   T15 = FNMS(TG, TD, T14);
				   TE = TC * TD;
				   T1p = TW + TY;
				   TZ = TW - TY;
				   T1x = T1s - T1r;
				   T1t = T1r + T1s;
				   T1l = T13 + T15;
				   T16 = T13 - T15;
				   TI = FMA(TG, TH, TE);
				   T10 = TU + TZ;
				   T1g = TU - TZ;
				   Tv = Tk + Tu;
				   T1y = Tk - Tu;
				   T11 = TA - TI;
				   TJ = TA + TI;
			      }
			      T1i = T18 + T1d;
			      T1e = T18 - T1d;
			      T1z = T1x - T1y;
			      T1B = T1y + T1x;
			      T17 = T11 + T16;
			      T1h = T16 - T11;
			 }
			 {
			      E T1j, T1A, T1f, T1C;
			      T1j = T1h - T1i;
			      T1A = T1h + T1i;
			      T1f = T17 + T1e;
			      T1C = T1e - T17;
			      iio[-WS(ios, 1)] = FMA(KP707106781, T1A, T1z);
			      rio[WS(ios, 5)] = FMS(KP707106781, T1A, T1z);
			      rio[WS(ios, 3)] = FMA(KP707106781, T1j, T1g);
			      iio[-WS(ios, 7)] = FNMS(KP707106781, T1j, T1g);
			      iio[-WS(ios, 3)] = FMA(KP707106781, T1C, T1B);
			      rio[WS(ios, 7)] = FMS(KP707106781, T1C, T1B);
			      rio[WS(ios, 1)] = FMA(KP707106781, T1f, T10);
			      iio[-WS(ios, 5)] = FNMS(KP707106781, T1f, T10);
			      T1k = Te - Tv;
			      Tw = Te + Tv;
			 }
			 T1w = T1t - T1p;
			 T1u = T1p + T1t;
			 T1v = TS - TJ;
			 TT = TJ + TS;
		    }
	       }
	  }
	  iio[-WS(ios, 2)] = T1v + T1w;
	  rio[WS(ios, 6)] = T1v - T1w;
	  rio[0] = Tw + TT;
	  iio[-WS(ios, 4)] = Tw - TT;
	  T1n = T1l - T1m;
	  T1o = T1l + T1m;
	  iio[0] = T1o + T1u;
	  rio[WS(ios, 4)] = T1o - T1u;
	  rio[WS(ios, 2)] = T1k + T1n;
	  iio[-WS(ios, 6)] = T1k - T1n;
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 7},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 8, "hf2_8", twinstr, &GENUS, {44, 20, 30, 0}, 0, 0, 0 };

void X(codelet_hf2_8) (planner *p) {
     X(khc2hc_register) (p, hf2_8, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 8 -dit -name hf2_8 -include hf.h */

/*
 * This function contains 74 FP additions, 44 FP multiplications,
 * (or, 56 additions, 26 multiplications, 18 fused multiply/add),
 * 42 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hf.h"

static const R *hf2_8(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 6, MAKE_VOLATILE_STRIDE(ios)) {
	  E T2, T5, T3, T6, T8, Tc, Tg, Ti, Tl, Tm, Tn, Tz, Tp, Tx;
	  {
	       E T4, Tb, T7, Ta;
	       T2 = W[0];
	       T5 = W[1];
	       T3 = W[2];
	       T6 = W[3];
	       T4 = T2 * T3;
	       Tb = T5 * T3;
	       T7 = T5 * T6;
	       Ta = T2 * T6;
	       T8 = T4 - T7;
	       Tc = Ta + Tb;
	       Tg = T4 + T7;
	       Ti = Ta - Tb;
	       Tl = W[4];
	       Tm = W[5];
	       Tn = FMA(T2, Tl, T5 * Tm);
	       Tz = FNMS(Ti, Tl, Tg * Tm);
	       Tp = FNMS(T5, Tl, T2 * Tm);
	       Tx = FMA(Tg, Tl, Ti * Tm);
	  }
	  {
	       E Tf, T1i, TL, T1d, TJ, T17, TV, TY, Ts, T1j, TO, T1a, TC, T16, TQ;
	       E TT;
	       {
		    E T1, T1c, Te, T1b, T9, Td;
		    T1 = rio[0];
		    T1c = iio[-WS(ios, 7)];
		    T9 = rio[WS(ios, 4)];
		    Td = iio[-WS(ios, 3)];
		    Te = FMA(T8, T9, Tc * Td);
		    T1b = FNMS(Tc, T9, T8 * Td);
		    Tf = T1 + Te;
		    T1i = T1c - T1b;
		    TL = T1 - Te;
		    T1d = T1b + T1c;
	       }
	       {
		    E TF, TW, TI, TX;
		    {
			 E TD, TE, TG, TH;
			 TD = rio[WS(ios, 7)];
			 TE = iio[0];
			 TF = FMA(Tl, TD, Tm * TE);
			 TW = FNMS(Tm, TD, Tl * TE);
			 TG = rio[WS(ios, 3)];
			 TH = iio[-WS(ios, 4)];
			 TI = FMA(T3, TG, T6 * TH);
			 TX = FNMS(T6, TG, T3 * TH);
		    }
		    TJ = TF + TI;
		    T17 = TW + TX;
		    TV = TF - TI;
		    TY = TW - TX;
	       }
	       {
		    E Tk, TM, Tr, TN;
		    {
			 E Th, Tj, To, Tq;
			 Th = rio[WS(ios, 2)];
			 Tj = iio[-WS(ios, 5)];
			 Tk = FMA(Tg, Th, Ti * Tj);
			 TM = FNMS(Ti, Th, Tg * Tj);
			 To = rio[WS(ios, 6)];
			 Tq = iio[-WS(ios, 1)];
			 Tr = FMA(Tn, To, Tp * Tq);
			 TN = FNMS(Tp, To, Tn * Tq);
		    }
		    Ts = Tk + Tr;
		    T1j = Tk - Tr;
		    TO = TM - TN;
		    T1a = TM + TN;
	       }
	       {
		    E Tw, TR, TB, TS;
		    {
			 E Tu, Tv, Ty, TA;
			 Tu = rio[WS(ios, 1)];
			 Tv = iio[-WS(ios, 6)];
			 Tw = FMA(T2, Tu, T5 * Tv);
			 TR = FNMS(T5, Tu, T2 * Tv);
			 Ty = rio[WS(ios, 5)];
			 TA = iio[-WS(ios, 2)];
			 TB = FMA(Tx, Ty, Tz * TA);
			 TS = FNMS(Tz, Ty, Tx * TA);
		    }
		    TC = Tw + TB;
		    T16 = TR + TS;
		    TQ = Tw - TB;
		    TT = TR - TS;
	       }
	       {
		    E Tt, TK, T1f, T1g;
		    Tt = Tf + Ts;
		    TK = TC + TJ;
		    iio[-WS(ios, 4)] = Tt - TK;
		    rio[0] = Tt + TK;
		    {
			 E T19, T1e, T15, T18;
			 T19 = T16 + T17;
			 T1e = T1a + T1d;
			 rio[WS(ios, 4)] = T19 - T1e;
			 iio[0] = T19 + T1e;
			 T15 = Tf - Ts;
			 T18 = T16 - T17;
			 iio[-WS(ios, 6)] = T15 - T18;
			 rio[WS(ios, 2)] = T15 + T18;
		    }
		    T1f = TJ - TC;
		    T1g = T1d - T1a;
		    rio[WS(ios, 6)] = T1f - T1g;
		    iio[-WS(ios, 2)] = T1f + T1g;
		    {
			 E T11, T1k, T14, T1h, T12, T13;
			 T11 = TL - TO;
			 T1k = T1i - T1j;
			 T12 = TT - TQ;
			 T13 = TV + TY;
			 T14 = KP707106781 * (T12 - T13);
			 T1h = KP707106781 * (T12 + T13);
			 iio[-WS(ios, 7)] = T11 - T14;
			 iio[-WS(ios, 1)] = T1h + T1k;
			 rio[WS(ios, 3)] = T11 + T14;
			 rio[WS(ios, 5)] = T1h - T1k;
		    }
		    {
			 E TP, T1m, T10, T1l, TU, TZ;
			 TP = TL + TO;
			 T1m = T1j + T1i;
			 TU = TQ + TT;
			 TZ = TV - TY;
			 T10 = KP707106781 * (TU + TZ);
			 T1l = KP707106781 * (TZ - TU);
			 iio[-WS(ios, 5)] = TP - T10;
			 iio[-WS(ios, 3)] = T1l + T1m;
			 rio[WS(ios, 1)] = TP + T10;
			 rio[WS(ios, 7)] = T1l - T1m;
		    }
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 7},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 8, "hf2_8", twinstr, &GENUS, {56, 26, 18, 0}, 0, 0, 0 };

void X(codelet_hf2_8) (planner *p) {
     X(khc2hc_register) (p, hf2_8, &desc);
}
#endif				/* HAVE_FMA */
