/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Oct  4 10:35:28 EDT 2008 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2r -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 5 -name hc2r_5 -include hc2r.h */

/*
 * This function contains 12 FP additions, 10 FP multiplications,
 * (or, 2 additions, 0 multiplications, 10 fused multiply/add),
 * 18 stack variables, and 10 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2r.ml,v 1.19 2006-02-12 23:34:12 athena Exp $
 */

#include "hc2r.h"

static void hc2r_5(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os, INT v, INT ivs, INT ovs)
{
     DK(KP1_902113032, +1.902113032590307144232878666758764286811397268);
     DK(KP1_118033988, +1.118033988749894848204586834365638117720309180);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     DK(KP618033988, +0.618033988749894848204586834365638117720309180);
     INT i;
     for (i = v; i > 0; i = i - 1, ri = ri + ivs, ii = ii + ivs, O = O + ovs, MAKE_VOLATILE_STRIDE(ris), MAKE_VOLATILE_STRIDE(iis), MAKE_VOLATILE_STRIDE(os)) {
	  E T1, T2, T3, Tc, Ta, T8, T9;
	  T8 = ii[WS(iis, 1)];
	  T9 = ii[WS(iis, 2)];
	  T1 = ri[0];
	  T2 = ri[WS(ris, 1)];
	  T3 = ri[WS(ris, 2)];
	  Tc = FMS(KP618033988, T8, T9);
	  Ta = FMA(KP618033988, T9, T8);
	  {
	       E T6, T4, T5, T7, Tb;
	       T6 = T2 - T3;
	       T4 = T2 + T3;
	       O[0] = FMA(KP2_000000000, T4, T1);
	       T5 = FNMS(KP500000000, T4, T1);
	       T7 = FMA(KP1_118033988, T6, T5);
	       Tb = FNMS(KP1_118033988, T6, T5);
	       O[WS(os, 4)] = FMA(KP1_902113032, Ta, T7);
	       O[WS(os, 1)] = FNMS(KP1_902113032, Ta, T7);
	       O[WS(os, 3)] = FMA(KP1_902113032, Tc, Tb);
	       O[WS(os, 2)] = FNMS(KP1_902113032, Tc, Tb);
	  }
     }
}

static const khc2r_desc desc = { 5, "hc2r_5", {2, 0, 10, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_hc2r_5) (planner *p) {
     X(khc2r_register) (p, hc2r_5, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2r -compact -variables 4 -pipeline-latency 4 -sign 1 -n 5 -name hc2r_5 -include hc2r.h */

/*
 * This function contains 12 FP additions, 7 FP multiplications,
 * (or, 8 additions, 3 multiplications, 4 fused multiply/add),
 * 18 stack variables, and 10 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2r.ml,v 1.19 2006-02-12 23:34:12 athena Exp $
 */

#include "hc2r.h"

static void hc2r_5(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os, INT v, INT ivs, INT ovs)
{
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     DK(KP1_118033988, +1.118033988749894848204586834365638117720309180);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP1_902113032, +1.902113032590307144232878666758764286811397268);
     DK(KP1_175570504, +1.175570504584946258337411909278145537195304875);
     INT i;
     for (i = v; i > 0; i = i - 1, ri = ri + ivs, ii = ii + ivs, O = O + ovs, MAKE_VOLATILE_STRIDE(ris), MAKE_VOLATILE_STRIDE(iis), MAKE_VOLATILE_STRIDE(os)) {
	  E Ta, Tc, T1, T4, T5, T6, Tb, T7;
	  {
	       E T8, T9, T2, T3;
	       T8 = ii[WS(iis, 1)];
	       T9 = ii[WS(iis, 2)];
	       Ta = FNMS(KP1_902113032, T9, KP1_175570504 * T8);
	       Tc = FMA(KP1_902113032, T8, KP1_175570504 * T9);
	       T1 = ri[0];
	       T2 = ri[WS(ris, 1)];
	       T3 = ri[WS(ris, 2)];
	       T4 = T2 + T3;
	       T5 = FNMS(KP500000000, T4, T1);
	       T6 = KP1_118033988 * (T2 - T3);
	  }
	  O[0] = FMA(KP2_000000000, T4, T1);
	  Tb = T6 + T5;
	  O[WS(os, 1)] = Tb - Tc;
	  O[WS(os, 4)] = Tb + Tc;
	  T7 = T5 - T6;
	  O[WS(os, 2)] = T7 - Ta;
	  O[WS(os, 3)] = T7 + Ta;
     }
}

static const khc2r_desc desc = { 5, "hc2r_5", {8, 3, 4, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_hc2r_5) (planner *p) {
     X(khc2r_register) (p, hc2r_5, &desc);
}

#endif				/* HAVE_FMA */
