/* evilwm - Minimalist Window Manager for X
 * Copyright (C) 1999-2002 Ciaran Anscomb <evilwm@6809.org.uk>
 * see README for license and other details. */

#include "evilwm.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif

void make_new_client(Window w) {
	Client *c;
	XWindowAttributes attr;
	long dummy;
	XWMHints *hints;
	char *name;

	XGrabServer(dpy);
#ifdef XDEBUG
	fprintf(stderr, "XGetWMHints(); ");
#endif
	hints = XGetWMHints(dpy, w);

	c = (Client *)malloc(sizeof(Client));
#ifdef SANITY
	tracked_count++;
#endif
	c->next = head_client;
	head_client = c;
#ifdef DEBUG
	{
		Client *p;
		int i = 0;
		for (p = head_client; p; p = p->next)
			i++;
		fprintf(stderr, "NEW: malloc(), window count now %d\n", i);
	}
#endif

	/* initialise(c, w); */
	c->window = w;
	c->ignore_unmap = 0;

	/* try these here instead */
	c->size = XAllocSizeHints();
#ifdef XDEBUG
	fprintf(stderr, "XGetWMNormalHints(); ");
#endif
	XGetWMNormalHints(dpy, c->window, c->size, &dummy);

	XFetchName(dpy, c->window, &name);

	XGetWindowAttributes(dpy, c->window, &attr);

	c->x = attr.x;
	c->y = attr.y;
	c->width = attr.width;
	c->height = attr.height;
	c->border = opt_bw;
	c->oldw = c->oldh = 0;
	/* blatant hack alert!  --kja3 */
	if (name) {
		if (!strncmp("XMMS", name, 4))
			c->border = 0;
		XFree(name);
	}
#ifdef COLOURMAP
	c->cmap = attr.colormap;
#endif
#ifdef VWM
	WR_DESK(c, GET_VDESK );
#endif

	// c->size = XAllocSizeHints();
	// XGetWMNormalHints(dpy, c->window, c->size, &dummy);

	if (attr.map_state == IsViewable) c->ignore_unmap++;
	else {
		init_position(c);
		if (hints && hints->flags & StateHint)
			set_wm_state(c, hints->initial_state);
	}

	if (hints) XFree(hints);

	/* client is initialised */

	gravitate(c);
	reparent(c);

#ifdef DEBUG
	if (wm_state(c) == IconicState) {
		fprintf(stderr, "NEW: client thinks it's iconised\n");
	}
#endif
	XMapWindow(dpy, c->window);
	XMapRaised(dpy, c->parent);
	set_wm_state(c, NormalState);

	XSync(dpy, False);
	XUngrabServer(dpy);
#ifndef MOUSE
	setmouse(c->window, c->width + c->border - 1,
			c->height + c->border - 1);
#endif
}

void init_position(Client *c) {
#ifdef MOUSE
	int x, y;
#endif
	int xmax = DisplayWidth(dpy, screen);
	int ymax = DisplayHeight(dpy, screen);

	if (c->size->flags & (/*PSize | */USSize)) {
		c->width = c->size->width;
		c->height = c->size->height;
	}

	if (c->width < MINSIZE) c->width = MINSIZE;
	if (c->height < MINSIZE) c->height = MINSIZE;
	if (c->width > xmax) c->width = xmax;
	if (c->height > ymax) c->height = ymax;

	if (c->size->flags & (/*PPosition | */USPosition)) {
		c->x = c->size->x;
		c->y = c->size->y;
		if (c->x < 0 || c->y < 0 || c->x > xmax || c->y > ymax)
			c->x = c->y = c->border;
	} else {
#ifdef MOUSE
		get_mouse_position(&x, &y);
		c->x = (x * (xmax - c->border - c->width)) / xmax;
		c->y = (y * (ymax - c->border - c->height)) / ymax;
#else
		c->x = c->y = 0;
#endif
	}
}

void reparent(Client *c) {
	XSetWindowAttributes p_attr;

#ifdef COLOURMAP
	XSelectInput(dpy, c->window, ColormapChangeMask | EnterWindowMask | PropertyChangeMask);
#else
	XSelectInput(dpy, c->window, EnterWindowMask | PropertyChangeMask);
#endif

	p_attr.override_redirect = True;
	p_attr.background_pixel = bg.pixel;
	p_attr.event_mask = ChildMask | ButtonPressMask | ExposureMask | EnterWindowMask;
	c->parent = XCreateWindow(dpy, root, c->x-c->border, c->y-c->border,
		c->width+(c->border*2), c->height + (c->border*2), 0,
		DefaultDepth(dpy, screen), CopyFromParent,
		DefaultVisual(dpy, screen),
		CWOverrideRedirect | CWBackPixel | CWEventMask, &p_attr);
#ifdef SHAPE
	if (have_shape) {
	    XShapeSelectInput(dpy, c->window, ShapeNotifyMask);
	    set_shape(c);
	}
#endif

	XAddToSaveSet(dpy, c->window);
	XSetWindowBorderWidth(dpy, c->window, 0);
	XReparentWindow(dpy, c->window, c->parent, c->border, c->border);

	send_config(c);
}
