/* evilwm - Minimalist Window Manager for X
 * Copyright (C) 1999-2002 Ciaran Anscomb <evilwm@6809.org.uk>
 * see README for license and other details. */

#include "evilwm.h"
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <X11/cursorfont.h>
#include <stdio.h>
#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif

Display		*dpy;
Client		*current = NULL;
int		screen;
Window		root;
GC		invert_gc;
XFontStruct	*font;
Client		*head_client;
Atom		xa_wm_state;
Atom		xa_wm_change_state;
Atom		xa_wm_protos;
Atom		xa_wm_delete;
Atom		xa_wm_cmapwins;
Cursor		move_curs;
Cursor		resize_curs;
char		*opt_display = "";
char		*opt_font = DEF_FONT;
char		*opt_fg = DEF_FG;
char		*opt_bg = DEF_BG;
char		*opt_term;
int		opt_bw = DEF_BW;
#ifdef VWM
XColor		fg, bg, fc;
char		*opt_fc = DEF_FC;
# ifndef VDESK_BOTH
 int		vdesk = XK_1;
# endif
#else
XColor		fg, bg;
#endif /* def VWM */
#ifdef SANITY
int		tracked_count = 0;
#endif
#ifdef SHAPE
int		have_shape, shape_event;
#endif
#ifdef VDESK_BOTH
Atom	vdesk_desktop;
char * vdesk_property_name = DEF_VDESK_PROP;
#endif
int		quitting = 0;

int main(int argc, char *argv[]) {
	struct sigaction act;
	int i;
	XEvent ev;

	for (i = 1; i < argc; i++) {
		if (!strcmp(argv[i], "-fn") && i+1<argc)
			opt_font = argv[++i];
		else if (!strcmp(argv[i], "-display") && i+1<argc)
			opt_display = argv[++i];
		else if (!strcmp(argv[i], "-fg") && i+1<argc)
			opt_fg = argv[++i];
		else if (!strcmp(argv[i], "-bg") && i+1<argc)
			opt_bg = argv[++i];
#ifdef VWM
		else if (!strcmp(argv[i], "-fc") && i+1<argc)
			opt_fc = argv[++i];
#endif
#ifdef VDESK_BOTH
		else if (!strcmp(argv[i], "-deskprop") && i+1<argc)
			vdesk_property_name = argv[++i];
#endif
		else if (!strcmp(argv[i], "-bw") && i+1<argc)
			opt_bw = atoi(argv[++i]);
		else if (!strcmp(argv[i], "-term") && i+1<argc) {
			opt_term = argv[++i];
#ifdef STDIO
		} else if (!strcmp(argv[i], "-V")) {
			printf("evilwm version " VERSION "\n");
			exit(0);
#endif
		} else {
#ifdef STDIO
			printf("usage: evilwm [-display display] [-term termprog] [-fg foreground]\n");
			printf("\t[-bg background] [-bw borderwidth] [-V]\n");
# ifdef VDESK_BOTH
			printf("\t[-deskprop name]\n");
# endif
#endif
			exit(2);
		}
	}

	act.sa_handler = handle_signal;
	sigemptyset(&act.sa_mask);
/* #ifdef SA_NOCLDSTOP */
/*	act.sa_flags = SA_NOCLDSTOP; */ /* don't care about STOP, CONT */
/* #else */
	act.sa_flags = 0;
/* #endif */
	sigaction(SIGTERM, &act, NULL);
	sigaction(SIGINT, &act, NULL);
	sigaction(SIGHUP, &act, NULL);
	/* sigaction(SIGCHLD, &act, NULL); */ /* handling this differently */

	setup_display();

#ifdef SHAPE
	have_shape = XShapeQueryExtension(dpy, &shape_event, &i);
#endif

	scan_windows();

	/* main event loop here */
	for (;;) {
#ifdef SANITY
		sanity_check();
#endif
		XNextEvent(dpy, &ev);
		switch (ev.type) {
			case KeyPress:
				handle_key_event(&ev.xkey); break;
#ifdef MOUSE
			case ButtonPress:
				handle_button_event(&ev.xbutton); break;
#endif
			case ConfigureRequest:
				handle_configure_request(&ev.xconfigurerequest); break;
			case MapRequest:
				handle_map_request(&ev.xmaprequest); break;
#ifdef VDESK
			case ClientMessage:
				handle_client_message(&ev.xclient); break;
#endif
#ifdef COLOURMAP
			case ColormapNotify:
				handle_colormap_change(&ev.xcolormap); break;
#endif
			case EnterNotify:
				handle_enter_event(&ev.xcrossing); break;
			case PropertyNotify:
				handle_property_change(&ev.xproperty); break;
			case UnmapNotify:
				handle_unmap_event(&ev.xunmap); break;
			/* case Expose:
				handle_expose_event(&ev.xexpose); break; */
			default:
#ifdef SHAPE
				if (have_shape && ev.type == shape_event) {
					handle_shape_event((XShapeEvent *)&ev);
				}
#endif
		}
	}
	return 1;
}

void setup_display() {
	XGCValues gv;
	XSetWindowAttributes attr;
	XColor dummy;
	int *i;
	int keys_to_grab[] = {
		KEY_NEW, KEY_KILL,
		KEY_TOPLEFT, KEY_TOPRIGHT, KEY_BOTTOMLEFT, KEY_BOTTOMRIGHT,
		KEY_LEFT, KEY_RIGHT, KEY_DOWN, KEY_UP,
		KEY_LOWER, KEY_ALTLOWER, KEY_INFO, KEY_MAXVERT, KEY_MAX,
#ifdef VWM
		KEY_FIX, KEY_PREVDESK, KEY_NEXTDESK,
		XK_1, XK_2, XK_3, XK_4, XK_5, XK_6, XK_7, XK_8,
#endif
		0
	};

#ifdef XDEBUG
	fprintf(stderr, "main:XOpenDisplay(); ");
#endif
	dpy = XOpenDisplay(opt_display);
	if (!dpy) { 
#ifdef STDIO
		fprintf(stderr, "can't open display %s\n", opt_display);
#endif
		exit(1);
	}
	XSetErrorHandler(handle_xerror);

	screen = DefaultScreen(dpy);
	root = RootWindow(dpy, screen);

	xa_wm_state = XInternAtom(dpy, "WM_STATE", False);
	xa_wm_change_state = XInternAtom(dpy, "WM_CHANGE_STATE", False);
	xa_wm_protos = XInternAtom(dpy, "WM_PROTOCOLS", False);
	xa_wm_delete = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
#ifdef COLOURMAP
	xa_wm_cmapwins = XInternAtom(dpy, "WM_COLORMAP_WINDOWS", False);
#endif
#ifdef VDESK_BOTH
	vdesk_desktop = XInternAtom(dpy, vdesk_property_name, False);
	SET_VDESK(1);
#endif

	XAllocNamedColor(dpy, DefaultColormap(dpy, screen), opt_fg, &fg, &dummy);
	XAllocNamedColor(dpy, DefaultColormap(dpy, screen), opt_bg, &bg, &dummy);
#ifdef VWM
	XAllocNamedColor(dpy, DefaultColormap(dpy, screen), opt_fc, &fc, &dummy);
#endif

	font = XLoadQueryFont(dpy, opt_font);
	if (!font) font = XLoadQueryFont(dpy, DEF_FONT);

	move_curs = XCreateFontCursor(dpy, XC_fleur);
	resize_curs = XCreateFontCursor(dpy, XC_plus);

	gv.function = GXinvert;
	gv.subwindow_mode = IncludeInferiors;
	gv.line_width = 1;  /* opt_bw */
	gv.font = font->fid;
	invert_gc = XCreateGC(dpy, root, GCFunction | GCSubwindowMode | GCLineWidth | GCFont, &gv);

	attr.event_mask = ChildMask | PropertyChangeMask
#ifdef COLOURMAP
		| ColormapChangeMask
#endif
#ifdef MOUSE
		| ButtonMask
#endif
		;
	XChangeWindowAttributes(dpy, root, CWEventMask, &attr);
	/* Unfortunately grabbing AnyKey under Solaris seems not to work */
	/* XGrabKey(dpy, AnyKey, ControlMask|Mod1Mask, root, True, GrabModeAsync, GrabModeAsync); */
	/* So now I grab each and every one. */
	for (i = keys_to_grab; *i; i++) {
		XGrabKey(dpy, XKeysymToKeycode(dpy, *i), ControlMask|Mod1Mask, root, True, GrabModeAsync, GrabModeAsync);
		XGrabKey(dpy, XKeysymToKeycode(dpy, *i), Mod3Mask|ControlMask|Mod1Mask, root, True, GrabModeAsync, GrabModeAsync);
	}
	XGrabKey(dpy, XKeysymToKeycode(dpy, XK_Tab), Mod1Mask, root, True, GrabModeAsync, GrabModeAsync);
	XGrabKey(dpy, XKeysymToKeycode(dpy, XK_Tab), Mod3Mask|Mod1Mask, root, True, GrabModeAsync, GrabModeAsync);
}

void scan_windows() {
	unsigned int i, nwins;
	Window dw1, dw2, *wins;
	XWindowAttributes attr;

#ifdef XDEBUG
	fprintf(stderr, "main:XQueryTree(); ");
#endif
	XQueryTree(dpy, root, &dw1, &dw2, &wins, &nwins);
#ifdef XDEBUG
	fprintf(stderr, "%d windows\n", nwins);
#endif
	for (i = 0; i < nwins; i++) {
		XGetWindowAttributes(dpy, wins[i], &attr);
		if (!attr.override_redirect && attr.map_state == IsViewable)
			make_new_client(wins[i]);
	}
	XFree(wins);
}
