#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif

#include "keymap.h"

/* default settings */

#define DEF_VDESK_PROP "VDESK_DESKTOP"
#define DEF_FONT	"lucidasans-10"
#define DEF_FG		"goldenrod"
#define DEF_BG		"grey50"
#define DEF_BW		1
#define DEF_FC		"blue"
#define SPACE		3
#define MINSIZE		15
#ifdef DEBIAN
#define DEF_TERM	"x-terminal-emulator"
#else
#define DEF_TERM	"xterm"
#endif /* def DEBIAN */

/* readability stuff */
#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif

#define RAISE		1
#define NO_RAISE	0	/* for unhide() */

/* some coding shorthand */

#define ChildMask	(SubstructureRedirectMask|SubstructureNotifyMask)
#define ButtonMask	(ButtonPressMask|ButtonReleaseMask)
#define MouseMask	(ButtonMask|PointerMotionMask)

#define grab(w, mask, curs) \
	(XGrabPointer(dpy, w, False, mask, GrabModeAsync, GrabModeAsync, \
	None, curs, CurrentTime) == GrabSuccess)
#define setmouse(w, x, y) \
	XWarpPointer(dpy, None, w, 0, 0, 0, 0, x, y)
#define gravitate(c) \
	change_gravity(c, 1)
#define ungravitate(c) \
	change_gravity(c, -1)

/* client structure */

typedef struct Client Client;

struct Client {
	Client	*next;
	Window	window;
	Window	parent;

#ifdef COLOURMAP
	Colormap	cmap;
#endif
	XSizeHints	*size;
	int		ignore_unmap;

	int		x, y, width, height;
	int		oldx, oldy, oldw, oldh;  /* used when maximising */
	int		border;
#ifdef VWM
# ifndef VDESK_BOTH
	int		vdesk;
# endif
#endif /* def VWM */
};

/* declarations for global variables in main.c */

extern Display		*dpy;
extern Client		*current;
extern int		screen;
extern Window		root;
extern GC		invert_gc;
extern XFontStruct	*font;
extern Client		*head_client;
extern Atom		xa_wm_state;
extern Atom		xa_wm_change_state;
extern Atom		xa_wm_protos;
extern Atom		xa_wm_delete;
extern Atom		xa_wm_cmapwins;
extern Cursor		move_curs;
extern Cursor		resize_curs;
extern char		*opt_display;
extern char		*opt_font;
extern char		*opt_fg;
extern char		*opt_bg;
extern char		*opt_term;
extern int		opt_bw;
#ifdef VWM
extern XColor		fg, bg, fc;
extern char		*opt_fc;
# ifndef VDESK_BOTH
 extern int		vdesk;
# endif
#else
extern XColor		fg, bg;
#endif /* def VWM */
#ifdef SANITY
extern int		tracked_count;
#endif
#ifdef SHAPE
extern int		have_shape, shape_event;
#endif
#ifdef VDESK_BOTH
extern Atom vdesk_desktop;
#endif
extern int		quitting;

/* client.c */

Client *find_client(Window w);
int wm_state(Client *c);
void change_gravity(Client *c, int multiplier);
void remove_client(Client *c);
void send_config(Client *c);
void send_wm_delete(Client *c);
void set_wm_state(Client *c, int state);
void set_shape(Client *c);
#ifdef VDESK_BOTH
void wr_vdesk(Window win, int state);
int rd_vdesk(Window win);
void fix_visibility_hack(Window win);
#endif

/* events.c */

void handle_key_event(XKeyEvent *e);
void handle_button_event(XButtonEvent *e);
/* static void handle_client_message(XClientMessageEvent *e); */
#ifdef COLOURMAP
void handle_colormap_change(XColormapEvent *e);
#endif
void handle_configure_request(XConfigureRequestEvent *e);
void handle_enter_event(XCrossingEvent *e);
void handle_map_request(XMapRequestEvent *e);
void handle_property_change(XPropertyEvent *e);
void handle_unmap_event(XUnmapEvent *e);
#ifdef SHAPE
void handle_shape_event(XShapeEvent *e);
#endif

/* main.c */

int main(int argc, char *argv[]);
void scan_windows();
void setup_display();

/* misc.c */
#ifdef SANITY
void sanity_check();
#endif

/* void do_event_loop(); */
int handle_xerror(Display *dpy, XErrorEvent *e);
int ignore_xerror(Display *dpy, XErrorEvent *e);
void dump_clients();
void spawn(char *cmd);
void handle_signal(int signo);
#ifdef DEBUG
void show_event(XEvent e);
#endif

/* new.c */

void init_position(Client *c);
void make_new_client(Window w);
void reparent(Client *c);

/* screen.c */

void drag(Client *c);
void draw_outline(Client *c);
void get_mouse_position(int *x, int *y);
void move(Client *c, int set);
void recalculate_sweep(Client *c, int x1, int y1, int x2, int y2);
void resize(Client *c, int set);
void maximise_vert(Client *c);
void maximise_horiz(Client *c);
void show_info(Client *c, KeySym key);
void sweep(Client *c);
void unhide(Client *c, int raise);
void next(Client *c);
#ifdef VWM
void hide(Client *c);
void switch_vdesk(int v);
#else
# ifdef VDESK
 void hide(Client *c);
# endif
#endif /* def VWM */
#ifdef VDESK
void handle_client_message(XClientMessageEvent *e);
#endif
#ifdef VDESK_BOTH
# define WR_DESK( desk, value ) wr_vdesk( (desk)->window, value)
# define RD_DESK( desk ) rd_vdesk( (desk)->window )
# define GET_VDESK rd_vdesk(root)
# define STICKY 0
# define KEY_TO_VDESK( key ) ( ( key ) - XK_1 + 1 )
# define SET_VDESK( value ) wr_vdesk(root, value)
#else
# define WR_DESK( desk, value ) ( (desk)->vdesk = value )
# define RD_DESK( desk ) ( (desk)->vdesk )
# define GET_VDESK vdesk
# define STICKY -1
# define KEY_TO_VDESK( key ) ( key )
# define SET_VDESK( value ) ( vdesk = value )
#endif
