/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * main.c
 * yipee
 */
#ifndef USE_APPLET
#include <gtk/gtk.h>
#else
#include <applet-widget.h>
#include "pixmaps/ebicon.xpm"
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <fcntl.h>
#if defined( _WIN32 )
#include <direct.h>
#define mkdir( x, y )	_mkdir( x )
#else
#include <unistd.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif
#include <errno.h>
#include "status.h"
#include "service.h"
#include "globals.h"
#include "account.h"
#include "dialog.h"
#include "util.h"
#include "libproxy/libproxy.h"
#include "console_session.h"

void eb_show_contact_list() { }

/* Global variable, referenced in globals.h */
char config_dir[1024] = "";


#ifdef USE_APPLET
	GtkWidget * applet;
	GtkWidget * applet_pixmap;

static void hide_window(GtkWidget * widget, GdkEvent * event, gpointer d)
{
	static int hidden = 0;
	printf("event\n");
	if(event->button.type == GDK_2BUTTON_PRESS && event->button.button == 1 && statuswindow)
	{
		if(hidden)
		{
			gtk_widget_show(statuswindow);
			hidden = 0;
		}
		else
		{
			gtk_widget_hide(statuswindow);
			hidden = 1;
		}
	}
}
#endif

void start_login()
{
   	if (!load_accounts())
   		eb_new_user();
   	else
 	{
		eb_show_contact_list();
		eb_status_window();
	}
}
 
int main(int argc, char *argv[])
{

    int c = 0;
	int res;
	int sock;
	int len;
	struct sockaddr_un local;
	char message[4096] = "";
	char contact[256] = "";
    gchar buff[1024];
	struct stat stat_buf;
#ifdef USE_APPLET
	GdkPixmap * icon_pm;
	GdkPixmap * icon_bm;
#endif

	
    geometry[0] = 0;
#ifndef USE_APPLET
	gtk_set_locale();
	gtk_init(&argc, &argv);
#else /* USE_APPLET */

	#define PACKAGE "everybuddy"
	applet_widget_init(PACKAGE, VERSION, argc, argv, NULL, 0, NULL);
#endif /* USE_APPLET */

/* Setup default value for config_dir */
#if defined( _WIN32 )
	strcpy(config_dir, "C:\\.everybuddy\\");
#else
	g_snprintf(config_dir, 1024, "%s/.everybuddy/",getenv("HOME"));
#endif

#ifdef HAVE_GETOPT_H
    while (1) 
	{
		static struct option long_options[] = 
		{
	    	{"version", no_argument, NULL, 'v'},
		{"help", no_argument, NULL, 'h'},
	    	{"geometry", required_argument, NULL, 'G'},
	    	{"activate-goad-server", required_argument, NULL, 'a'},
	    	{"contact", required_argument, NULL, 'c'},
	    	{"message", required_argument, NULL, 'm'},
	    	{"config-dir", required_argument, NULL, 'd'},
	    	{0, 0, 0, 0}
		};
    
		int option_index = 0;

		/* Detect the end of the options. */

		if (c == -1)
		{
			break;
		}

		c = getopt_long(argc, argv, "vhGa:Dcm", long_options, &option_index);

		switch (c) 
		{
		    case 'v':           /* version information */
		
			printf("EveryBuddy v%s\n", VERSION); 
			printf("Copyright (C) 1999 Torrey Searle\n");
			printf("EveryBuddy comes with NO WARRANTY, to the extent permitted by law.\n");
			printf("You may redistribute copies of EveryBuddy under the terms of the\n");
			printf("GNU General Public License.  For more information about these\n");
			printf("matters, see the file named COPYING.\n");
			printf("\nEveryBuddy is brought to you by: Torrey Searle, \n");
			printf("Jared Peterson, Ben Rigas, Jeff Miller, and Troy Morrison.\n");
			printf("\nFor more information on EveryBuddy, visit the website at\n");
			printf("         http://www.everybuddy.com/\n");
			exit(0);
		    
		    case 'h':           /* help information */
		    case '?':
			printf("Usage: everybuddy [OPTION]...\n");
			printf("An integrated instant messenger program.\n");
			printf("Supports AOL Instant Messenger, ICQ, and Yahoo! Messenger.\n\n");
			printf("  -g, --geometry             Set position of main event window\n");
			printf("      --help                 display this help and exit\n");
			printf("      --version              output version information and exit\n");
			printf("      --config-dir           specify configuration directory\n");
			printf("\nReport bugs to tsearle@uci.edu or\n");
			printf("http://www.akropolys.com/cgi-bin/eb-bugs\n");
			exit(0);

		    case 'G':
			strcpy(geometry, optarg);
			break;


		    case ':':
			printf("Try 'everybuddy --help' for more information.\n");
			exit(0);

			case 'a':
			printf("hi\n");
			break;

			case 'c':
			strcpy(contact, optarg);
			break;

			case 'm':
			strcpy(message, optarg);
			break;

			case 'd':
			strcpy(config_dir, optarg);
			/*Make sure we have directory delimiter */
#if defined( _WIN32 )
			if(config_dir[strlen(config_dir)-1]!='\\')
				strcat(config_dir, "\\");
#else
			if(config_dir[strlen(config_dir)-1]!='/')
				strcat(config_dir, "/");
#endif
			if(stat(config_dir, &stat_buf)==-1)
			{
				perror(config_dir);
				exit(errno);
			}
			if(!S_ISDIR(stat_buf.st_mode))
			{
				printf("config-dir %s is not a directory!\n", config_dir);
				exit(1);
			}
			break;

		}
    } 

#endif

	if(strlen(message) > 0 && strlen(contact) > 0)
	{
		struct sockaddr_un remote;
		int sock;
		short length;
		int ret;

		sock = socket(AF_UNIX, SOCK_STREAM, 0);
		strcpy(remote.sun_path, config_dir);
		strcat(remote.sun_path, "eb_socket");
		remote.sun_family = AF_UNIX;
		len = strlen(remote.sun_path) + sizeof(remote.sun_family);
		if(connect(sock, (struct sockaddr*)&remote, len) == -1 )
		{
			perror("connect");
			exit(1);
		}
		length = strlen(contact)+1;
		write(sock, &length, sizeof(short));
		write(sock, contact, length);
		length = strlen(message)+1;
		write(sock, &length, sizeof(short));
		write(sock, message, length);
		read(sock, &ret, sizeof(int));
		close(sock);
		exit(ret);
	}
	g_snprintf(buff, 1024, "%s",config_dir);
	services_init();
		
	mkdir(buff, 0700);
	g_snprintf(buff, 1024, "%slogs",config_dir);
	mkdir(buff, 0700);
	g_snprintf(buff, 1024, "%sfiles",config_dir);
	mkdir(buff, 0700);

	sock = socket(AF_UNIX, SOCK_STREAM, 0);
	strcpy(local.sun_path, config_dir);
	strcat(local.sun_path, "eb_socket");
	unlink(local.sun_path);
	local.sun_family = AF_UNIX;
	len = strlen(local.sun_path) + sizeof(local.sun_family);
	if(bind(sock, (struct sockaddr *)&local, len) == -1)
	{
		perror("bind");
		exit(1);
	}
	if(listen(sock, 5) == -1)
	{
		perror("listen");
		exit(1);
	}
	gdk_input_add(sock, GDK_INPUT_READ, console_session_init, NULL);

	//proxy_set_proxy( PROXY_NONE, "", 0 );
	//proxy_set_proxy(PROXY_SOCKS5,"24.0.201.225",1080);

	system("update.pl");
	system("contact-update.pl");
	load_contacts();
	eb_read_prefs();

	res = need_proxy_auth();
	if ( res == -2 )
		do_proxy_auth_dialog( "Proxy Authorization Needed", "Proxy Authorization Needed" );
	else if ( res == -1 ) {
		/* FIXME Dont exit here. If error in proxy config, we wont be able to
		 * change the config also. */
		printf( "Error. Cannot connect to proxy.\n" );
		exit( 1 );
	} else  if ( res >= 0 )
		start_login();

#ifndef USE_APPLET
    gtk_main();
#else
	applet = applet_widget_new(PACKAGE);
	gtk_widget_set_events( applet, gtk_widget_get_events(applet) |
			               GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK );
	gtk_signal_connect(GTK_OBJECT(applet),"button_press_event", GTK_SIGNAL_FUNC(hide_window), NULL);
	gtk_widget_realize(applet);
	icon_pm = gdk_pixmap_create_from_xpm_d(applet->window, &icon_bm,
			                          NULL, (gchar **)ebicon);
	applet_pixmap = gtk_pixmap_new(icon_pm, icon_bm);
	applet_widget_add(APPLET_WIDGET(applet), applet_pixmap);
	gtk_widget_show(applet_pixmap);
	gtk_widget_show(applet);
	
	applet_widget_gtk_main();
#endif
		
	return 0;

}
