############################################################################
#                                                                          #
#  ettercap -- etter.passive.os.fp -- passive OS fingerprint database      #
#                                                                          #
#  Copyright (C) 2001  ALoR <alor@users.sourceforge.net>                   #
#                      NaGA <crwm@freemail.it>                             #
#                                                                          #
#  This program is free software; you can redistribute it and/or modify    #
#  it under the terms of the GNU General Public License as published by    #
#  the Free Software Foundation; either version 2 of the License, or       #
#  (at your option) any later version.                                     #
#                                                                          #
############################################################################
#                                                                          #
#  Last updated on : $Date: 2001/09/15 15:29:03 $                          #
#  Total entries   : 433                                                   #
#                                                                          #
############################################################################
#                                                                          #
# The fingerprint database has the following structure:                    #
#                                                                          #
# WWWW:MSS:TTL:WS:S:N:D:T:F:OS                                             #
#                                                                          #
# WWWW: 4 digit hex field indicating the TCP Window Size                   #
# MSS : 4 digit hex field indicating the TCP Option Maximum Segment Size   #
#       if omitted in the packet or unknown it is "_MSS"                   #
# TTL : 2 digit hex field indicating the IP Time To Live                   #
# WS  : 2 digit hex field indicating the TCP Option Window Scale           #
#       if omitted in the packet or unknown it is "WS"                     #
# S   : 1 digit field indicating if the TCP Option SACK permitted is true  #
# N   : 1 digit field indicating if the TCP Options contain a NOP          #
# D   : 1 digit field indicating if the IP Don't Fragment flag is set      #
# T   : 1 digit field indicating if the TCP Timestamp is present           #
# F   : 1 digit ascii field indicating the flag of the packet              #
#       S = SYN                                                            #
#       A = SYN + ACK                                                      #
# OS  : an ascii string representing the OS                                #
#                                                                          #
# IF YOU FIND A NEW FINGERPRING, PLEASE MAIL IT US WITH THE RESPECTIVE OS  #
# or use the appropriate form at:                                          #
#    http://ettercap.sourceforge.net/index.php?s=stuff&p=fingerprint       #
#                                                                          #
############################################################################

0000:_MSS:80:00:0:0:0:0:A:Tandem NSK D39
0000:_MSS:80:WS:0:0:0:0:A:3Com Access Builder 4000 7.2
0040:_MSS:80:WS:0:0:0:0:A:Gold Card Ethernet Interface Firmware Ver. 3.19 (95.01.16)
0046:_MSS:80:WS:0:0:0:0:A:Cyclades PathRouter
0096:_MSS:80:WS:0:0:0:0:A:Cyclades PathRouter V 1.2.4
0100:_MSS:80:WS:0:0:0:0:A:Allied Telesyn AT-S10 version 3.0 on an AT-TS24TR hub
0100:_MSS:80:WS:0:0:1:0:A:Xyplex Network9000
0200:0000:40:WS:0:0:0:0:S:Linux 2.0.35 - 2.0.37
0200:05B4:40:00:0:0:0:0:S:Linux 2.0.38
0200:05B4:40:34:0:0:0:0:S:Linux 2.0.33
0200:_MSS:80:00:0:0:0:0:A:Linux 2.0.32-34
0200:_MSS:80:00:0:1:0:0:A:Bay Networks BLN-2 Network Router or ASN Processor revision 9
0200:_MSS:80:00:0:1:0:1:A:Bay Networks BLN-2 Network Router or ASN Processor revision 9
0200:_MSS:80:WS:0:0:0:0:A:3COM / USR TotalSwitch Firmware: 02.02.00R
0212:_MSS:80:00:0:0:0:0:A:Linux 2.0.32-34
0212:_MSS:80:00:0:1:1:0:A:Solaris 2.6 - 2.7
0212:_MSS:80:00:0:1:1:1:A:Solaris 2.6 - 2.7
0212:_MSS:80:WS:0:0:0:0:A:CacheOS (CacheFlow 2000 proxy cache)
0212:_MSS:80:WS:0:0:1:0:A:Linux 2.2.5 - 2.2.13 SMP
0212:_MSS:80:WS:0:1:0:0:A:NetBSD 1.4 running on a SPARC IPX
0212:_MSS:80:WS:0:1:0:1:A:NetBSD 1.4 running on a SPARC IPX
0212:_MSS:80:WS:0:1:1:0:A:NetBSD 1.4 / Generic mac68k (Quadra 610)
0212:_MSS:80:WS:0:1:1:1:A:NetBSD 1.4 / Generic mac68k (Quadra 610)
0244:_MSS:80:WS:0:0:0:0:A:Cyclades PathRouter/PC
03CA:_MSS:80:WS:0:0:0:0:A:MPE/iX 5.5
03F2:_MSS:80:00:0:0:0:0:A:Lexmark Optra S Printer
03F2:_MSS:80:WS:0:0:0:0:A:Lexmark Optra S Printer
03F6:_MSS:80:WS:0:0:0:0:A:Lexmark Optra S Printer
0400:_MSS:80:00:0:1:0:0:A:Bay Networks BLN-2 Network Router or ASN Processor revision 9
0400:_MSS:80:00:0:1:0:1:A:Bay Networks BLN-2 Network Router or ASN Processor revision 9
0400:_MSS:80:WS:0:0:0:0:A:3com Office Connect Router 810
0400:_MSS:80:WS:0:0:1:0:A:Aironet 630-2400 V3.3P Wireless LAN bridge
0424:_MSS:80:WS:0:0:0:0:A:Intel InBusiness Print Station
0430:_MSS:80:WS:0:0:0:0:A:PacketShaper 4000 v4.1.3b2 2000-04-05
0578:_MSS:80:WS:0:0:0:0:A:Minix 32-bit/Intel 2.0.0
05B4:_MSS:80:00:0:1:0:0:A:HP JetDirect Card (J4169A) in an HP LaserJet 8150
05B4:_MSS:80:WS:0:0:0:0:A:TOPS-20 Monitor 7(102540)-1,TD-1
05B4:_MSS:80:WS:0:1:1:0:A:Network Appliance NetCache 5.1D4
05B4:_MSS:80:WS:0:1:1:1:A:Network Appliance NetCache 5.1D4
05DC:_MSS:80:WS:0:0:0:0:A:Gandalf LanLine Router
0600:_MSS:80:WS:0:0:0:0:A:Chase IOLAN Terminal Server v3.5.02 CDi
0640:_MSS:80:WS:0:0:0:0:A:APC MasterSwitch Network Power Controller
0648:_MSS:80:WS:0:0:0:0:A:FastComm FRAD F9200-DS-DNI -- Ver. 4.2.3A
06C2:_MSS:80:WS:0:0:0:0:A:Cyclades PathRAS Remote Access Server v1.1.8 - 1.3.12
0700:_MSS:80:00:0:0:0:0:A:Lantronix ETS16P Version V3.5/2(970721)
0700:_MSS:80:WS:0:0:0:0:A:Lantronix ETS16P Version V3.5/2(970721)
073F:_MSS:80:00:0:0:0:0:A:Novell NetWare 3.12 or 386 TCP/IP
073F:_MSS:80:WS:0:0:0:0:A:CLIX R3.1 Vr.7.6.20 6480
07D0:_MSS:80:00:0:0:1:0:A:Novell NetWare 3.12 - 5.00
07D0:_MSS:80:WS:0:0:1:0:A:Novell NetWare 3.12 - 5.00
0800:_MSS:80:00:0:0:0:0:A:KA9Q
0800:_MSS:80:00:0:0:0:1:A:KA9Q
0800:_MSS:80:WS:0:0:0:0:A:3Com Access Builder 4000 7.2
0800:_MSS:80:WS:0:0:1:0:A:HP Procurve Routing Switch 9304M
0808:_MSS:80:WS:0:0:0:0:A:Siemens HICOM 300 Phone switch (WAML LAN card)
0848:_MSS:80:WS:0:0:0:0:A:Intergraph Workstation (2000 Series) running CLiX R3.1
0860:0218:40:00:1:1:1:0:S:Windows 9x (4)
0860:0218:FF:WS:0:0:0:0:S:Cisco IGS 3000 IOS 11.x(16), 2500 IOS 11.2(3)P
0860:05B4:FF:WS:0:0:0:0:A:IOS Version 10.3(15) - 11.1(20)
0860:_MSS:80:00:0:0:0:0:A:HP JetDirect  Firmware Rev. H.06.00
0860:_MSS:80:00:0:1:1:0:A:Windows NT4 / Win95 / Win98
0860:_MSS:80:00:0:1:1:1:A:Windows NT4 / Win95 / Win98
0860:_MSS:80:WS:0:0:0:0:A:Chase IOLan Terminal Server
0A28:_MSS:80:WS:0:0:0:0:A:Apple Color LaserWrite 600 Printer
0B63:_MSS:80:00:0:1:1:0:A:Linux 2.1.19 - 2.2.17
0B63:_MSS:80:00:0:1:1:1:A:Linux 2.1.19 - 2.2.17
0B68:_MSS:40:WS:0:0:1:0:A:Linux 2.0.32 - 2.0.34
0B68:_MSS:80:00:0:1:1:0:A:Sun Solaris 8 early acces beta through actual release
0B68:_MSS:80:00:0:1:1:1:A:Sun Solaris 8 early acces beta through actual release
0B68:_MSS:80:WS:0:0:0:0:A:D-Link Print Server
0BB8:_MSS:80:00:0:1:0:0:A:OpenVMS 7.1 Alpha running Digital's UCX v4.1ECO2 TCP/IP package
0C00:_MSS:80:WS:0:0:0:0:A:Canon photocopier/fax/scanner/printer GP30F
0C90:_MSS:80:WS:0:0:0:0:A:HP JetDirect Print Server
0E00:_MSS:80:WS:0:0:0:0:A:Lantronix EPS1 Version V3.5/1(970325)
0F87:_MSS:80:00:0:0:0:0:A:Novell NetWare 3.12 or 386 TCP/IP
0F87:_MSS:80:WS:0:0:0:0:A:A/UX 3.1.1 SVR2 or OpenStep 4.2
0F87:_MSS:80:WS:0:0:1:0:A:AIX 4.3
0FA0:_MSS:80:WS:0:0:0:0:A:MultiTech CommPlete (modem server) RAScard
1000:0400:1E:F5:0:0:0:0:S:Alcatel (Xylan) OmniStack 5024 v3.4.5
1000:0400:1E:WS:0:0:0:0:S:Chorus MiX V.3.2 r4.1.5 COMP-386
1000:0400:20:F5:0:0:0:0:S:Alcatel (Xylan) OmniStack 5024
1000:_MSS:40:WS:0:0:0:0:A:SCO UnixWare 2.1.2
1000:_MSS:80:00:0:0:0:0:A:CABLETRON Systems, Incorporated, Module Firmware Revision: 01.01.01
1000:_MSS:80:00:0:0:1:0:A:OpenVMS/Alpha 7.1 using Process Software's TCPWare V5.3-4
1000:_MSS:80:00:0:1:0:0:A:Alcatel 1000 ADSL (modem)
1000:_MSS:80:00:0:1:0:1:A:Alcatel 1000 ADSL (modem)
1000:_MSS:80:WS:0:0:0:0:A:Aironet AP4800E v8.07 - Aironet (Cisco?) 11 Mbps wireless access point
1000:_MSS:80:WS:0:0:1:0:A:VirtualAccess LinxpeedPro 120 running Software 7.4.33CM
1020:022C:FF:00:0:0:0:0:S:Cisco 1750 IOS 12.0(5), Cisco 2500 IOS 11.3(1)
1020:05B4:FF:WS:0:0:0:0:S:Cisco 2611 IOS 11.3(2)XA4
1020:_MSS:80:WS:0:0:0:0:A:AS5200
1020:_MSS:FF:WS:0:0:1:0:A:Cisco IOS
10C0:0218:FF:WS:0:0:0:0:S:Cisco 1600 IOS 11.2(15)P
10C0:05B4:FF:WS:0:0:0:0:S:Cisco 3620 IOS 11.2(17)P
10C0:_MSS:80:WS:0:0:0:0:A:Cisco 1600/3640/7513 Router (IOS 11.2(14)P)
111C:_MSS:80:WS:0:0:0:0:A:Ascend/Lucent Max (HP,4000-6000) version 6.1.3 - 7.0.2+
111C:_MSS:80:WS:0:0:1:0:A:Apple LaserWriter 16/600 PS, HP 6P, or HP 5 Printer
165C:_MSS:80:WS:0:0:1:0:A:SCO Release 5
1680:_MSS:80:00:0:1:1:1:A:Linux 2.4.7 (X86)
16A0:05B4:40:00:1:1:1:0:A:Linux 2.4.2
16A0:05B4:40:00:1:1:1:1:A:Linux 2.4.0 - Linux 2.4.9
16A0:_MSS:80:00:0:1:1:0:A:Linux Kernel 2.4.0 - 2.4.9 (X86)
16A0:_MSS:80:00:0:1:1:1:A:Linux Kernel 2.4.0 - 2.4.9 (X86)
16D0:0218:80:00:1:1:1:0:S:Windows 95 (3)
16D0:05B4:40:00:1:1:1:0:A:Linux 2.4.0 - Linux 2.4.9
16D0:05B4:40:00:1:1:1:0:S:Linux 2.4.0 - Linux 2.4.9
16D0:05B4:40:00:1:1:1:1:S:Linux 2.4.0 - Linux 2.4.9
16D0:_MSS:80:00:0:0:0:0:A:HP Color LaserJet 4500N, Jet Direct J3113A/2100
16D0:_MSS:80:00:0:1:1:0:A:Windows NT4 / Win95 / Win98
16D0:_MSS:80:00:0:1:1:1:A:Windows NT4 / Win95 / Win98
16D0:_MSS:80:WS:0:0:0:0:A:HP Color LaserJet 4500N, Jet Direct J3113A/2100
16D0:_MSS:80:WS:0:0:1:0:A:Linux 2.4.7 (X86)
1800:_MSS:40:WS:0:0:1:0:A:VMS MultiNet V4.2(16) / OpenVMS V7.1-2
1800:_MSS:80:00:0:1:0:0:A:OpenVMS 6.2 - 7.2-1 on VAX or AXP
1800:_MSS:80:00:0:1:0:1:A:OpenVMS 6.2 - 7.2-1 on VAX or AXP
1800:_MSS:80:00:0:1:1:0:A:VMS MultiNet V4.2(16)/ OpenVMS V7.1-2
1800:_MSS:80:00:0:1:1:1:A:VMS MultiNet V4.2(16)/ OpenVMS V7.1-2
1800:_MSS:80:WS:0:0:0:0:A:IPAD Model 5000 or V.1.52
1800:_MSS:80:WS:0:0:1:0:A:Novell Netware 5.0 SP5
192F:_MSS:80:00:0:0:0:0:A:Mac OS 7.0-7.1 With MacTCP 1.1.1 - 2.0.6
192F:_MSS:80:WS:0:0:0:0:A:Mac OS 7.0-7.1 With MacTCP 1.1.1 - 2.0.6
1AB8:0564:40:WS:1:1:1:0:A:IRIX
1C84:_MSS:80:WS:0:0:0:0:A:Instant Internet box
1D4C:_MSS:80:WS:0:0:0:0:A:Sega Dreamcast
1F0E:_MSS:80:WS:0:0:0:0:A:AmigaOS AmiTCP/IP 4.3
1FFF:_MSS:80:00:0:0:1:0:A:Novell NetWare 3.12 - 5.00
1FFF:_MSS:80:WS:0:0:1:0:A:NetWare 4.11 SP7- 5 SP3A BorderManager 3.5
2000:0200:40:WS:0:0:0:0:A:QNX / Amiga OS
2000:0218:80:00:1:1:1:0:S:Windows 9x (2)
2000:05B0:20:WS:0:0:1:0:S:Windows 95 (?)
2000:05B0:80:00:1:1:1:0:S:Linux 2.2.13
2000:05B4:20:00:0:0:1:0:S:Windows NT 4.0
2000:05B4:20:WS:0:0:1:0:S:Windows 95
2000:05B4:40:00:0:1:1:0:S:BSDI BSD/OS 3.1
2000:05B4:40:WS:0:0:1:0:S:AXCENT Raptor Firewall Windows NT 4.0/SP3
2000:05B4:80:00:0:0:1:0:S:Windows NT 4.0
2000:05B4:80:00:1:1:1:0:S:Windows 9x (1)
2000:05B4:80:WS:1:0:1:0:S:Windows NT
2000:6363:80:WS:1:1:1:0:S:Microsoft NT 4.0 Server SP5
2000:_MSS:40:WS:0:0:1:0:A:BSDI BSD/OS
2000:_MSS:80:00:0:0:0:0:A:IBM VM/ESA 2.2.0 CMS Mainframe System
2000:_MSS:80:00:0:0:1:0:A:Novell NetWare 3.12 - 5.00
2000:_MSS:80:00:0:1:0:0:A:Accelerated Networks - High Speed Integrated Access VoDSL
2000:_MSS:80:00:0:1:0:1:A:Tandem NSK D40
2000:_MSS:80:00:0:1:1:0:A:AS/400e 720 running OS/400 R4.4
2000:_MSS:80:00:0:1:1:1:A:AS/400e 720 running OS/400 R4.4
2000:_MSS:80:WS:0:0:0:0:A:AGE Logic, Inc. IBM XStation
2000:_MSS:80:WS:0:0:1:0:A:Windows NT / Win9x
2010:_MSS:80:WS:0:0:1:0:A:Windows NT / Win9x
2017:05B4:40:00:0:1:1:1:A:BSDI BSD/OS 3.0-3.1 (or possibly MacOS, NetBSD)
2017:_MSS:80:00:0:1:0:0:A:Ascend GRF Router running Ascend Embedded/OS 2.1
2017:_MSS:80:00:0:1:0:1:A:Ascend GRF Router running Ascend Embedded/OS 2.1
2017:_MSS:80:00:0:1:1:0:A:BSDI 4.0-4.0.1
2017:_MSS:80:00:0:1:1:1:A:BSDI 4.0-4.0.1
2017:_MSS:80:WS:0:0:0:0:A:CacheOS (CacheFlow 500-5000 webcache) CFOS 2.1.08 - 2.2.1
2017:_MSS:80:WS:0:0:1:0:A:3Com NetBuilder & NetBuilder II OS v 9.3
2058:0564:80:WS:0:0:1:0:A:Windows 2000
2058:_MSS:80:WS:0:0:1:0:A:Windows NT / Win9x
2120:_MSS:80:WS:0:0:1:0:A:Gauntlet 4.0a firewall on Solaris 2.5.1
2180:_MSS:20:WS:0:0:1:0:A:Windows NT / Win9x
2180:_MSS:40:WS:0:0:1:0:A:BSDI BSD/OS
2180:_MSS:80:WS:0:0:1:0:A:Windows NT / Win9x
2190:_MSS:20:WS:0:0:1:0:A:Windows NT / Win9x
2190:_MSS:80:WS:0:0:1:0:A:Windows NT / Win9x
21D2:_MSS:80:WS:0:0:1:0:A:Windows NT / Win9x
2200:_MSS:80:00:0:1:0:0:A:Stock OpenVMS 7.1
2200:_MSS:80:00:0:1:0:1:A:Stock OpenVMS 7.1
2200:_MSS:80:00:0:1:1:0:A:OpenVMS 6.2/Alpha
2200:_MSS:80:00:0:1:1:1:A:OpenVMS 6.2/Alpha
2200:_MSS:80:WS:0:0:0:0:A:Linux 2.0.34-38
2220:_MSS:40:WS:0:0:1:0:A:BSDI BSD/OS
2220:_MSS:80:WS:0:0:1:0:A:Windows NT / Win9x
2229:_MSS:80:00:0:0:1:0:A:Solaris 2.5, 2.5.1
2229:_MSS:80:WS:0:0:0:0:A:DG/UX Release R4.11MU02
2229:_MSS:80:WS:0:0:1:0:A:Solaris 2.3 - 2.4
2238:0564:FF:00:0:0:1:0:S:Solaris 2.7
2238:05B4:40:00:0:0:1:0:S:Solaris 2.6 (2)
2238:05B4:40:WS:0:0:1:0:A:BSDI BSD/OS 3.0-3.1 (or possibly MacOS, NetBSD)
2238:05B4:20:WS:0:0:0:0:A:Snap Server (Quantum)
2238:05B4:80:WS:0:0:1:0:A:Windows NT 4.x / Win9x
2238:05B4:FF:00:0:0:1:0:S:Solaris 2.6 or 2.7
2238:_MSS:40:WS:0:0:1:0:A:BSDI BSD/OS
2238:_MSS:80:WS:0:0:0:0:A:HP printer w/JetDirect card
2238:_MSS:80:WS:0:0:1:0:A:Windows 2000 Professional, Build 2128
2238:_MSS:FF:WS:0:0:1:0:A:Solaris 2.6 - 2.7
2297:_MSS:80:00:0:1:1:0:A:Raptor Firewall 6 on Solaris 2.6
2297:_MSS:80:00:0:1:1:1:A:Raptor Firewall 6 on Solaris 2.6
2328:_MSS:FF:WS:0:0:1:0:A:Solaris 2.6 - 2.7
2332:_MSS:80:00:0:0:1:0:A:Solaris 2.3 - 2.4
2332:_MSS:80:WS:0:0:0:0:A:Solaris 2.4 w/most Sun patches
2332:_MSS:80:WS:0:0:1:0:A:Solaris 2.3 - 2.4
239C:_MSS:80:WS:0:0:0:0:A:Apollo Domain/OS SR10.4
23B4:23B4:FF:00:0:0:1:0:S:Solaris 2.6 (sunsite)
2400:_MSS:FF:WS:0:0:1:0:A:Solaris 2.6 - 2.7
2491:_MSS:80:00:0:1:1:0:A:Solaris 2.6 - 2.7 with tcp_strong_iss=0
2491:_MSS:80:00:0:1:1:1:A:Solaris 2.6 - 2.7 with tcp_strong_iss=0
2544:_MSS:80:00:0:0:1:0:A:Solaris 2.3 - 2.4
2756:_MSS:80:WS:0:0:0:0:A:AmigaOS AmiTCP/IP Genesis 4.6
2788:_MSS:80:00:0:1:1:0:A:Solaris 2.6 - 2.7
2788:_MSS:80:00:0:1:1:1:A:Solaris 2.6 - 2.7
2798:05B4:FF:00:0:1:1:0:A:Solaris
2798:_MSS:FF:WS:0:0:1:0:A:Solaris 2.6 - 2.7
2D24:_MSS:80:00:0:1:1:1:A:Linux Kernel 2.4.0 - 2.4.9 (X86)
2D25:_MSS:80:WS:0:0:0:0:A:Mac OS 7.0-7.1 With MacTCP 1.1.1 - 2.0.6
2DA0:_MSS:80:WS:0:0:0:0:A:Windows 98SE + IE5.5sp1
3000:_MSS:80:WS:0:0:0:0:A:Acorn Risc OS 3.6 (Acorn TCP/IP Stack 4.07)
37FF:_MSS:80:WS:0:0:0:0:A:Linux 1.2.13
3C00:_MSS:80:WS:0:0:0:0:A:Linux 2.0.27 - 2.0.30
3C0A:_MSS:80:00:0:1:1:0:A:Linux 2.1.19 - 2.2.17
3C0A:_MSS:80:00:0:1:1:1:A:Linux 2.1.19 - 2.2.17
3E43:_MSS:80:00:0:1:0:0:A:AIX 4.1-4.1.5
3E43:_MSS:80:00:0:1:0:1:A:AIX 4.1-4.1.5
3E80:_MSS:80:WS:0:0:0:0:A:Alcatel Advanced Reflexes IP Phone, Version: E/AT400/46.8
3E80:_MSS:80:WS:0:0:1:0:A:VersaNet ISP-Accelerator(TM) Remote Access Server
3EBC:05B4:40:00:1:1:1:0:S:Debian/Caldera Linux 2.2.x (check)
3EBC:_MSS:40:WS:0:0:1:0:A:AIX 4.02.0001.0000, AIX 4.2
3F25:_MSS:80:00:0:1:0:0:A:AIX 4.3.2.0-4.3.3.0 on an IBM RS/*
3F25:_MSS:80:00:0:1:0:1:A:AIX 4.3.2.0-4.3.3.0 on an IBM RS/*
3F25:_MSS:80:00:0:1:1:0:A:Linux 2.1.19 - 2.2.17
3F25:_MSS:80:00:0:1:1:1:A:Linux 2.1.19 - 2.2.17
3F25:_MSS:80:WS:0:0:0:0:A:AIX 3.2
3F25:_MSS:80:WS:0:0:1:0:A:Linux 2.2.19
3FE0:_MSS:80:00:0:0:0:0:A:Linux 2.0.32-34
3FF0:_MSS:80:00:0:0:0:0:A:Linux 2.0.34-38
3FF0:_MSS:80:WS:0:0:0:0:A:AtheOS ( www.atheos.cx )
3FFF:_MSS:80:WS:0:0:0:0:A:IBM MVS (unknown version)
4000:0000:40:WS:0:0:0:0:S:ULTRIX V4.5 (Rev. 47)
4000:0200:40:00:0:0:0:0:S:AIX 3.2, 4.2 - 4.3
4000:0200:40:00:0:1:0:0:S:OpenBSD 2.6
4000:05B4:40:00:0:0:1:0:S:FreeBSD 4.0-STABLE, 3.2-RELEASE
4000:05B4:40:00:0:1:0:0:S:NetBSD 1.3/i386
4000:05B4:40:00:0:1:1:0:S:FreeBSD 2.2.8-RELEASE
4000:05B4:40:WS:0:0:1:0:S:FreeBSD 4.2
4000:05B4:80:00:1:1:1:0:S:Windows 2000
4000:05B4:80:WS:1:1:1:0:S:Windows 2000 / ME
4000:05B4:FF:00:0:1:1:0:S:FreeBSD 2.2.6-RELEASE
4000:_MSS:40:WS:0:0:0:0:A:NetBSD 1.3 - 1.33 / AIX 4.3.X
4000:_MSS:80:00:0:0:0:0:A:IBM MVS (unknown version)
4000:_MSS:80:00:0:0:1:0:A:OpenVMS 7.1 using Process Software's TCPWare 5.3 TCP/IP package
4000:_MSS:80:00:0:1:0:0:A:Check Point FireWall-1 4.0 SP-5 (IPSO build)
4000:_MSS:80:00:0:1:0:1:A:Check Point FireWall-1 4.0 SP-5 (IPSO build)
4000:_MSS:80:00:0:1:1:1:A:Linux Kernel 2.4.0 - 2.4.9 (X86)
4000:_MSS:80:WS:0:0:0:0:A:Auspex Fileserver (AuspexOS 1.9.1/SunOS 4.1.4)
4000:_MSS:80:WS:0:0:1:0:A:AmigaOS Miami 3.0
402E:05B4:80:00:0:1:1:1:A:Windows 2000 Professional
402E:_MSS:80:00:0:1:0:0:A:FreeBSD 2.1.0 - 2.1.5
402E:_MSS:80:00:0:1:0:1:A:FreeBSD 2.1.0 - 2.1.5
402E:_MSS:80:00:0:1:1:0:A:D-Link DI-701, Version 2.22
402E:_MSS:80:00:0:1:1:1:A:D-Link DI-701, Version 2.22
402E:_MSS:80:WS:0:0:0:0:A:OpenBSD 2.1/X86
402E:_MSS:80:WS:0:0:1:0:A:AmigaOS Miami 2.1-3.0
402E:_MSS:80:WS:0:1:1:0:A:Windows XP Professional Release
403D:_MSS:80:00:0:1:0:0:A:FreeBSD 2.1.0 - 2.1.5
403D:_MSS:80:00:0:1:0:1:A:FreeBSD 2.1.0 - 2.1.5
403D:_MSS:80:00:0:1:1:0:A:Acorn RiscOS 3.7 using AcornNet TCP/IP stack
403D:_MSS:80:00:0:1:1:1:A:Acorn RiscOS 3.7 using AcornNet TCP/IP stack
4074:_MSS:40:WS:0:0:0:0:A:OpenBSD 2.x
4150:_MSS:40:WS:0:0:1:0:A:Cisco Localdirector 430, running OS 2.1
4240:_MSS:80:00:0:0:1:0:A:MacOS 8.1
43E0:05B4:40:00:0:1:1:0:A:FreeBSD 4.x
43E0:_MSS:40:WS:0:0:0:0:A:OpenBSD 2.x
43E0:_MSS:40:WS:0:0:1:0:A:FreeBSD 2.2.1 - 4.0
4431:_MSS:80:00:0:1:1:0:A:Solaris 2.6 - 2.7
4431:_MSS:80:00:0:1:1:1:A:Solaris 2.6 - 2.7
4452:_MSS:80:00:0:0:1:0:A:Solaris 2.5, 2.5.1
4470:05B4:40:00:1:1:0:0:A:Windows 2000
4470:05B4:40:WS:0:0:1:0:A:FreeBSD 4.2
4470:05B4:80:00:1:1:0:1:A:Windows 2000 Professional
4470:05B4:80:00:1:1:1:0:A:Windows 2000 Professional
4470:05B4:80:00:1:1:1:1:A:Windows 2000 Professional
4470:_MSS:40:WS:0:0:0:0:A:FreeBSD 2.2.1 - 4.0
4470:_MSS:40:WS:0:0:1:0:A:FreeBSD 2.2.1 - 4.0
4470:_MSS:80:00:0:1:1:0:A:Windows NT4 / Win95 / Win98
4470:_MSS:80:00:0:1:1:1:A:Windows NT4 / Win95 / Win98
4470:_MSS:80:WS:0:0:0:0:A:Snap Network Box
4470:_MSS:80:WS:0:0:1:0:A:Windows 2000 RC1
455B:_MSS:80:00:0:0:0:0:A:MacOS 8.1 running on a PowerPC G3 (iMac)
455B:_MSS:80:00:0:0:1:0:A:Mac OS 8.6
462B:_MSS:80:00:0:1:1:0:A:Solaris 2.6 - 7 X86
462B:_MSS:80:00:0:1:1:1:A:Solaris 2.6 - 7 X86
5B40:_MSS:80:WS:0:0:0:0:A:Polycom ViewStation 512K videoconferencing system
6000:_MSS:80:00:0:0:0:0:A:SCO OpenServer(TM) Release 5
6000:_MSS:80:00:0:0:1:0:A:OpenVMS v7.1 VAX
6000:_MSS:80:00:0:1:1:0:A:Sequent DYNIX/ptx(R) V4.4.6
60DA:_MSS:80:00:0:1:1:0:A:Sun Solaris 8 early acces beta through actual release
60DA:_MSS:80:00:0:1:1:1:A:Sun Solaris 8 early acces beta through actual release
60F4:05B4:40:00:0:0:1:0:S:SCO UnixWare 7.0.1
60F4:05B4:40:00:0:1:1:0:S:SCO UnixWare 7.1.0 x86
60F4:_MSS:40:WS:0:0:1:0:A:SCO OpenServer 5.0.5
60F4:_MSS:80:00:0:1:0:0:A:NCR MP-RAS SVR4 UNIX System Version 3
60F4:_MSS:80:00:0:1:0:1:A:NCR MP-RAS SVR4 UNIX System Version 3
60F4:_MSS:80:00:0:1:1:0:A:NCR MP-RAS 3.01
60F4:_MSS:80:00:0:1:1:1:A:NCR MP-RAS 3.01
60F4:_MSS:80:WS:0:0:0:0:A:SCO UnixWare 7.0.0 or OpenServer 5.0.4-5
61A8:_MSS:80:00:0:1:1:0:A:Windows NT4 / Win95 / Win98
61A8:_MSS:80:00:0:1:1:1:A:Windows NT4 / Win95 / Win98
6FCC:_MSS:80:WS:0:0:0:0:A:IBM OS/2 V 2.1
7000:_MSS:80:WS:0:0:0:0:A:IBM OS/2 V.3
70D5:_MSS:80:00:0:1:1:0:A:Digital UNIX OSF1 V 4.0-4.0F
77C4:_MSS:40:WS:0:0:1:0:A:Linux 2.1.122 - 2.2.14
7900:_MSS:80:00:0:1:1:0:A:Atari Mega STE running JIS-68k 3.0
7900:_MSS:80:00:0:1:1:1:A:Atari Mega STE running JIS-68k 3.0
7960:0F2C:40:00:1:1:1:0:S:Linux 2.2.12-20 (RH 6.1)
7B2F:_MSS:80:00:0:1:1:0:A:Linux 2.1.19 - 2.2.17
7B2F:_MSS:80:00:0:1:1:1:A:Linux 2.1.19 - 2.2.17
7BC0:_MSS:40:WS:0:0:1:0:A:Linux 2.1.122 - 2.2.14
7BF0:_MSS:40:WS:0:0:1:0:A:Linux 2.1.122 - 2.2.14
7C00:_MSS:80:00:0:0:0:0:A:Linux 2.0.27 - 2.0.30
7C00:_MSS:80:WS:0:0:0:0:A:Convex OS Release 10.1
7C38:_MSS:80:00:0:1:1:0:A:Linux 2.1.19 - 2.2.17
7C38:_MSS:80:00:0:1:1:1:A:Linux 2.1.19 - 2.2.17
7C70:05B4:40:00:1:1:1:0:S:Linux 2.4.0-test1
7C70:_MSS:80:00:0:1:1:0:A:Linux 2.3.28-33
7C70:_MSS:80:00:0:1:1:1:A:Linux 2.3.28-33
7D78:05B4:20:00:1:1:1:0:S:Linux 2.2.13
7D78:05B4:3A:WS:0:0:0:0:S:Linux 2.0.38
7D78:05B4:40:00:1:1:1:0:A:Linux 2.2.19
7D78:05B4:40:00:1:1:1:0:S:Linux 2.2.14 - 2.2.19
7D78:05B4:40:00:1:1:1:1:A:Linux 2.2.14 - 2.2.19
7D78:05B4:40:00:1:1:1:1:S:Linux 2.2.14 - 2.2.19
7D78:05B4:40:65:1:1:1:0:S:Linux 2.2.15
7D78:05B4:40:BE:1:1:1:0:S:Linux 2.2.16
7D78:05B4:40:WS:0:0:0:0:S:Linux 2.0.33
7D78:05B4:40:WS:0:0:1:0:A:Linux 2.2.19
7D78:05B4:40:WS:1:1:1:0:A:Linux 2.2.19
7D78:_MSS:40:WS:0:0:1:0:A:Linux 2.1.122 - 2.2.14
7E18:_MSS:80:00:0:1:1:0:A:Linux Kernel 2.4.0-test5
7E18:_MSS:80:00:0:1:1:1:A:Linux Kernel 2.4.0-test5
7F53:_MSS:80:00:0:0:0:0:A:AIX 4.0 - 4.2
7F53:_MSS:80:00:0:1:1:0:A:Linux 2.1.19 - 2.2.17
7F53:_MSS:80:00:0:1:1:1:A:Linux 2.1.19 - 2.2.17
7F53:_MSS:80:WS:0:0:0:0:A:AIX 3.2
7F53:_MSS:80:WS:0:0:1:0:A:Linux Kernel 2.1.88
7F7D:_MSS:80:00:0:1:1:0:A:Linux 2.1.91 - 2.1.103
7F7D:_MSS:80:00:0:1:1:1:A:Linux 2.1.91 - 2.1.103
7FB6:0218:FF:00:0:0:0:0:S:3Com HiPer ARC, System V4.2.32
7FB8:0218:40:00:1:1:0:0:S:SCO UnixWare 7.1.0 x86
7FE0:_MSS:40:WS:0:0:0:0:A:Linux 2.0.34 - 2.0.38
7FE0:_MSS:80:00:0:0:0:0:A:Linux 2.0.32-34
7FE0:_MSS:80:WS:0:0:0:0:A:Cobalt Linux 4.0 (Fargo) Kernel 2.0.34C52_SK on MIPS
7FF0:_MSS:80:00:0:0:0:0:A:Linux 2.0.34-38
7FFF:_MSS:80:00:0:0:1:0:A:Linux 2.4.7 (X86)
7FFF:_MSS:80:00:0:1:0:0:A:ReliantUNIX-Y 5.44 B0033 RM600 1/256 R10000
7FFF:_MSS:80:00:0:1:1:0:A:Linux Kernel 2.4.0 - 2.4.9 (X86)
7FFF:_MSS:80:00:0:1:1:1:A:Linux Kernel 2.4.0 - 2.4.9 (X86)
7FFF:_MSS:80:WS:0:0:0:0:A:SINIX-Y 5.43B0045
7FFF:_MSS:80:WS:0:0:1:0:A:Linux 2.1.76
8000:0200:40:00:0:1:0:0:A:Mac OS X Server
8000:0598:40:00:0:0:0:0:S:??? (PlusGSM, InterNetia proxy)
8000:05B4:40:00:0:0:1:0:S:HP-UX B.10.01 A 9000/712
8000:05B4:40:00:0:1:0:0:A:NetBSD
8000:05B4:40:00:0:1:1:0:A:HP-UX
8000:05B4:40:00:0:1:1:0:S:Digital UNIX V4.0E
8000:05B4:80:WS:0:0:1:0:S:Novell NetWare 4.11
8000:_MSS:80:00:0:0:1:0:A:Novell NetWare 3.12 - 5.00
8000:_MSS:80:00:0:1:0:0:A:Cray UNICOS 9.0.1ai - 10.0.0.2
8000:_MSS:80:00:0:1:0:1:A:Cray UNICOS 9.0.1ai - 10.0.0.2
8000:_MSS:80:00:0:1:1:0:A:Apple MacOS 9.04 (Powermac or G4)
8000:_MSS:80:00:0:1:1:1:A:Apple MacOS 9.04 (Powermac or G4)
8000:_MSS:80:WS:0:0:0:0:A:DECNIS 600 V4.1.3B System
8000:_MSS:80:WS:0:0:1:0:A:Cisco IOS 12.0(3.3)S  (perhaps a 7200)
805C:_MSS:80:00:0:1:0:0:A:BSDI BSD/OS 2.0 - 2.1
805C:_MSS:80:00:0:1:0:1:A:BSDI BSD/OS 2.0 - 2.1
805C:_MSS:80:00:0:1:1:0:A:Compaq Tru64 UNIX (formerly Digital UNIX) 4.0e
807A:_MSS:80:00:0:1:0:0:A:OpenBSD 2.6-2.8
807A:_MSS:80:00:0:1:0:1:A:OpenBSD 2.6-2.8
807A:_MSS:80:00:0:1:1:0:A:AmigaOS 3.1 running Miami Deluxe 0.9m
807A:_MSS:80:00:0:1:1:1:A:AmigaOS 3.1 running Miami Deluxe 0.9m
81D0:_MSS:40:WS:0:0:1:0:A:Compaq Tru64 UNIX 5.0
8218:05B4:40:01:1:1:1:0:A:Solaris 8
832C:05B4:40:00:0:1:1:0:A:Compaq Tru64 UNIX 5.0
832C:05B4:FF:WS:0:0:1:0:S:Solaris 7
832C:_MSS:40:WS:0:0:1:0:A:Linux 2.0.34 - 2.0.38
8371:_MSS:80:00:0:1:1:0:A:Solaris 2.6 - 2.7
8371:_MSS:80:00:0:1:1:1:A:Solaris 2.6 - 2.7
8377:_MSS:80:00:0:0:1:0:A:Solaris 2.5, 2.5.1
869F:_MSS:80:00:0:1:1:0:A:Windows NT4 / Win95 / Win98
869F:_MSS:80:00:0:1:1:1:A:Windows NT4 / Win95 / Win98
8765:_MSS:80:00:0:1:1:0:A:Solaris 2.6 - 2.7 with tcp_strong_iss=0
8765:_MSS:80:00:0:1:1:1:A:Solaris 2.6 - 2.7 with tcp_strong_iss=0
879B:_MSS:80:WS:0:0:1:0:A:Solaris 2.5, 2.5.1
87C0:_MSS:FF:WS:0:0:1:0:A:Solaris 2.6 - 2.7
8EDA:_MSS:80:00:0:0:1:0:A:Solaris 2.5, 2.5.1
8F4D:_MSS:80:00:0:1:1:0:A:Solaris 2.6 - 2.7
8F4D:_MSS:80:00:0:1:1:1:A:Solaris 2.6 - 2.7
ABCD:_MSS:80:00:0:1:1:0:A:Solaris 2.6 - 2.7
ABCD:_MSS:80:00:0:1:1:1:A:Solaris 2.6 - 2.7
B5C9:_MSS:80:00:0:1:1:0:A:Windows Millenium Edition v4.90.3000
B5C9:_MSS:80:00:0:1:1:1:A:Windows Millenium Edition v4.90.3000
BB80:_MSS:80:WS:0:0:1:0:A:Windows 98
C000:05B4:40:00:0:0:0:0:S:IRIX 6.5 / 6.4
C000:_MSS:80:00:0:1:0:0:A:IRIX 6.2 - 6.5
C000:_MSS:80:00:0:1:0:1:A:IRIX 6.2 - 6.5
C000:_MSS:80:WS:0:0:0:0:A:OS-9/68K V2.4 (Quanterra Q4124 - 68030)
C08A:_MSS:80:00:0:1:1:0:A:FreeBSD 2.2.1 - 4.1
C08A:_MSS:80:00:0:1:1:1:A:FreeBSD 2.2.1 - 4.1
C0B7:_MSS:80:00:0:1:1:0:A:FreeBSD 2.2.1 - 4.1
C0B7:_MSS:80:00:0:1:1:1:A:FreeBSD 2.2.1 - 4.1
CDFF:_MSS:80:00:0:0:1:0:A:SONY NEWS-OS 6.1.2
E920:_MSS:80:00:0:1:1:1:A:WinME
EA60:_MSS:80:WS:0:0:1:0:A:Cisco 675 DSL router -- cbos 2.1
ED90:_MSS:40:WS:0:0:1:0:A:IRIX 6.2 - 6.5
EE48:_MSS:40:WS:0:0:1:0:A:IRIX 5.1 - 5.3
EF2A:_MSS:80:00:0:1:0:0:A:IRIX 5.2
EF2A:_MSS:80:00:0:1:0:1:A:IRIX 5.2
EF88:_MSS:40:WS:0:0:1:0:A:IRIX 6.2 - 6.5
F000:0200:40:WS:0:0:0:0:S:IRIX 5.3 / 4.0.5F
F000:05B4:40:WS:0:0:0:0:S:IRIX 6.3
F000:_MSS:80:00:0:1:0:0:A:IRIX 5.3
F000:_MSS:80:00:0:1:0:1:A:IRIX 5.3
FAF0:_MSS:80:00:0:1:1:0:A:Windows 2000 Professional, Build 2183 (RC3)
FAF0:_MSS:80:00:0:1:1:1:A:Windows 2000 Professional, Build 2183 (RC3)
FAF0:_MSS:80:WS:0:1:1:0:A:Windows XP Professional Release
FAF0:_MSS:FF:WS:0:0:0:0:A:Solaris 2.6 - 2.7
FE88:_MSS:FF:WS:0:0:1:0:A:Solaris 2.6 - 2.7
FEFA:_MSS:80:00:0:1:0:0:A:AIX v4.2
FEFA:_MSS:80:00:0:1:0:1:A:AIX v4.2
FFAF:_MSS:80:00:0:0:1:0:A:Solaris 2.3 - 2.4
FFAF:_MSS:80:00:0:1:0:0:A:Hitachi HI-UX/MPP (don't know version)
FFAF:_MSS:80:00:0:1:0:1:A:Hitachi HI-UX/MPP (don't know version)
FFAF:_MSS:80:WS:0:0:0:0:A:AIX 3.2.5 (Bull HardWare)
FFF7:_MSS:80:00:0:1:1:0:A:Solaris 2.6 - 2.7
FFF7:_MSS:80:00:0:1:1:1:A:Solaris 2.6 - 2.7
FFFF:0558:80:WS:0:0:1:0:S:BorderManager 3.5
FFFF:0564:40:WS:0:0:0:0:A:AIX
FFFF:_MSS:80:00:0:0:0:0:A:IBM MVS TCP/IP stack V. 3.2 or AIX 4.3.2
FFFF:_MSS:80:00:0:0:1:0:A:MacOS 8.1
FFFF:_MSS:80:00:0:1:0:0:A:AIX 3.2 running on RS/6000
FFFF:_MSS:80:00:0:1:0:1:A:AIX 3.2 running on RS/6000
FFFF:_MSS:80:00:0:1:1:0:A:Cray Unicos 9.0 - 10.0 or Unicos/mk 1.5.1
FFFF:_MSS:80:00:0:1:1:1:A:Cray Unicos 9.0 - 10.0 or Unicos/mk 1.5.1
FFFF:_MSS:80:WS:0:0:0:0:A:IBM MVS TCP/IP stack V. 3.2 or AIX 4.3.2
FFFF:_MSS:80:WS:0:0:1:0:A:Novell NetWare 3.12 - 5.00
FFFF:_MSS:FF:WS:0:0:1:0:A:Solaris 2.6 - 2.7
