/*
    ettercap -- dissector rlogin -- TCP 513

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "include/ec_main.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_CTYPE_H
   #include <ctype.h>
#endif

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

// protos

#ifndef HAVE_CTYPE_H
   int isprint(int c);
#endif
FUNC_DISSECTOR(Dissector_rlogin);

// --------------------

#ifndef HAVE_CTYPE_H
   int isprint(int c)
   {
      return ( (c>31 && c<127) ? 1 : 0 );
   }
#endif

FUNC_DISSECTOR(Dissector_rlogin)
{

   TCP_header *tcp;
   u_char *payload;
   char collector[30];
   int datalen;

   ONLY_CONNECTION;

   tcp = (TCP_header *) data;

   if (ntohs(tcp->source) == SERV_PORT) return 0;            // skip server messages...
   if (data_to_ettercap->datalen == 0) return 0;       // no data...

   payload = (char *)((int)tcp + tcp->doff * 4);

   memset(collector, 0, 30);
   datalen = (data_to_ettercap->datalen > 30) ? 30 : data_to_ettercap->datalen;
   memcpy(collector, payload, datalen);

   if (strcmp(collector, ""))
   {
      int i, end=0;

      for (i=0; i<strlen(collector); i++)
      {
         if (collector[i] == '\n' || collector[i] == '\r')
            end = 1;

         if (!isprint(collector[i]))
            collector[i] = 0;
      }

      if (strcmp(collector, ""))                      // again on modified collector
      {
         char user[30];
         char *remoteuser;

         remoteuser = collector+strlen(collector)+1;
         snprintf(user, 29, "[%s]:[%s]\n", collector, remoteuser);
//         snprintf(data_to_ettercap->info, 100, "TERM INFO : %s\n", remoteuser+strlen(remoteuser)+1);

         strncpy(data_to_ettercap->user, user, 29);
         if ( !strcmp(remoteuser, "") )  // it isn't the login
            strncpy(data_to_ettercap->pass, collector, 29);
      }
      else if (end)                                   // password needs to be terminated...
      {
         strcpy(data_to_ettercap->pass, "\n");
      }
   }

   return 0;
}


/* EOF */
