/*
    ettercap -- signal handler

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include "include/ec_main.h"

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#ifdef LINUX
	#define __USE_GNU		// for strsignal()
#endif
#include <string.h>


#ifdef HAVE_NCURSES
   #include <ncurses.h>
   #include "include/ec_interface.h"
   #include "include/ec_interface_sniff_data.h"
   #include "include/ec_interface_plugins.h"

   extern WINDOW *data_source_win;
   extern WINDOW *plugin_window;
#endif

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

// protos...

void Signal_SEGV(int sig);
void Signal_TERM(int sig);
void Signal_WINCH(int sig);
void Signal_USR1(int sig);
void Signal_USR2(int sig);

//-----------------------

void Signal_SigBuster()
{
#ifdef DEBUG
   Debug_msg("Signal_Buster");
#endif

   signal(SIGSEGV, Signal_SEGV);
   signal(SIGTERM, Signal_TERM);
   signal(SIGWINCH, Signal_WINCH);
   signal(SIGCHLD, SIG_IGN);       // if I kill a forked process it doesn't became a zombie...
   signal(SIGPIPE, Signal_TERM);   // if ettercap SIGSEGV, illithid receives this sig... (pipe_with_illithid)

   signal(SIGUSR1, Signal_USR1);
   signal(SIGUSR2, Signal_USR2);
}

RETSIGTYPE Signal_SEGV(int sig)
{
#ifdef DEBUG
   Debug_msg("[%s] Segmentation Fault...", program_argv0 );
#endif

#ifdef HAVE_NCURSES
   if (!Options.normal)
      Interface_WExit("Segmentation Fault... (caught)");
   else
#endif

   printf("\nSegmentation Fault... (caught)\n\n");
   exit(5);
}


RETSIGTYPE Signal_TERM(int sig)
{
#ifdef DEBUG
   Debug_msg("[%s] Signal handler... (caught SIGNAL: %d) | %s", program_argv0, sig, strsignal(sig));
#endif

   if (!strstr(program_argv0, PROGRAM)) exit(0);    // is not the main process...

#ifdef HAVE_NCURSES
   if (!Options.normal)
   {
      char Message[50];
      sprintf(Message, " Signal handler... (caught SIGNAL: %d) | %s", sig, strsignal(sig));
      Interface_WExit(Message);
   }
#else
   printf("\n Signal handler... (caught SIGNAL: %d) | %s\n\n", sig, strsignal(sig));
#endif
   exit(1);

}


RETSIGTYPE Signal_WINCH(int sig)
{

#ifdef HAVE_NCURSES
   if (data_source_win != NULL)
   {
      #ifdef DEBUG
         Debug_msg("Winching sniff data windows...");
      #endif
      Interface_Sniff_Data_Winch();
   }
#ifdef PERMIT_PLUGINS
   else if (plugin_window != NULL)
   {
      #ifdef DEBUG
         Debug_msg("Winching plugin windows...");
      #endif
      Interface_Plugins_Winch();
   }
#endif
   else
   {
      #ifdef DEBUG
         Debug_msg("Winching windows...");
      #endif
      Interface_Winch();
   }
#endif
   signal(SIGWINCH, Signal_WINCH);
}

RETSIGTYPE Signal_USR1(int sig)
{
   active_dissector = (active_dissector) ? 0 : 1;     // activate/deactivate active dissector (arp based)
   #ifdef DEBUG
      Debug_msg("\tactive_dissector %d", active_dissector);
   #endif
   signal(SIGUSR1, Signal_USR1);
}

RETSIGTYPE Signal_USR2(int sig)
{
   Connection_Mode = (Connection_Mode) ? 0 : 1;
   #ifdef DEBUG
      Debug_msg("\tConnection_Mode %d", Connection_Mode);
   #endif
   signal(SIGUSR2, Signal_USR2);
}

/* EOF */
