/*
    lurker -- ettercap plugin -- try to search for other ettercap

    Copyright (C) 2001  NaGoR

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdlib.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>

#include "../../src/include/ec_main.h"
#include "../../src/include/ec_plugins.h"
#include "../../src/include/ec_inet_structures.h"
#include "../../src/include/ec_inet.h"
#include "../../src/include/ec_inet_forge.h"
#include "../../src/include/ec_decodedata.h"

char Ettercap_Version[] = VERSION;                       // required -- for compatibility

char PlugIn_Info[] = "try to search for other ettercap";

short PlugIn_Version = 1;


// ---------------------------

void Parse_packet(char *buffer)        // very lame searching...
{                                      // only for script-kiddes...
   IP_header  *ip;
   TCP_header *tcp;
   ETH_header *eth;
   char IPS[16];
   char IPD[16];

   eth = (ETH_header *) buffer;
   if ( ntohs(eth->type) == ETH_P_IP )
   {
      ip = (IP_header *)(eth+1);

      strcpy(IPS, inet_ntoa(*(struct in_addr *)&ip->source_ip) );
      strcpy(IPD, inet_ntoa(*(struct in_addr *)&ip->dest_ip) );

      if ( ntohs(ip->ident) == 0xe77e )
      {
         Plugin_Output("\nettercap traces coming from %s ...\n", IPS );
      }

      if ( ip->proto == IPPROTO_TCP )
      {

         tcp = (TCP_header *) ((int)ip + ip->h_len * 4);

         switch( ntohl(tcp->seq) )
         {
            case 0xe77e:
               Plugin_Output("\nettercap traces coming from %s ...\n", IPS );
               break;
            case 6969:
               Plugin_Output("\n%s is shadowing (scanning) %s ...\n", IPS, IPD );
               break;
            case 0xabadc0de:
               Plugin_Output("\n%s is golemizing %s ...\n", IPS, IPD );
               break;
         }
      }


   }


}


void PlugIn_Start(char**argv)
{
    int sock, MTU = 1500;
    char *recv_pck;
    TIME_DECLARE;
    char c[1] = "";

    sock = Inet_OpenRawSock(Options.netiface);
    Inet_GetIfaceInfo(Options.netiface, &MTU, NULL, NULL, NULL);

    recv_pck = (u_char *)Inet_Forge_packet(MTU);

    Plugin_Output("\n\nSearching for other ettercap (hit return to exit)...\n\n");

    fcntl(sock, F_SETFL, O_NONBLOCK);

    TIME_START;

    loop
    {
      int len = 0;

        len = Inet_GetRawPacket(sock, recv_pck, MTU, NULL);

        if (len > 0) Parse_packet(recv_pck);

        TIME_FINISH;

        if (Plugin_Input(c, 1, P_NONBLOCK))
            break;

    }

    Inet_Forge_packet_destroy( recv_pck );
    close(sock);
}

/* EOF */
