
dnl
dnl EC_MESSAGE(MESSAGE)
dnl

AC_DEFUN(EC_MESSAGE,[
	AC_MSG_RESULT()
	AC_MSG_RESULT($1...)
	AC_MSG_RESULT()
])


dnl
dnl EC_LINUX_KERNEL()
dnl

AC_DEFUN(EC_LINUX_KERNEL,[

	AC_MSG_CHECKING(Linux kernel version)
	major=`uname -r  | cut -f1 -d"."`
	minor=`uname -r  | cut -f2 -d"."`
	AC_MSG_RESULT(`uname -r`)
	if test "$major$minor" -lt 20; then
		AC_MSG_WARN(*******************************);
		AC_MSG_WARN(* Kernel >= 2.0.x REQUIRED !! *);
		AC_MSG_WARN(*******************************);
		exit;
	fi
])


dnl
dnl EC_FREEBSD_VERSION()
dnl

AC_DEFUN(EC_FREEBSD_VERSION,[

	AC_MSG_CHECKING(FreeBSD version)
	major=`uname -r  | cut -f1 -d"."`
	minor=`uname -r  | cut -f2 -d"." | cut -f1 -d"-"`
	AC_MSG_RESULT(`uname -r`)
	if test "$major$minor" -lt 40; then
		AC_MSG_WARN(************************************************);
		AC_MSG_WARN(* Tested only on FreeBSD 4.x !!                *);
		AC_MSG_WARN(* Please send me comment patches or bug-report *);
		AC_MSG_WARN(* on how ettercap works within your system...  *);
		AC_MSG_WARN(************************************************);
	fi

])


dnl
dnl EC_PF_PACKET()
dnl
dnl   returns  HAVE_PF_PACKET
dnl            nopf=1  (if fails)
dnl

AC_DEFUN(EC_PF_PACKET,[

	AC_MSG_CHECKING(if you can create PF_PACKET socket)
	AC_TRY_RUN([
	#include <arpa/inet.h>
	#include <sys/socket.h>
	#include <features.h>         /* for the glibc version number */
	#if __GLIBC__ >= 2 && __GLIBC_MINOR__ >= 1
	#include <net/ethernet.h>     /* the L2 protocols */
	#else
	#include <asm/types.h>
	#include <linux/if_ether.h>   /* The L2 protocols */
	#endif
	int main()
	{
		int sock = socket(PF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
		if (sock < 0)
			exit(1);

		return 0;
	}
	],
	[	AC_MSG_RESULT(yes)
		AC_DEFINE(HAVE_PF_PACKET,1)
		],
		AC_MSG_RESULT(no);
		nopf=1,
		AC_MSG_RESULT(no when cross-compiling)
	)

])


dnl
dnl EC_SOCK_PACKET()
dnl
dnl	returns  HAVE_SCOK_PACKET
dnl            nosock=1 (if fails)
dnl

AC_DEFUN(EC_SOCK_PACKET,[

	AC_MSG_CHECKING(if you can create SOCK_PACKET socket)
	AC_TRY_RUN([
	#include <arpa/inet.h>
	#include <sys/socket.h>
	#include <features.h>         /* for the glibc version number */
	#if __GLIBC__ >= 2 && __GLIBC_MINOR__ >= 1
	#include <net/ethernet.h>     /* the L2 protocols */
	#else
	#include <asm/types.h>
	#include <linux/if_ether.h>   /* The L2 protocols */
	#endif
	int main()
	{
		int sock = socket(AF_INET, SOCK_PACKET, htons(ETH_P_ALL));
		if (sock < 0)
	  		exit(1);

		return 0;
	}
	],
	[	AC_MSG_RESULT(yes)
		AC_DEFINE(HAVE_SOCK_PACKET,1)
		],
		AC_MSG_RESULT(no);
		nosock=1,
		AC_MSG_RESULT(no when cross-compiling)
	)

])



dnl
dnl     EC_ENDIAN_CHECK
dnl
dnl results:
dnl
dnl     HAVE_MACHINE_BIG = 1   or
dnl     HAVE_MACHINE_LIL = 1
dnl

AC_DEFUN(EC_ENDIAN_CHECK,
	[AC_MSG_CHECKING(machine endianess)

	AC_TRY_RUN([
		#include <stdio.h>

		int main()
		{
			union
			{
				short s;
				char c[sizeof(short)];
			} un;

			un.s = 0x4612;		// magic number for me... ;)

			if (un.c [0] == 0x46 && un.c [1] == 0x12)
			{
				exit(1);	// BIG
			}
			else
			{
				if (un.c [0] == 0x12 && un.c [1] == 0x46)
					exit(0); // lil
			}
			return 0;
		}
	],
	[	AC_MSG_RESULT(lil)
		AC_DEFINE(HAVE_MACHINE_LIL)
		],
		AC_MSG_RESULT(BIG);
		AC_DEFINE(HAVE_MACHINE_BIG)
		AC_MSG_WARN(*************************************************************);
		AC_MSG_WARN(* BIG ENDIANNESS not yet tested... use at your own risk...  *);
		AC_MSG_WARN(*************************************************************);
		,
		AC_MSG_RESULT(unkown when cross-compiling)
	)

])


dnl
dnl     EC_SOCKLEN_CHECK
dnl
dnl results:
dnl
dnl     HAVE_SOCKLEN_T
dnl

AC_DEFUN(EC_SOCKLEN_CHECK,
	[AC_MSG_CHECKING(for socklen_t in sys/socket.h)

	AC_TRY_RUN([
		#include <sys/types.h>
		#include <sys/socket.h>

		int main()
		{
			socklen_t from;
			from = sizeof(socklen_t);

			return 0;
		}
	],
	[	AC_MSG_RESULT(yes)
		AC_DEFINE(HAVE_SOCKLEN_T)
		],
		AC_MSG_RESULT(no);
		,
		AC_MSG_RESULT(unkown when cross-compiling)
	)

])
