#ifdef HAVE_CONFIG_H
   #include <config.h>     // autoheader   -I.
#endif

#ifdef HAVE_ATEXIT
   #define exit_func(x)    atexit(x)
#else
   #define exit_func(x)
#endif

#define VERSION "0.4.0"
#define PROGRAM "ettercap"
#define AUTHORS "ALoR & NaGA"

#define loop for(;;)

extern char *program_argv0;

#include <sys/types.h>

#ifndef HAVE_STRLCAT					// missing functions
	#include "../missing/strlcat.h"
#endif

typedef struct host_arp          // hosts in LAN info
{
   int port;
   char name[128];
   char ip[16];
   char mac[20];
} HOST;


extern HOST *Host_In_LAN;
extern int number_of_hosts_in_lan;

extern HOST Host_Source;
extern HOST Host_Dest;

typedef struct options_list      // arguments passed on command line
{
   char list:1;
   char arpsniff:1;
   char sniff:1;
   char macsniff:1;
   char normal:1;
   char check:1;
   char plugin:1;
   char hexview:1;
   char silent:1;
   char udp:1;
   char finger:1;
   char link:1;
   char collect:1;
   char broadping:1;
   char netiface[10];
   char netmask[16];
} OPTIONS;

extern OPTIONS Options;

#define MAX_DATA 2000

typedef struct data_connection   // data through the pipe with illithid
{
   char ip_source[16];
   char ip_dest[16];
   int source_port;
   int dest_port;
   u_long seq;
   u_long ack_seq;
   char flags;
   char proto;
   int datasize;
   char data[MAX_DATA];     // FIXME: to be resized...
} SNIFFED_DATA;


typedef struct {
   int Host_Index1;
   int Host_Index2;
   u_char mode;
} SniffingHost;


typedef struct connection        // connection list
{
   char ip_source[16];
   char ip_dest[16];
   char mac_source[20];
   char mac_dest[20];
   int source_port;
   int dest_port;
   u_long source_seq;
   u_long dest_seq;
   char flags;
   char proto;
   int datalen;
   char status[8];
   char type[18];          // from /etc/services
   char user[30];          // pay attention on buffer overflow !!
   char pass[30];
   char info[100];         // additional info... ( smb domain, http page ...)
} CONNECTION;


typedef struct {                 // buffer structure (ec_buffer.c)
   short size;
   char *data;
   struct BUFFER *next;
} BUFFER;


extern CONNECTION *Conn_Between_Hosts;
extern int number_of_connections;

extern int pipe_with_illithid;
extern int pipe_with_illithid_data;
extern int pipe_inject_stod[2];
extern int pipe_inject_dtos[2];

extern char active_dissector;    // ec_main.c
extern int Connection_Mode;      // ec_illithid.c

#if HAVE_GETTIMEOFDAY
   #define TIME_DECLARE struct timeval start, finish
   #define TIME_START   gettimeofday(&start, 0)
   #define TIME_FINISH  gettimeofday(&finish, 0)
   #define TIME_ELAPSED (finish.tv_sec + finish.tv_usec/1.0e6)-(start.tv_sec  + start.tv_usec/1.0e6)
#else
   #define TIME_DECLARE float start, finish
   #define TIME_START   start=clock()
   #define TIME_FINISH  finish=clock()
   #define TIME_ELAPSED ((finish-start)/CLOCKS_PER_SEC)
#endif

#define MAX_INJECT 500  // max number of injected char


#define ARPBASED  0
#define PUBLICARP 1
#define IPBASED   2
#define MACBASED  3

/* EOF */
