/*
    ettercap -- ncurses interface for data injector

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "include/ec_main.h"

#ifdef HAVE_NCURSES  // don't compile if ncurses interface is not supported

#include <string.h>
#include <ncurses.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#ifdef HAVE_CTYPE_H
   #include <ctype.h>
#endif

#include "include/ec_interface.h"
#include "include/ec_interface_sniff_data.h"
#include "include/ec_decodedata.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif


#define BOTTOM_COLOR 1        // color schemes
#define TITLE_COLOR  2
#define MAIN_COLOR   3
#define POINT_COLOR  4
#define SEL_COLOR    5
#define HELP_COLOR   6
#define SNIFF_COLOR  7


// protos...

void Interface_Inject_Redraw(void);
int Interface_Inject_Run(u_char *inject_data, char proto, char *app);
int strescape(char *src, char *dst);

// global variables

extern WINDOW *main_window;
extern WINDOW *data_source_win, *data_dest_win, *data_source, *data_dest;

extern int W_MAINX1, W_MAINY1, W_MAINX2, W_MAINY2;
extern int W_BOTTOMY2;



//---------------------------


void Interface_Inject_Redraw(void)
{

   Interface_Sniff_Data_Redraw();

#ifdef DEBUG
   Debug_msg("Interface_Inject_Redraw");
#endif


   doupdate();
}





int Interface_Inject_Run(u_char *inject_data, char proto, char *app)
{
   WINDOW *inject_window, *i_win;
   int dimY = 10;
   int dimX = 60;
   char inject_sequence[MAX_INJECT];
   int len;

#ifdef DEBUG
   Debug_msg("Interface_Inject_Run -- %c %s", proto, app);
#endif

   i_win = newwin(dimY+2, dimX+2, W_BOTTOMY2/2 - dimY/2, W_MAINX2/2 - dimX/2);
   inject_window = newwin(dimY, dimX, W_BOTTOMY2/2 - dimY/2 +1, W_MAINX2/2 - dimX/2 +1);
   wbkgdset(i_win, COLOR_PAIR(HELP_COLOR));
   wattron(i_win, A_BOLD);
   box(i_win,ACS_VLINE,ACS_HLINE);
   mvwprintw(i_win,  0, 2, "Type characters to be injected (max %d):", MAX_INJECT);
   wbkgdset(inject_window, COLOR_PAIR(BOTTOM_COLOR));
   wmove(inject_window, 0, 0);
   echo();
   scrollok(inject_window, TRUE);
   keypad(inject_window, TRUE);
   curs_set(TRUE);
   wnoutrefresh(i_win);
   wnoutrefresh(inject_window);
   doupdate();

   mvwgetnstr(inject_window, 1, 0, inject_sequence, MAX_INJECT);

#ifdef DEBUG
   Debug_msg("Interface_Inject_Run -- inject_sequence len -- [%d]", strlen(inject_sequence));
#endif

   noecho();
   curs_set(FALSE);
   delwin(i_win);
   delwin(inject_window);
   doupdate();

   len = strescape(inject_sequence, inject_data);

#ifdef DEBUG
   Debug_msg("Interface_Inject_Run -- inject_data len -- [%d]", len);
#endif

   return len;

}

static int hextoint(int c)
{
   if (!isascii((u_char) c))       return (-1);
   if (isdigit((u_char) c))        return (c - '0');
   if ((c >= 'a') && (c <= 'f'))   return (c + 10 - 'a');
   if ((c >= 'A') && (c <= 'F'))   return (c + 10 - 'A');
   return (-1);
}

int strescape(char *src, char *dst)
{
   char  *olddst = dst;
   int   c;
   int   val;

// if (dst != NULL)
//    Error_msg("ec_interface_inject.c:%d dst must be NULL !", __LINE__);
//
// dst = (char *)calloc(strlen(src)+1, sizeof(char));

   while ((c = *src++) != '\0')
   {
      if (c == '\\')
      {
         switch ((c = *src++))
         {
            case '\0':
               goto strend;
            default:
               *dst++ = (char) c;
               break;
            case 'n':
               *dst++ = '\n';
               break;
            case 'r':
               *dst++ = '\r';
               break;
            case 'b':
               *dst++ = '\b';
               break;
            case 't':
               *dst++ = '\t';
               break;
            case 'f':
               *dst++ = '\f';
               break;
            case 'v':
               *dst++ = '\v';
               break;
            /* \ and up to 3 octal digits */    // taken from magic.c part of dsniff source code...
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
               val = c - '0';
               c = *src++;  /* try for 2 */
               if (c >= '0' && c <= '7') {
                  val = (val << 3) | (c - '0');
                  c = *src++;  /* try for 3 */
                  if (c >= '0' && c <= '7')
                     val = (val << 3) | (c - '0');
                  else --src;
               }
               else --src;
               *dst++ = (char) val;
               break;

            case 'x':
               val = 'x';      /* Default if no digits */
               c = hextoint(*src++);     /* Get next char */
               if (c >= 0) {
                       val = c;
                       c = hextoint(*src++);
                       if (c >= 0) val = (val << 4) + c;
                       else --src;
               }
               else --src;
               *dst++ = (char) val;
               break;
         }
      }
      else if (c == 8 || c == 263)  // the backspace
         dst--;
      else
         *dst++ = (char) c;
   }

strend:
   *dst = '\0';

   return (dst - olddst);
}


#endif

/* EOF */
