
/*  A Bison parser, made from dfilter-grammar.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define yyparse dfilter_parse
#define yylex dfilter_lex
#define yyerror dfilter_error
#define yylval dfilter_lval
#define yychar dfilter_char
#define yydebug dfilter_debug
#define yynerrs dfilter_nerrs
#define	T_FT_UINT8	257
#define	T_FT_UINT16	258
#define	T_FT_UINT24	259
#define	T_FT_UINT32	260
#define	T_FT_INT8	261
#define	T_FT_INT16	262
#define	T_FT_INT24	263
#define	T_FT_INT32	264
#define	T_FT_ETHER	265
#define	T_FT_IPv4	266
#define	T_FT_IPv6	267
#define	T_FT_NONE	268
#define	T_FT_BYTES	269
#define	T_FT_BOOLEAN	270
#define	T_FT_STRING	271
#define	T_FT_IPXNET	272
#define	T_FT_DOUBLE	273
#define	T_VAL_UNQUOTED_STRING	274
#define	T_VAL_BYTE_STRING	275
#define	T_VAL_BYTE_RANGE	276
#define	TOK_AND	277
#define	TOK_OR	278
#define	TOK_NOT	279
#define	TOK_XOR	280
#define	TOK_EQ	281
#define	TOK_NE	282
#define	TOK_GT	283
#define	TOK_GE	284
#define	TOK_LT	285
#define	TOK_LE	286

#line 1 "dfilter-grammar.y"


/* dfilter-grammar.y
 * Parser for display filters
 *
 * $Id: dfilter-grammar.y,v 1.38 2000/02/05 06:07:16 guy Exp $
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@zing.org>
 * Copyright 1998 Gerald Combs
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

#ifdef NEED_SNPRINTF_H
# ifdef HAVE_STDARG_H
#  include <stdarg.h>
# else
#  include <varargs.h>
# endif
# include "snprintf.h"
#endif

#ifndef __GLIB_H__
#include <glib.h>
#endif

#include <string.h>
#include <errno.h>
#include <math.h>

#ifndef _STDLIB_H
#include <stdlib.h>
#endif

#ifndef __PROTO_H__
#include "proto.h"
#endif

#ifndef __PACKET_H__
#include "packet.h"
#endif

#ifndef __DFILTER_H__
#include "dfilter.h"
#endif

#include "dfilter-int.h"

#ifndef __RESOLV_H__
#include "resolv.h"
#endif

static GNode* dfilter_mknode_join(GNode *n1, enum node_type ntype, int operand, GNode *n2);
static GNode* dfilter_mknode_unary(int operand, GNode *n2);
static GNode* dfilter_mknode_numeric_variable(gint id);
static GNode* dfilter_mknode_numeric_value(guint32 val);
static GNode* dfilter_mknode_floating_variable(gint id);
static GNode* dfilter_mknode_floating_value(double val);
static GNode* dfilter_mknode_ether_value(gchar*);
static GNode* dfilter_mknode_ether_variable(gint id);
static GNode* dfilter_mknode_ipxnet_value(guint32);
static GNode* dfilter_mknode_ipxnet_variable(gint id);
static GNode* dfilter_mknode_ipv4_value(char *host, int nmask_bits);
static GNode* dfilter_mknode_ipv4_variable(gint id);
static GNode* dfilter_mknode_ipv6_value(char *host);
static GNode* dfilter_mknode_ipv6_variable(gint id);
static GNode* dfilter_mknode_existence(gint id);
static GNode* dfilter_mknode_bytes_value(GByteArray *barray);
static GNode* dfilter_mknode_bytes_variable(gint id, gint offset, guint length);

static guint32 string_to_guint32(char *s, gboolean *success);
static double string_to_double(char *s, gboolean *success);
static int ether_str_to_guint8_array(const char *s, guint8 *mac);
static guint dfilter_get_bytes_variable_offset(GNode *gnode);
static guint dfilter_get_bytes_value_length(GNode* gnode);
static void dfilter_set_bytes_variable_length(GNode *gnode, guint length);
static guint dfilter_get_bytes_variable_length(GNode *gnode);
static gint dfilter_get_bytes_variable_field_registered_length(GNode *gnode);
static char* dfilter_get_variable_abbrev(GNode *gnode);
static int check_bytes_variable_sanity(GNode *gnode);

/* This is the dfilter we're currently processing. It's how
 * dfilter_compile communicates with us.
 */
dfilter *global_df = NULL;


#line 115 "dfilter-grammar.y"
typedef union {
	gint		operand;	/* logical, relation, alternation */
	struct {
		gint	id;
		gint	type;		/* using macros defined below, in this yacc grammar */
	} variable;
	GNode*		node;
	gchar*		string;
	struct {
		gint	offset;
		guint	length;
	} byte_range;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		119
#define	YYFLAG		-32768
#define	YYNTBASE	36

#define YYTRANSLATE(x) ((unsigned)(x) <= 286 ? yytranslate[x] : 58)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    33,
    34,     2,     2,     2,     2,     2,    35,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     3,     7,    11,    15,    19,    22,    24,    26,
    29,    33,    37,    41,    45,    49,    53,    57,    61,    65,
    69,    73,    77,    81,    85,    87,    89,    91,    93,    95,
    97,    99,   103,   107,   109,   111,   113,   115,   117,   119,
   121,   123,   125,   127,   129,   131,   133,   135,   137,   139,
   141,   143,   146,   148,   150,   152,   154,   156,   158,   160,
   162,   164,   166,   168,   170,   172,   174,   176,   178,   180,
   182,   184,   186,   188,   190,   192,   194,   196,   198,   200,
   202
};

static const short yyrhs[] = {    37,
     0,     0,    33,    37,    34,     0,    37,    23,    37,     0,
    37,    24,    37,     0,    37,    26,    37,     0,    25,    37,
     0,    38,     0,    52,     0,    37,     1,     0,    46,    55,
    39,     0,    46,    55,    46,     0,    48,    55,    42,     0,
    48,    55,    48,     0,    47,    56,    40,     0,    47,    56,
    47,     0,    49,    56,    41,     0,    49,    56,    49,     0,
    50,    55,    43,     0,    50,    55,    50,     0,    51,    56,
    44,     0,    51,    56,    51,     0,    53,    57,    45,     0,
    53,    57,    53,     0,    20,     0,    21,     0,    20,     0,
    20,     0,    21,     0,    20,     0,    21,     0,    20,    35,
    20,     0,    21,    35,    20,     0,    20,     0,    21,     0,
    21,     0,    20,     0,     3,     0,     4,     0,     5,     0,
     6,     0,     7,     0,     8,     0,     9,     0,    10,     0,
    11,     0,    19,     0,    18,     0,    12,     0,    13,     0,
    54,     0,    54,    22,     0,     3,     0,     4,     0,     5,
     0,     6,     0,     7,     0,     8,     0,     9,     0,    10,
     0,    19,     0,    11,     0,    12,     0,    13,     0,    18,
     0,    14,     0,    15,     0,    16,     0,    17,     0,    27,
     0,    28,     0,    29,     0,    30,     0,    31,     0,    32,
     0,    27,     0,    28,     0,    27,     0,    28,     0,    29,
     0,    31,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   177,   181,   184,   185,   186,   187,   188,   189,   190,   191,
   194,   198,   203,   207,   212,   216,   221,   225,   231,   235,
   240,   244,   249,   277,   308,   319,   329,   340,   350,   362,
   371,   380,   408,   436,   445,   455,   465,   493,   494,   495,
   496,   497,   498,   499,   500,   503,   506,   509,   512,   515,
   518,   535,   541,   542,   543,   544,   545,   546,   547,   548,
   549,   550,   551,   552,   553,   554,   555,   556,   557,   560,
   561,   562,   563,   564,   565,   568,   569,   572,   573,   574,
   575
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","T_FT_UINT8",
"T_FT_UINT16","T_FT_UINT24","T_FT_UINT32","T_FT_INT8","T_FT_INT16","T_FT_INT24",
"T_FT_INT32","T_FT_ETHER","T_FT_IPv4","T_FT_IPv6","T_FT_NONE","T_FT_BYTES","T_FT_BOOLEAN",
"T_FT_STRING","T_FT_IPXNET","T_FT_DOUBLE","T_VAL_UNQUOTED_STRING","T_VAL_BYTE_STRING",
"T_VAL_BYTE_RANGE","TOK_AND","TOK_OR","TOK_NOT","TOK_XOR","TOK_EQ","TOK_NE",
"TOK_GT","TOK_GE","TOK_LT","TOK_LE","'('","')'","'/'","statement","expression",
"relation","numeric_value","ether_value","ipxnet_value","floating_value","ipv4_value",
"ipv6_value","bytes_value","numeric_variable","ether_variable","floating_variable",
"ipxnet_variable","ipv4_variable","ipv6_variable","variable_name","bytes_variable",
"any_variable_type","numeric_relation","equality_relation","bytes_relation", NULL
};
#endif

static const short yyr1[] = {     0,
    36,    36,    37,    37,    37,    37,    37,    37,    37,    37,
    38,    38,    38,    38,    38,    38,    38,    38,    38,    38,
    38,    38,    38,    38,    39,    40,    41,    42,    42,    43,
    43,    43,    43,    44,    44,    45,    45,    46,    46,    46,
    46,    46,    46,    46,    46,    47,    48,    49,    50,    51,
    52,    53,    54,    54,    54,    54,    54,    54,    54,    54,
    54,    54,    54,    54,    54,    54,    54,    54,    54,    55,
    55,    55,    55,    55,    55,    56,    56,    57,    57,    57,
    57
};

static const short yyr2[] = {     0,
     1,     0,     3,     3,     3,     3,     2,     1,     1,     2,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     1,     1,     1,     1,     1,     1,
     1,     3,     3,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1
};

static const short yydefact[] = {     2,
    53,    54,    55,    56,    57,    58,    59,    60,    62,    63,
    64,    66,    67,    68,    69,    65,    61,     0,     0,     0,
     8,     0,     0,     0,     0,     0,     0,     9,     0,    51,
     0,     0,    10,     0,     0,     0,    70,    71,    72,    73,
    74,    75,     0,    76,    77,     0,     0,     0,     0,     0,
    78,    79,    80,    81,     0,    52,     3,     0,     0,     0,
    38,    39,    40,    41,    42,    43,    44,    45,    25,    11,
    12,    46,    26,    15,    16,    47,    28,    29,    13,    14,
    48,    27,    17,    18,    49,    30,    31,    19,    20,    50,
    34,    35,    21,    22,    53,    54,    55,    56,    57,    58,
    59,    60,    62,    63,    64,    65,    61,    37,    36,    23,
    24,     0,     0,     0,    32,    33,     0,     0,     0
};

static const short yydefgoto[] = {   117,
    20,    21,    70,    74,    83,    79,    88,    93,   110,    22,
    23,    24,    25,    26,    27,    28,    29,    30,    43,    46,
    55
};

static const short yypact[] = {    50,
    86,    96,   103,   109,   115,   121,   127,   133,   -10,   139,
    23,-32768,-32768,-32768,-32768,   162,   145,    50,    50,    48,
-32768,   151,   164,   151,   164,   151,   164,-32768,   157,   -19,
     0,    18,-32768,    50,    50,    50,-32768,-32768,-32768,-32768,
-32768,-32768,   102,-32768,-32768,    -9,     1,   -12,    -5,    57,
-32768,-32768,-32768,-32768,    81,-32768,-32768,     4,     9,    13,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,   -24,    10,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,   -19,    20,    26,-32768,-32768,    25,    73,-32768
};

static const short yypgoto[] = {-32768,
    85,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,    33,
    34,    35,   146,    80,   137,-32768,   138,   140,     5,    54,
-32768
};


#define	YYLAST		195


static const short yytable[] = {    -7,
    33,    72,    56,    -4,    33,    81,    85,    82,    -5,    33,
   113,    73,    -6,    33,    86,    87,   -46,   -46,    33,    76,
    77,    78,    -7,    -7,   118,    -7,    -4,    35,    47,    36,
    49,    -5,    -5,    -7,    -5,    -6,    -6,    -4,    -6,   115,
    34,    35,    -5,    36,   114,   116,    -6,    -1,    33,   -50,
   -50,    57,     1,     2,     3,     4,     5,     6,     7,     8,
     9,    10,    11,    12,    13,    14,    15,    16,    17,    90,
    34,    35,   119,    36,    18,    71,    91,    92,    48,    75,
    50,    80,    19,    95,    96,    97,    98,    99,   100,   101,
   102,   103,   104,   105,    12,    13,    14,    15,   106,   107,
   108,   109,    31,    32,    61,    62,    63,    64,    65,    66,
    67,    68,   -38,   -38,   -38,   -38,   -38,   -38,    58,    59,
    60,    69,   -39,   -39,   -39,   -39,   -39,   -39,    89,   -40,
   -40,   -40,   -40,   -40,   -40,   -41,   -41,   -41,   -41,   -41,
   -41,   -42,   -42,   -42,   -42,   -42,   -42,   -43,   -43,   -43,
   -43,   -43,   -43,   -44,   -44,   -44,   -44,   -44,   -44,   -45,
   -45,   -45,   -45,   -45,   -45,   -49,   -49,   -49,   -49,   -49,
   -49,   -47,   -47,   -47,   -47,   -47,   -47,    37,    38,    39,
    40,    41,    42,    51,    52,    53,    94,    54,   -48,   -48,
    44,    45,   111,    84,   112
};

static const short yycheck[] = {     0,
     1,    11,    22,     0,     1,    18,    12,    20,     0,     1,
    35,    21,     0,     1,    20,    21,    27,    28,     1,    19,
    20,    21,    23,    24,     0,    26,    23,    24,    24,    26,
    26,    23,    24,    34,    26,    23,    24,    34,    26,    20,
    23,    24,    34,    26,    35,    20,    34,     0,     1,    27,
    28,    34,     3,     4,     5,     6,     7,     8,     9,    10,
    11,    12,    13,    14,    15,    16,    17,    18,    19,    13,
    23,    24,     0,    26,    25,    43,    20,    21,    25,    46,
    27,    47,    33,     3,     4,     5,     6,     7,     8,     9,
    10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
    20,    21,    18,    19,     3,     4,     5,     6,     7,     8,
     9,    10,    27,    28,    29,    30,    31,    32,    34,    35,
    36,    20,    27,    28,    29,    30,    31,    32,    49,    27,
    28,    29,    30,    31,    32,    27,    28,    29,    30,    31,
    32,    27,    28,    29,    30,    31,    32,    27,    28,    29,
    30,    31,    32,    27,    28,    29,    30,    31,    32,    27,
    28,    29,    30,    31,    32,    27,    28,    29,    30,    31,
    32,    27,    28,    29,    30,    31,    32,    27,    28,    29,
    30,    31,    32,    27,    28,    29,    50,    31,    27,    28,
    27,    28,    55,    48,    55
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/misc/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/misc/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 178 "dfilter-grammar.y"
{
			global_df->dftree = yyvsp[0].node;
		;
    break;}
case 2:
#line 181 "dfilter-grammar.y"
{ if (global_df != NULL) global_df->dftree = NULL; ;
    break;}
case 3:
#line 184 "dfilter-grammar.y"
{ yyval.node = yyvsp[-1].node; ;
    break;}
case 4:
#line 185 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_join(yyvsp[-2].node, logical, yyvsp[-1].operand, yyvsp[0].node); ;
    break;}
case 5:
#line 186 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_join(yyvsp[-2].node, logical, yyvsp[-1].operand, yyvsp[0].node); ;
    break;}
case 6:
#line 187 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_join(yyvsp[-2].node, logical, yyvsp[-1].operand, yyvsp[0].node); ;
    break;}
case 7:
#line 188 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_unary(TOK_NOT, yyvsp[0].node); ;
    break;}
case 8:
#line 189 "dfilter-grammar.y"
{ yyval.node = yyvsp[0].node; ;
    break;}
case 9:
#line 190 "dfilter-grammar.y"
{ yyval.node = yyvsp[0].node; ;
    break;}
case 10:
#line 191 "dfilter-grammar.y"
{ YYABORT; ;
    break;}
case 11:
#line 195 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 12:
#line 199 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 13:
#line 204 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 14:
#line 208 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 15:
#line 213 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 16:
#line 217 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 17:
#line 222 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 18:
#line 226 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 19:
#line 232 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 20:
#line 236 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 21:
#line 241 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 22:
#line 245 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 23:
#line 250 "dfilter-grammar.y"
{
			int a_len, b_len;

			a_len = dfilter_get_bytes_variable_length(yyvsp[-2].node);
			b_len = dfilter_get_bytes_value_length(yyvsp[0].node);

			if (a_len == 0) {
				dfilter_set_bytes_variable_length(yyvsp[-2].node, b_len);
				a_len = b_len;
			}

			if (!check_bytes_variable_sanity(yyvsp[-2].node)) {
				YYERROR;
			}

			if (a_len != b_len) {
				dfilter_fail("Field \"%s\" has %u byte%s being compared, but %u byte%s "
					"%s supplied.",
					dfilter_get_variable_abbrev(yyvsp[-2].node),
					a_len, plurality(a_len, "", "s"),
					b_len, plurality(b_len, "", "s"),
					       plurality(b_len, "was", "were"));
				YYERROR;
			}

			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 24:
#line 278 "dfilter-grammar.y"
{
			int a_len, b_len;

			a_len = dfilter_get_bytes_variable_length(yyvsp[-2].node);
			b_len = dfilter_get_bytes_variable_length(yyvsp[0].node);

			if (!check_bytes_variable_sanity(yyvsp[-2].node)) {
				YYERROR;
			}

			if (!check_bytes_variable_sanity(yyvsp[0].node)) {
				YYERROR;
			}

			if (a_len != b_len) {
				dfilter_fail("Fields \"%s\" and \"%s\" are being compared with "
					"disparate lengths of %u byte%s and %u byte%s.",
					dfilter_get_variable_abbrev(yyvsp[-2].node),
					dfilter_get_variable_abbrev(yyvsp[0].node),
					a_len, plurality(a_len, "", "s"),
					b_len, plurality(b_len, "", "s"));
				YYERROR;
			}

			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 25:
#line 309 "dfilter-grammar.y"
{
		gboolean success;
		yyval.node = dfilter_mknode_numeric_value(string_to_guint32(yyvsp[0].string, &success));
		g_free(yyvsp[0].string);
		if (!success) {
			YYERROR;
		}
	 ;
    break;}
case 26:
#line 320 "dfilter-grammar.y"
{
		yyval.node = dfilter_mknode_ether_value(yyvsp[0].string);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 27:
#line 330 "dfilter-grammar.y"
{
		gboolean success;
		yyval.node = dfilter_mknode_ipxnet_value(string_to_guint32(yyvsp[0].string, &success));
		g_free(yyvsp[0].string);
		if (!success) {
			YYERROR;
		}
	;
    break;}
case 28:
#line 341 "dfilter-grammar.y"
{
		gboolean success;
		yyval.node = dfilter_mknode_floating_value(string_to_double(yyvsp[0].string, &success));
		g_free(yyvsp[0].string);
		if (!success) {
			YYERROR;
		}
	;
    break;}
case 29:
#line 351 "dfilter-grammar.y"
{
		/* e.g., 0.0, 0.1, 0.01 ... */
		gboolean success;
		yyval.node = dfilter_mknode_floating_value(string_to_double(yyvsp[0].string, &success));
		g_free(yyvsp[0].string);
		if (!success) {
			YYERROR;
		}
	;
    break;}
case 30:
#line 363 "dfilter-grammar.y"
{
		yyval.node = dfilter_mknode_ipv4_value(yyvsp[0].string, 32);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 31:
#line 372 "dfilter-grammar.y"
{
		yyval.node = dfilter_mknode_ipv4_value(yyvsp[0].string, 32);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 32:
#line 381 "dfilter-grammar.y"
{
		gboolean	success;
		guint32		nmask_bits;

		nmask_bits = string_to_guint32(yyvsp[0].string, &success);
		if (!success) {
			g_free(yyvsp[-2].string);
			g_free(yyvsp[0].string);
			YYERROR;
		}

		if (nmask_bits > 32) {
			dfilter_fail("The number of netmask bits in \"%s/%s\" should "
				"be between 0 and 32.", yyvsp[-2].string, yyvsp[0].string);
			g_free(yyvsp[-2].string);
			g_free(yyvsp[0].string);
			YYERROR;
		}

		yyval.node = dfilter_mknode_ipv4_value(yyvsp[-2].string, nmask_bits);
		g_free(yyvsp[-2].string);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 33:
#line 409 "dfilter-grammar.y"
{
		gboolean	success;
		guint32		nmask_bits;

		nmask_bits = string_to_guint32(yyvsp[0].string, &success);
		if (!success) {
			g_free(yyvsp[-2].string);
			g_free(yyvsp[0].string);
			YYERROR;
		}

		if (nmask_bits > 32) {
			dfilter_fail("The number of netmask bits in \"%s/%s\" should "
				"be between 0 and 32.", yyvsp[-2].string, yyvsp[0].string);
			g_free(yyvsp[-2].string);
			g_free(yyvsp[0].string);
			YYERROR;
		}
		yyval.node = dfilter_mknode_ipv4_value(yyvsp[-2].string, nmask_bits);
		g_free(yyvsp[-2].string);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 34:
#line 437 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_ipv6_value(yyvsp[0].string);
			g_free(yyvsp[0].string);
			if (yyval.node == NULL) {
				YYERROR;
			}
		;
    break;}
case 35:
#line 446 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_ipv6_value(yyvsp[0].string);
			g_free(yyvsp[0].string);
			if (yyval.node == NULL) {
				YYERROR;
			}
		;
    break;}
case 36:
#line 456 "dfilter-grammar.y"
{
		GByteArray	*barray;

		/* the next function appends to list_of_byte_arrays for me */
		barray = byte_str_to_guint8_array(yyvsp[0].string);
		yyval.node = dfilter_mknode_bytes_value(barray);
		g_free(yyvsp[0].string);
	;
    break;}
case 37:
#line 466 "dfilter-grammar.y"
{
		gboolean	success;
		guint32		val32;
		guint8		val8;
		GByteArray	*barray;

		val32 = string_to_guint32(yyvsp[0].string, &success);
		if (!success) {
			g_free(yyvsp[0].string);
			YYERROR;
		}
		if (val32 > 0xff) {
			dfilter_fail("The value \"%s\" cannot be stored in a single-byte byte-string. "
				"Use the multi-byte \"xx:yy\" representation.", yyvsp[0].string);
			g_free(yyvsp[0].string);
			YYERROR;
		}
		val8 = (guint8) val32;
		barray = g_byte_array_new();
		global_df->list_of_byte_arrays = g_slist_append(global_df->list_of_byte_arrays, barray);
		g_byte_array_append(barray, &val8, 1);

		yyval.node = dfilter_mknode_bytes_value(barray);
		g_free(yyvsp[0].string);
	;
    break;}
case 38:
#line 493 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 39:
#line 494 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 40:
#line 495 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 41:
#line 496 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 42:
#line 497 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 43:
#line 498 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 44:
#line 499 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 45:
#line 500 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 46:
#line 503 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ether_variable(yyvsp[0].variable.id); ;
    break;}
case 47:
#line 506 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_floating_variable(yyvsp[0].variable.id); ;
    break;}
case 48:
#line 509 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ipxnet_variable(yyvsp[0].variable.id); ;
    break;}
case 49:
#line 512 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ipv4_variable(yyvsp[0].variable.id); ;
    break;}
case 50:
#line 515 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ipv6_variable(yyvsp[0].variable.id); ;
    break;}
case 51:
#line 519 "dfilter-grammar.y"
{
		GNode	*variable;
		GNode	*value;

		if (yyvsp[0].variable.type == T_FT_BOOLEAN) {
			/* Make "variable == TRUE" for BOOLEAN variable */
			variable = dfilter_mknode_numeric_variable(yyvsp[0].variable.id);
			value = dfilter_mknode_numeric_value(TRUE);
			yyval.node = dfilter_mknode_join(variable, relation, TOK_EQ, value);
		}
		else {
			yyval.node = dfilter_mknode_existence(yyvsp[0].variable.id);
		}
	;
    break;}
case 52:
#line 536 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_bytes_variable(yyvsp[-1].variable.id, yyvsp[0].byte_range.offset, yyvsp[0].byte_range.length);
		;
    break;}
case 53:
#line 541 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 54:
#line 542 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 55:
#line 543 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 56:
#line 544 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 57:
#line 545 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 58:
#line 546 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 59:
#line 547 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 60:
#line 548 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 61:
#line 549 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 62:
#line 550 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 63:
#line 551 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 64:
#line 552 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 65:
#line 553 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 66:
#line 554 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 67:
#line 555 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 68:
#line 556 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 69:
#line 557 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 70:
#line 560 "dfilter-grammar.y"
{ yyval.operand = TOK_EQ; ;
    break;}
case 71:
#line 561 "dfilter-grammar.y"
{ yyval.operand = TOK_NE; ;
    break;}
case 72:
#line 562 "dfilter-grammar.y"
{ yyval.operand = TOK_GT; ;
    break;}
case 73:
#line 563 "dfilter-grammar.y"
{ yyval.operand = TOK_GE; ;
    break;}
case 74:
#line 564 "dfilter-grammar.y"
{ yyval.operand = TOK_LT; ;
    break;}
case 75:
#line 565 "dfilter-grammar.y"
{ yyval.operand = TOK_LE; ;
    break;}
case 76:
#line 568 "dfilter-grammar.y"
{ yyval.operand = TOK_EQ; ;
    break;}
case 77:
#line 569 "dfilter-grammar.y"
{ yyval.operand = TOK_NE; ;
    break;}
case 78:
#line 572 "dfilter-grammar.y"
{ yyval.operand = TOK_EQ; ;
    break;}
case 79:
#line 573 "dfilter-grammar.y"
{ yyval.operand = TOK_NE; ;
    break;}
case 80:
#line 574 "dfilter-grammar.y"
{ yyval.operand = TOK_GT; ;
    break;}
case 81:
#line 575 "dfilter-grammar.y"
{ yyval.operand = TOK_LT; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/misc/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 578 "dfilter-grammar.y"


static GNode*
dfilter_mknode_join(GNode *n1, enum node_type ntype, int operand, GNode *n2)
{
	dfilter_node	*node_root;
	GNode		*gnode_root;

	node_root = g_mem_chunk_alloc(global_df->node_memchunk);
	node_root->ntype = ntype;
	node_root->elem_size = 0;
	node_root->fill_array_func = NULL;
	node_root->check_relation_func = NULL;
	if (ntype == relation) {
		node_root->value.relation = operand;
	}
	else if (ntype == logical) {
		node_root->value.logical = operand;
	}
	else {
		g_assert_not_reached();
	}

	gnode_root = g_node_new(node_root);
	g_node_append(gnode_root, n1);
	g_node_append(gnode_root, n2);

	return gnode_root;
}

static GNode*
dfilter_mknode_unary(int operand, GNode *n2)
{
	dfilter_node	*node_root;
	GNode		*gnode_root;

	node_root = g_mem_chunk_alloc(global_df->node_memchunk);
	node_root->ntype = logical;
	node_root->value.logical = operand;
	node_root->elem_size = 0;
	node_root->fill_array_func = NULL;
	node_root->check_relation_func = NULL;

	gnode_root = g_node_new(node_root);
	g_node_append(gnode_root, n2);

	return gnode_root;
}


static GNode*
dfilter_mknode_numeric_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(guint32);
	node->fill_array_func = fill_array_numeric_variable;
	node->check_relation_func = check_relation_numeric;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ether_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(guint8) * 6;
	node->fill_array_func = fill_array_ether_variable;
	node->check_relation_func = check_relation_ether;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_floating_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(double);
	node->fill_array_func = fill_array_floating_variable;
	node->check_relation_func = check_relation_floating;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ipxnet_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(guint8) * 4;
	node->fill_array_func = fill_array_numeric_variable; /* cheating ! */
	node->check_relation_func = check_relation_numeric; /* cheating ! */
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ipv4_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(ipv4_addr);
	node->fill_array_func = fill_array_ipv4_variable;
	node->check_relation_func = check_relation_ipv4;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ipv6_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = 16;
	node->fill_array_func = fill_array_ipv6_variable;
	node->check_relation_func = check_relation_ipv6; 
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_bytes_variable(gint id, gint offset, guint length)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(GByteArray*);
	node->fill_array_func = fill_array_bytes_variable;
	node->check_relation_func = check_relation_bytes;
	node->value.variable = id;
	node->offset = offset;
	node->length = length;
	gnode = g_node_new(node);

	return gnode;
}

/* Gets length of variable represented by node from proto_register */
static gint
dfilter_get_bytes_variable_field_registered_length(GNode *gnode)
{
	dfilter_node	*node = gnode->data;

	/* Is this really a bytes_variable? */
	g_assert(node->fill_array_func = fill_array_bytes_variable);

	return proto_registrar_get_length(node->value.variable);
}

/* Sets the length of a bytes_variable node */
static void
dfilter_set_bytes_variable_length(GNode *gnode, guint length)
{
	dfilter_node	*node = gnode->data;

	/* Is this really a bytes_variable? */
	g_assert(node->fill_array_func = fill_array_bytes_variable);

	node->length = length;
}

/* Gets the length of a bytes_variable node */
static guint
dfilter_get_bytes_variable_length(GNode *gnode)
{
	dfilter_node	*node = gnode->data;

	/* Is this really a bytes_variable? */
	g_assert(node->fill_array_func = fill_array_bytes_variable);

	return node->length;
}

/* Gets the offset of a bytes_variable node */
static guint
dfilter_get_bytes_variable_offset(GNode *gnode)
{
	dfilter_node	*node = gnode->data;

	/* Is this really a bytes_variable? */
	g_assert(node->fill_array_func = fill_array_bytes_variable);

	return node->offset;
}

static char*
dfilter_get_variable_abbrev(GNode *gnode)
{
	dfilter_node	*node = gnode->data;

	return proto_registrar_get_abbrev(node->value.variable);
}

static GNode*
dfilter_mknode_numeric_value(guint32 val)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = numeric;
	node->elem_size = sizeof(guint32);
	node->fill_array_func = fill_array_numeric_value;
	node->check_relation_func = check_relation_numeric;
	node->value.numeric = val;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_floating_value(double val)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = floating;
	node->elem_size = sizeof(double);
	node->fill_array_func = fill_array_floating_value;
	node->check_relation_func = check_relation_floating;
	node->value.floating = val;
	gnode = g_node_new(node);

	return gnode;
}

/* Returns NULL on bad parse of ETHER value */
static GNode*
dfilter_mknode_ether_value(gchar *byte_string)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = ether;
	node->elem_size = sizeof(guint8) * 6;
	node->fill_array_func = fill_array_ether_value;
	node->check_relation_func = check_relation_ether;

	if (!ether_str_to_guint8_array(byte_string, &node->value.ether[0])) {
		/* Rather than free the mem_chunk allocation, let it
		 * stay. It will be cleaned up when "dfilter_compile()"
		 * calls "dfilter_destroy()". */
		dfilter_fail("\"%s\" is not a valid hardware address.",
		    byte_string);
		return NULL;
	}

	gnode = g_node_new(node);
	return gnode;
}

static GNode*
dfilter_mknode_ipxnet_value(guint32 ipx_net_val)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = ipxnet;
	node->elem_size = sizeof(guint8) * 4;
	node->fill_array_func = fill_array_numeric_value; /* cheating ! */
	node->check_relation_func = check_relation_numeric; /* cheating ! */
	node->value.numeric = ipx_net_val;
	gnode = g_node_new(node);

	return gnode;
}

/* Returns NULL on bad parse of IP value */
static GNode*
dfilter_mknode_ipv4_value(char *host, int nmask_bits)
{
	dfilter_node	*node;
	GNode		*gnode;
	guint32		addr;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = numeric;
	node->elem_size = sizeof(ipv4_addr);
	node->fill_array_func = fill_array_ipv4_value;
	node->check_relation_func = check_relation_ipv4;
	if (!get_host_ipaddr(host, &addr)) {
		/* Rather than free the mem_chunk allocation, let it
		 * stay. It will be cleaned up when "dfilter_compile()"
		 * calls "dfilter_destroy()". */
		dfilter_fail("\"%s\" isn't a valid host name or IP address.",
		    host);
		return NULL;
	}
	ipv4_addr_set_host_order_addr(&node->value.ipv4, addr);
	ipv4_addr_set_netmask_bits(&node->value.ipv4, nmask_bits);

	gnode = g_node_new(node);
	return gnode;
}

/* Returns NULL on bad parse of IPv6 value */
static GNode*
dfilter_mknode_ipv6_value(char *host)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = ipv6;
	node->elem_size = 16;
	node->fill_array_func = fill_array_ipv6_value;
	node->check_relation_func = check_relation_ipv6;

	if (!get_host_ipaddr6(host, (struct e_in6_addr*)&node->value.ipv6[0])) {
		/* Rather than free the mem_chunk allocation, let it
		 * stay. It will be cleaned up when "dfilter_compile()"
		 * calls "dfilter_destroy()". */
		dfilter_fail("\"%s\" isn't a valid IPv6 address.",
		    host);
		return NULL;
	}

	gnode = g_node_new(node);
	return gnode;
}

static GNode*
dfilter_mknode_bytes_value(GByteArray *barray)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = bytes;
	node->elem_size = sizeof(GByteArray*);
	node->fill_array_func = fill_array_bytes_value;
	node->check_relation_func = check_relation_bytes;
	node->value.bytes = barray;
	node->offset = G_MAXINT;
	node->length = barray->len;
	gnode = g_node_new(node);

	return gnode;
}

/* Given a node representing a bytes_value, returns
 * the length of the byte array */
static guint
dfilter_get_bytes_value_length(GNode* gnode)
{
	dfilter_node	*node = gnode->data;

	g_assert(node->ntype == bytes);
	return node->length;
}

static guint32
string_to_guint32(char *s, gboolean *success)
{
	char	*endptr;
	guint32	val;

	val = strtoul(s, &endptr, 0);
	*success = TRUE;
	if (endptr == s || *endptr != '\0') {
		/* This isn't a valid number. */
		dfilter_fail("\"%s\" is not a valid number.", s);
		*success = FALSE;
	}
	if (errno == ERANGE) {
		*success = FALSE;
		if (val == ULONG_MAX) {
			dfilter_fail("\"%s\" causes an integer overflow.", s);
		}
		else {
			dfilter_fail("\"%s\" is not an integer.", s);
		}
	}

	return (guint32)val;
}

static double
string_to_double(char *s, gboolean *success)
{
	char	*endptr = NULL;
	double	retval;

	retval = strtod(s, &endptr);
	*success = TRUE;

	if (endptr == s) {
		dfilter_fail("\"%s\" is not a valid floating-point number.", s);
		*success = FALSE;
	}

	if (errno == ERANGE) {
		*success = FALSE;
		if (retval == 0) {
			dfilter_fail("\"%s\" causes a floating-point underflow.", s);
		}
		else if (retval == HUGE_VAL) {
			dfilter_fail("\"%s\" causes a floating-point overflow.", s);
		}
		else {
			dfilter_fail("\"%s\" is not a valid floating-point.", s);
		}
	}
	return retval;
}
	
static GNode*
dfilter_mknode_existence(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = existence;
	node->elem_size = sizeof(guint32);
	node->fill_array_func = NULL;
	node->check_relation_func = NULL;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}


/* converts a string representing an ether HW address
 * to a guint8 array.
 *
 * Returns 0 on failure, 1 on success.
 */
static int
ether_str_to_guint8_array(const char *s, guint8 *mac)
{
	char	ether_str[18]; /* 2+1+2+1+2+1+2+1+2+1+2 + 1 */
	char	*p, *str;
	int	i = 0;

	if (strlen(s) > 17) {
		return 0;
	}
	strcpy(ether_str, s); /* local copy of string */
	str = ether_str;
	while ((p = strtok(str, "-:."))) {
		/* catch short strings with too many hex bytes: 0.0.0.0.0.0.0 */
		if (i > 5) {
			return 0;
		}
		mac[i] = (guint8) strtoul(p, NULL, 16);
		i++;
		/* subsequent calls to strtok() require NULL as arg 1 */
		str = NULL;
	}
	if (i != 6)
		return 0;	/* failed to read 6 hex pairs */
	else
		return 1;	/* read exactly 6 hex pairs */
}


static int
check_bytes_variable_sanity(GNode *gnode)
{
	int a_off, a_len, reg_len, t_off;

	a_off = dfilter_get_bytes_variable_offset(gnode);
	a_len = dfilter_get_bytes_variable_length(gnode);
	reg_len = dfilter_get_bytes_variable_field_registered_length(gnode);

	if (reg_len > 0) {
		t_off = a_off >= 0 ? a_off : reg_len + a_off;
		if (t_off + a_len > reg_len) {
			dfilter_fail("The \"%s\" field is only %u byte%s wide, but "
				"%u byte%s %s supplied.",
				dfilter_get_variable_abbrev(gnode),
				reg_len, plurality(reg_len, "", "s"),
				a_len, plurality(a_len, "", "s"),
				       plurality(a_len, "was", "were"));
			return 0;
		}
	}
	return 1;
}
