# Note that this is NOT a relocatable package
%define ver      0.2.19
%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix   /usr

Summary: Allows several audio streams to play on a single audio device.
Name:      esound
Version:   %ver
Release:   %rel
Copyright: GPL
Group: System Environment/Daemons
Source0:   esound-%{PACKAGE_VERSION}.tar.gz
URL:       http://www.tux.org/~ricdude/EsounD.html
BuildRoot: /var/tmp/esound-%{PACKAGE_VERSION}-root

Docdir: %{_prefix}/doc

%description
EsounD, the Enlightened Sound Daemon, is a server process that mixes
several audio streams for playback by a single audio device. For
example, if you're listening to music on a CD and you receive a
sound-related event from ICQ, the two applications won't have to
jockey for the use of your sound card.

Install esound if you'd like to let sound applications share your
audio device. You'll also need to install the audiofile package.

%package devel
Summary: Development files for EsounD applications.
Group: Development/Libraries
Requires: esound
Requires: audiofile-devel

%description devel
The esound-devel Libraries, include files and other resources you can
use to develop EsounD applications.

Install esound-devel if you want to develop EsounD applications.

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix --sysconfdir=/etc

make

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{_prefix} sysconfdir=$RPM_BUILD_ROOT/etc install

strip $RPM_BUILD_ROOT%{_prefix}/bin/* ||:
strip $RPM_BUILD_ROOT%{_prefix}/lib/*.so.* ||:

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog docs/esound.sgml docs/html docs/esound.ps
%doc INSTALL NEWS README TIPS TODO
%config /etc/*
%{_prefix}/bin/esd
%{_prefix}/bin/esdcat
%{_prefix}/bin/esdctl
%{_prefix}/bin/esddsp
%{_prefix}/bin/esdfilt
%{_prefix}/bin/esdloop
%{_prefix}/bin/esdmon
%{_prefix}/bin/esdplay
%{_prefix}/bin/esdrec
%{_prefix}/bin/esdsample
%{_prefix}/lib/lib*.so.*

%files devel
%defattr(-, root, root)

%{_prefix}/bin/esd-config
%{_prefix}/lib/*a
%{_prefix}/include/*
%{_prefix}/share/aclocal/*
%{_prefix}/lib/lib*.so

%changelog
* Tue Apr 4 2000 Elliot Lee <sopwith@redhat.com> 0.2.18-1
- Update to 0.2.18

* Mon Aug 30 1999 Elliot Lee <sopwith@redhat.com> 0.2.13-1
- Update to 0.2.13
- Merge in changes from RHL 6.0 spec file.

* Sat Nov 21 1998 Pablo Saratxaga <srtxg@chanae.alphanet.ch>

- added %{_prefix}/share/aclocal/* to %files devel
- added spanish and french translations for rpm

* Thu Oct 1 1998 Ricdude <ericmit@ix.netcom.com>

- make autoconf do the version updating for us.

* Wed May 13 1998 Michael Fulbright <msf@redhat.com>

- First try at an RPM
