# ----------------------------------------------------
# Copyright (C) 1997, Ericsson Telecommunications
# Author: Bjorn Gustavsson
#
# This make include file runs an clearmake recursively on the Makefile
# in the architecture dependent subdirectory.
#
# Typical use from Makefile:
#
#    CC_ROOT := $(shell pwd | sed 's/erts.*$$//')
#    include $(CC_ROOT)/internal_tools/make/run_make.mk
#
# The first line makes sure that the clearcase root is found
# whatever root it has.
# ----------------------------------------------------

autoconf := $(CC_ROOT)erts/autoconf
TARGET := $(shell $(autoconf)/config.guess)
makefile := $(TARGET)/Makefile

debug opt instr purify quantify purecov:
	${MAKE} -f $(makefile) TYPE=$@

clean docs release release_spec release_docs release_docs_spec \
  tests release_tests release_tests_spec release_src release_src_spec:
	${MAKE} -f $(makefile) $@
