/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#ifndef _ERLSRV_UTIL_H
#define _ERLSRV_UTIL_H

extern char *service_name;
extern char *real_service_name;
void log_warning(char *mess);
void log_error(char *mess);
void log_info(char *mess);

char *envdup(char *env);
/*
** Call before env_to_arg to get a 'freeable' environment block.
*/

char *arg_to_env(char **arg);
/*
** Frees the argument list before returning!
*/

char **env_to_arg(char *env);
/*
** Frees the environment block before returning!
*/


#ifndef NDEBUG
void log_debug(char *mess);
#else
#define log_debug(mess) /* Debug removed */
#endif

#endif /* _ERLSRV_UTIL_H */
