/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*-
 * Copyright (c) 1985, 1989 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)res_init.c	6.14 (Berkeley) 6/27/90";
#endif /* LIBC_SCCS and not lint */

#include "resolver.h"

/*
 * Resolver state default settings
 */

static const struct state init_res = {
	RES_TIMEOUT,               	/* retransmition time interval */
	4,                         	/* number of times to retransmit */
	RES_DEFAULT,			/* options flags */
	1,                         	/* number of name servers */
};

struct resolv_data *_resolv_data;

/*
 * Set up default settings.  If the configuration file exist, the values
 * there will have precedence.  Otherwise, the server address is set to
 * INADDR_ANY and the default domain name comes from the gethostname().
 *
 * The configuration file should only be used if you want to redefine your
 * domain or run without a server on your machine.
 *
 * Return 0 if completes successfully, -1 on error
 */
res_init()
{
	register FILE *fp;
	register char *cp, **pp;
	register int n;
	char buf[BUFSIZ];
	char *resconf;
	extern u_long inet_addr();
	extern char *index();
	extern char *strcpy(), *strncpy();
	int nserv = 0;    /* number of nameserver records read from file */
	int havesearch = 0;

	if (_resolv_data == NULL) {
	    if (taskVarAdd(0, (int *)&_resolv_data) != 0 ||
		(_resolv_data = (struct resolv_data *)
		 calloc(1, sizeof(struct resolv_data))) == NULL)
		return(-1);
	    _resolv_data->_res = init_res;
	    _resolv_data->s = -1;
	}

	_resolv_data->_res.nsaddr.sin_addr.s_addr = INADDR_ANY;
	_resolv_data->_res.nsaddr.sin_family = AF_INET;
	_resolv_data->_res.nsaddr.sin_port = htons(NAMESERVER_PORT);
	_resolv_data->_res.nscount = 1;

	if ((resconf = getenv("ERLRESCONF")) == NULL)
	  resconf = _PATH_RESCONF;
	if ((fp = fopen(resconf, "r")) != NULL) {
	    /* read the config file */
	    while (fgets(buf, sizeof(buf), fp) != NULL) {
		/* read default domain name */
		if (!strncmp(buf, "domain", sizeof("domain") - 1)) {
		    cp = buf + sizeof("domain") - 1;
		    while (*cp == ' ' || *cp == '\t')
			    cp++;
		    if ((*cp == '\0') || (*cp == '\n'))
			    continue;
		    (void)strncpy(_resolv_data->_res.defdname, cp, sizeof(_resolv_data->_res.defdname) - 1);
		    if ((cp = index(_resolv_data->_res.defdname, '\n')) != NULL)
			    *cp = '\0';
		    havesearch = 0;
		    continue;
		}
		/* set search list */
		if (!strncmp(buf, "search", sizeof("search") - 1)) {
		    cp = buf + sizeof("search") - 1;
		    while (*cp == ' ' || *cp == '\t')
			    cp++;
		    if ((*cp == '\0') || (*cp == '\n'))
			    continue;
		    (void)strncpy(_resolv_data->_res.defdname, cp, sizeof(_resolv_data->_res.defdname) - 1);
		    if ((cp = index(_resolv_data->_res.defdname, '\n')) != NULL)
			    *cp = '\0';
		    /*
		     * Set search list to be blank-separated strings
		     * on rest of line.
		     */
		    cp = _resolv_data->_res.defdname;
		    pp = _resolv_data->_res.dnsrch;
		    *pp++ = cp;
		    for (n = 0; *cp && pp < _resolv_data->_res.dnsrch + MAXDNSRCH; cp++) {
			    if (*cp == ' ' || *cp == '\t') {
				    *cp = 0;
				    n = 1;
			    } else if (n) {
				    *pp++ = cp;
				    n = 0;
			    }
		    }
		    /* null terminate last domain if there are excess */
		    while (*cp != '\0' && *cp != ' ' && *cp != '\t')
			    cp++;
		    *cp = '\0';
		    *pp++ = 0;
		    havesearch = 1;
		    continue;
		}
		/* read nameservers to query */
		if (!strncmp(buf, "nameserver", sizeof("nameserver") - 1) &&
		   nserv < MAXNS) {
		    cp = buf + sizeof("nameserver") - 1;
		    while (*cp == ' ' || *cp == '\t')
			    cp++;
		    if ((*cp == '\0') || (*cp == '\n'))
			    continue;
		    if ((_resolv_data->_res.nsaddr_list[nserv].sin_addr.s_addr =
			inet_addr(cp)) == (unsigned)-1) {
			    _resolv_data->_res.nsaddr_list[nserv].sin_addr.s_addr
				= INADDR_ANY;
			    continue;
		    }
		    _resolv_data->_res.nsaddr_list[nserv].sin_family = AF_INET;
		    _resolv_data->_res.nsaddr_list[nserv].sin_port = htons(NAMESERVER_PORT);
		    nserv++;
		    continue;
		}
	    }
	    if (nserv > 1) 
		_resolv_data->_res.nscount = nserv;
	    (void) fclose(fp);
	}
	if (_resolv_data->_res.defdname[0] == 0) {
		if (gethostname(buf, sizeof(_resolv_data->_res.defdname)) == 0 &&
		   (cp = index(buf, '.')))
			(void)strcpy(_resolv_data->_res.defdname, cp + 1);
	}

	/* find components of local domain that might be searched */
	if (havesearch == 0) {
		pp = _resolv_data->_res.dnsrch;
		*pp++ = _resolv_data->_res.defdname;
		for (cp = _resolv_data->_res.defdname, n = 0; *cp; cp++)
			if (*cp == '.')
				n++;
		cp = _resolv_data->_res.defdname;
		for (; n >= LOCALDOMAINPARTS && pp < _resolv_data->_res.dnsrch + MAXDFLSRCH;
		    n--) {
			cp = index(cp, '.');
			*pp++ = ++cp;
		}
		*pp++ = 0;
	}
	_resolv_data->_res.options |= RES_INIT;
	return (0);
}
