/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include "eihash.h"
#include "eireg.h"

/* resize a registry - return the new size or -1 on error */
extern int ei_reg_resize(ei_reg *reg, int newsize)
{
  ei_hash *newtab=NULL;

  if (!reg) return -1;
  if (newsize <= 0) return -1;
  
  if ((newtab=ei_hash_resize(reg->tab,newsize))) {
    reg->tab = newtab;
  }

  return reg->tab->size;
}
