/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#ifdef __WIN32__
#include <winsock2.h>
#include <windows.h>
#include <winbase.h>

#elif VXWORKS
#include <unistd.h>

#else /* unix */
#include <unistd.h>
#endif

/* common */
#include <string.h>


#include "ei.h"
#include "putget.h"

#ifdef DEBUG_DIST
#include <stdio.h>
#include <errno.h>
extern int ei_show_recmsg(FILE *dest,erlang_msg *msg,char *buf);
#endif

#ifdef __WIN32__
#define readsocket(fd,buf,n) recv(fd,buf,n,0)
#define writesocket(fd,buf,n) send(fd,buf,n,0)
#else 
#define readsocket(fd,buf,n)  read(fd,buf,n)
#define writesocket(fd,buf,n)  write(fd,buf,n)
#endif

extern erlang_trace *ei_trace(int query, erlang_trace *token);

static int read_fill(int fd, char *buf, int len)
{
  int got = 0;
  int i;
  
  while (got < len) {
    i = readsocket(fd,buf+got,len-got);
    if (i<=0) return i;
    got+=i;
  }
  return got;
}
		     
#ifndef SMALLBUF 
#define SMALLBUF 2048
#endif 

/* length (4), PASS_THOUGH (1), header, message */
int ei_receive_encoded(int fd, char *mbuf, int *bufsz, erlang_msg *msg)
{
  char header[SMALLBUF]; /* largest possible header is approx 1300 bytes */
  char *s=header;
  int len = 0;
  int msglen = 0;
  int bytesread = 0;
  int remain;
  int arity;
  int version;
  int index = 0;
  int i = 0;

  /* if (*bufsz < 4) return -1; */
  
  /* get length field */
  if (read_fill(fd, header, 4) != 4) return -1;
  len = get32be(s);

  /* got tick - respond and return */
  if (!len) {
    unsigned char tock[] = {0,0,0,0};
    writesocket(fd, tock, sizeof(tock));
    *bufsz = 0;
    return 0;
  }
  
  /* turn off tracing on each receive. it will be turned back on if
   * we receive a trace token.
   */
  ei_trace(-1,NULL);
  
  /* read enough to get at least entire header */
  bytesread = (len > SMALLBUF ? SMALLBUF : len); 
  if ((i = read_fill(fd,header,bytesread)) != bytesread) return -1;

  /* now decode header */
  /* pass-through, version, control tuple header, control message type */
  s = header;
  index = 1;
  if ((get8(s) != ERL_PASS_THROUGH)
      || ei_decode_version(header,&index,&version)
      || (version != ERL_VERSION_MAGIC) 
      || ei_decode_tuple_header(header,&index,&arity) 
      || ei_decode_long(header,&index,&msg->msgtype)) return -1;

  switch (msg->msgtype) {
  case ERL_SEND:          /* { SEND, Cookie, ToPid } */
      if (ei_decode_atom(header,&index,msg->cookie) 
	|| ei_decode_pid(header,&index,&msg->to)) return -1;
    break;

  case ERL_REG_SEND:     /* { REG_SEND, From, Cookie, ToName } */
    if (ei_decode_pid(header,&index,&msg->from) 
	|| ei_decode_atom(header,&index,msg->cookie) 
	|| ei_decode_atom(header,&index,msg->toname)) return -1;
    /* actual message is remaining part of headerbuf, plus any unread bytes */
    break;

  case ERL_LINK:         /* { LINK, From, To } */
  case ERL_UNLINK:       /* { UNLINK, From, To } */
  case ERL_GROUP_LEADER: /* { GROUP_LEADER, From, To } */
    if (ei_decode_pid(header,&index,&msg->from) 
	|| ei_decode_pid(header,&index,&msg->to)) return -1;
    break;
    
  case ERL_EXIT:         /* { EXIT, From, To, Reason } */
  case ERL_EXIT2:        /* { EXIT2, From, To, Reason } */
    if (ei_decode_pid(header,&index,&msg->from) 
	|| ei_decode_pid(header,&index,&msg->to)) return -1;
    break;
    
  case ERL_SEND_TT:      /* { SEND_TT, Cookie, ToPid, TraceToken } */
    if (ei_decode_atom(header,&index,msg->cookie) 
	|| ei_decode_pid(header,&index,&msg->to)
	|| ei_decode_trace(header,&index,&msg->token)) return -1;
    ei_trace(1,&msg->token); /* turn on tracing */
    break;

  case ERL_REG_SEND_TT:  /* { REG_SEND_TT, From, Cookie, ToName, TraceToken } */
    if (ei_decode_pid(header,&index,&msg->from) 
	|| ei_decode_atom(header,&index,msg->cookie) 
	|| ei_decode_atom(header,&index,msg->toname)
	|| ei_decode_trace(header,&index,&msg->token)) return -1;
    ei_trace(1,&msg->token); /* turn on tracing */
    break;

  case ERL_EXIT_TT:     /* { EXIT_TT, From, To, TraceToken, Reason } */
  case ERL_EXIT2_TT:    /* { EXIT2_TT, From, To, TraceToken, Reason } */
    if (ei_decode_pid(header,&index,&msg->from) 
	|| ei_decode_pid(header,&index,&msg->to)
	|| ei_decode_trace(header,&index,&msg->token)) return -1;
    ei_trace(1,&msg->token); /* turn on tracing */
    break;

  case ERL_NODE_LINK:   /* { NODE_LINK } */
    break;

  default:
    /* unknown type, just put any remaining bytes into buffer */
    break;
  }

  /* actual message is remaining part of headerbuf, plus any unread bytes */
  msglen = len - index;     /* message size (payload) */
  remain = len - bytesread; /* bytes left to read */

  /* if callers buffer is too small, we flush in the rest of the
     message and discard it */
  if (msglen > *bufsz) {
    int sz = SMALLBUF;
    /* flush in rest of packet */
    while (remain > 0) {
      if (remain < sz) sz = remain;
      if ((i=read_fill(fd,header,sz)) <= 0) break;
      remain -= i;
    }
    *bufsz = msglen;
    return -1;
  }
  
  /* move remaining bytes to callers buffer */
  memmove(mbuf,header+index,bytesread-index);  

  /* read the rest of the message into callers buffer */
  if (remain > 0) {
    if ((i = read_fill(fd,mbuf+bytesread-index,remain)) != remain) {
      *bufsz = bytesread-index+1; /* actual bytes in users buffer */
      return -1;
    }
  }
  *bufsz = msglen;
    
#ifdef DEBUG_DIST
  ei_show_recmsg(stderr,msg,mbuf);
#endif

  /* the caller only sees "untraced" message types */
  /* the trace token is buried in the message struct */
  if (msg->msgtype > 10) msg->msgtype -= 10;
  
  return msg->msgtype;
}

