/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include <stdlib.h>
#include <string.h>
#include "eihash.h"

extern ei_hash *ei_hash_newtab(int tabsize)
{
  ei_hash *tab=NULL;
  int bucketpos=sizeof(*tab);
  
  /* make sure size is odd, then increase until prime */
  tabsize |= 0x1; 
  while (!ei_isprime(tabsize)) tabsize +=2;

  /* we will only do one malloc, so "sizeof(*tab)" 
   * must be adjusted to align tab->tab properly
   */
  ei_align(bucketpos);

  /* single malloc, then fill in all fields */
  if ((tab = malloc(bucketpos + (tabsize * (sizeof(*(tab->tab))))))) {
    tab->tab = (ei_bucket **)((char *)tab + bucketpos);
    memset(tab->tab,0,tabsize*sizeof(*(tab->tab)));
    tab->hash = ei_dohash;
    tab->size = tabsize;
    tab->npos = 0;
    tab->nelem = 0;
    tab->freelist = NULL;
  }

  return tab;
}

