/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include <stdlib.h>
#include "eihash.h"

/* remove all the key-values from a table. The 
 * values are removed with
 * the user-provided function f. 
 */
extern int ei_hash_freetab(ei_hash *tab, void (*f)(void *))
{
  ei_bucket *b, *next;
  int i;

  for (i=0; i<tab->size; i++) {
    b=tab->tab[i];
    while (b) {
      next = b->next;

      if (f) f((void *)b->value);

      /* no point in saving these buckets on freelist */
      free(b); 
      b = next;
    }
  }

  /* remove the freelist */
  b = tab->freelist;
  while (b) {
    next = b->next;
    free(b);
    b = next;
  }
  
  /* remove the table */
  free(tab);

  return 0;
}
