/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include "eihash.h"

/* perform f(key,value) on each key-value pair in the table.
 * hash_foreach() will traverse the table until the end is reached or
 * until f() returns a non-zero value, whichever comes first. The
 * return value from f() will be returned to the caller, or 0 if the
 * entire table was traversed.
 */
extern int ei_hash_foreach(ei_hash *tab, int (*f)(const char *key, const void *value))
{
  ei_bucket *b;
  int i;
  int r;

  for (i=0; i<tab->size; i++) {
    b=tab->tab[i];
    while (b) {
      if (f && (r=f(b->key,b->value))) return r;
      b = b->next;
    }
  }
  return 0;
}

