/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include "eihash.h"

/* This is hashpjw, from the dragon book */
/* Note that this function is only used as a default hash function.
 * All calls are made through the hash pointer in the tab structure.
 * The only place this function is explicitly referenced is in
 * hash_newtab(); Users can use hash_setfunc() to change the hash function.
 */
extern int ei_dohash(const char *key) 
{
  const char *s;
  unsigned h = 0;
  unsigned g;
  
  for (s=key; *s; s++) {
    h = (h << 4) + *s;
    if ((g = (h & 0xf0000000))) { /* assumes 32-bit int */
      h = h^(g >> 24);
      h = h^g;
    }
  }
  return h;
}


