/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/* these are the dummy locking functions, used
 * when no threads package is linked in
 * see also erl_pthreads.c and erl_sthreads.c
 */

#include <stdlib.h>

#ifdef DEBUG
#include <stdio.h>
#endif

extern int erl_locking_init_done;
extern void erl_common_init(void *, long);
int erl_init_nothreads(void *x, long y)
{
#ifdef DEBUG
#if defined(VXWORKS) || defined (__WIN32__)
  fprintf(stderr,"erl_interface using native locks\n");
#else
  fprintf(stderr,"erl_interface using no locks\n");
#endif
#endif
  erl_common_init(x,y);
  return 0; /*success */
}

#if !defined(VXWORKS) && !defined(__WIN32__)

void *erl_m_create(void)   { return NULL; }
int erl_m_destroy(void *l) { return 0; }
int erl_m_lock(void *l)    { return 0; }
int erl_m_trylock(void *l) { return 0; } 
int erl_m_unlock(void *l)  { return 0; } 

#ifndef NO_PRAGMA_WEAK
/* above symbols must be weak since 
 * they are multiply defined 
 */
#pragma weak erl_m_create
#pragma weak erl_m_destroy
#pragma weak erl_m_lock
#pragma weak erl_m_trylock
#pragma weak erl_m_unlock

#endif

#endif
