/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include "ei.h"
#include "putget.h"

/* remove version identifier from the start of the buffer */
int ei_decode_version(const char *buf, int *index, int *version)
{
  const char *s = buf + *index;
  const char *s0 = s;
  int v;
  
  v = get8(s);
  if (version) *version = v;
  if (v != ERL_VERSION_MAGIC) return -1;
  
  *index += s-s0;
  
  return 0;
}
