/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */

/* This file is copyright (c) Ellemtel in May 1993
 *
 * Program to create the file "config.c"
 * it takes as arguments a list of files called xxxdrv.o[bj]
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static char *strip();
static void before_entries();
static void after_entries();

main(argc, argv)
int argc;
char *argv[];
{
    FILE *of;
    int entry;
    char* output_file = "config.c";

    while (argc > 1 && argv[1][0] == '-') {
	switch (argv[1][1]) {
	case 'o':
	    if (argc < 3) {
		fprintf(stderr, "mkconfig: No argument following -o\n");
		exit(1);
	    }
	    output_file = argv[2];
	    argc--, argv++;
	    break;
	default:
	    fprintf(stderr, "mkconfig: Invalid option: %s\n", argv[1]);
	    exit(1);
	}
	argc--, argv++;
    }

    if((of = fopen(output_file, "w")) == NULL) {
	fprintf(stderr, "mkconfig: Failed to create %s\n", output_file);
	exit(1);
    }
    before_entries(of);

    for(entry=1; entry < argc; entry++)
	fprintf(of, "extern struct driver_entry %sdriver_entry;\n",
		strip(argv[entry]));
    fprintf(of, "\nstruct driver_entry * driver_tab[DRIVER_TAB_SIZE] =\n{\n");
    for(entry=1; entry < argc; entry++)
	fprintf(of, "    &%sdriver_entry,\n", strip(argv[entry]));
    fprintf(of, "    NULL\n};\n\n");

    after_entries(of);
    fclose(of);
    return 0;
}

static char*
strip(t)
char *t;
{
    char *cp, *end;

    if ((cp = strrchr(t, '/')) != NULL)
	cp++;
#ifdef __WIN32__
    else if ((cp = strrchr(t, '\\')) != NULL)
	cp++;
#endif
    else
	cp = t;

    /* Now we have the begining, just find "drv." and make that the end */
    /* if we can't find it we assume the name is ok as it is... */
    if ((end=strrchr(cp, 'd')) != NULL) 
	if (end[1]=='r' && end[2]=='v' && end[3]=='.')
	    *end = '\0';

    return cp;
}

#define PR(str)  fprintf(of, "%s\n", str);

static void
before_entries(of)
FILE *of;
{
PR("/*")
PR(" * This file is copyright (c) Ellemtel in December 1992")
PR(" * (this file was generated by mkconfig)")
PR(" *")
PR(" * Author: Claes Wikstrom & Per Hedeland")
PR(" *")
PR(" */")
PR("")
PR("#include <stdio.h>")
PR("#include <stdlib.h>")
#ifdef __WIN32__
PR("#include <stdarg.h>")
#else
PR("#ifdef __STDC__")
PR("#include <stdarg.h>")
PR("#else")
PR("#include <varargs.h>")
PR("#define const")
PR("#endif")
#endif
PR("#include \"driver.h\"")
PR("extern void erl_crash_dump();");
PR("extern void erl_reset();");
#ifdef __WIN32__
PR("extern void ConWaitForExit(void);");
#endif
/* There ought to be a symbol "UNIX" or "SOLARIS"; that is what we mean */
#if !defined(__WIN32__) && !defined(VXWORKS)
PR("extern void sys_stop_cat(void);")
#endif
PR("")
PR("#if defined(__STDC__)");
PR("void erl_error(char *, va_list);");
PR("void erl_exit(int,char *, ...);");
PR("#endif /* defined(__STDC__) */");
PR("")
PR("/*")
PR(" * User-settable configuration parameters.")
PR(" * Carefully note the restrictions on the values - for your convenience,")
PR(" * Needless to say, using improper values may cause the system to become")
PR(" * non-functional in random ways.")
PR(" * The bytes-per-unit figures are for a 32-bit system; 64-bit systems")
PR(" * will use more, though not quite twice as much.")
PR(" */")
PR("")
PR("/* Max no. of ports. Each port table entry uses 52 bytes. Note that")
PR("   the no. of available file descriptors (determined at run-time)")
PR("   may put a lower bound on the no. of simultaneously open ports. */")
PR("const int MAX_PORTS = 256;")
PR("")
PR("/* Max no. of drivers (linked in and dynamically loaded. Each table")
PR("   entry uses 4 bytes. */")
PR("#define DRIVER_TAB_SIZE 16")
PR("const int driver_tab_size = DRIVER_TAB_SIZE;")
PR("")
PR("/* Size in bytes of a temporary buffer used for many operations. Must")
PR("   be at least 2048. Setting this very low will have a negative impact")
PR("   on performance since memory will be allocated/freed in some cases;")
PR("   in other cases it imposes a hard limit (e.g. list_to_atom/1 or the")
PR("   result of erlang:info/1). Conversely, setting it very high might")
PR("   improve performance in a few cases. */")
PR("const int TMP_BUF_SIZE = 65536;")
PR("")
PR("")
PR("")
PR("/*")
PR(" * The global driver table, all drivers callable from the")
PR(" * system need to be inserted into this global driver table")
PR(" */")
PR("")
PR("/* very useful function that can be used in entries that are not used")
PR("   so that not every driver writer must supply a personal version */")
PR("")
PR("int null_func()")
PR("{")
PR("    return 0;")
PR("}")
PR("")
PR("/* Driver entries are installed here */")
}

static void
after_entries(of)
FILE *of;
{
PR("/*")
PR(" * Common error printout function, all error messages")
PR(" * that don't go to the error logger go through here.")
PR(" */")
PR("")
PR("void erl_error(fmt, args)")
PR("char *fmt;")
PR("va_list args;")
PR("{")
PR("    vfprintf(stderr, fmt, args);")
PR("}")
PR("")
PR("/*")
PR(" * Common exit function, all exits from the system go through here.")
PR(" * n <= 0 -> normal exit with status n;")
PR(" * n = 127 -> Erlang crash dump produced, exit with status 1;")
PR(" * other positive n -> Erlang crash dump and core dump produced.")
PR(" */")
PR("")
#if !defined(__WIN32__) && !defined(VXWORKS)
PR("#ifdef __STDC__")
#endif
PR("void erl_exit(int n, char *fmt,...)")
PR("{")
PR("    va_list args;")
PR("")
PR("    va_start(args, fmt);")
#if !defined(__WIN32__) && !defined(VXWORKS)
PR("#else")
PR("void erl_exit(va_alist)")
PR("va_dcl")
PR("{")
PR("    va_list args;")
PR("    char *fmt;")
PR("    int n;")
PR("")
PR("    va_start(args);")
PR("    n = va_arg(args, int);	/* Exit value */")
PR("    fmt = va_arg(args, char *);")
PR("#endif")
#endif
PR("")
PR("    /* Produce an Erlang core dump if error */")
PR("    if(n > 0) erl_crash_dump(fmt,args); ")
PR("    erl_reset();		/* Close ports etc. */")
#if defined(VXWORKS)
/* need to reinitialize va_args thing */
PR("    va_start(args, fmt);");
#endif
PR("    if (fmt != NULL && *fmt != '\\0')")
PR("	  erl_error(fmt, args);	/* Print error message. */")
PR("    va_end(args);")
#ifdef __WIN32__
PR("    if(n > 0) ConWaitForExit();")
#endif
#if !defined(__WIN32__) && !defined(VXWORKS)
PR("    sys_stop_cat();")
#endif
PR("    if (n == 127)")
PR("        exit(1);")
PR("    else if (n > 0)")
PR("        abort();")
PR("    else")
PR("        exit(abs(n));")
PR("}")
}
