/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
** This file is copyright (c) Ellemtel in January 1991
**
** File: global.h
*/
#ifndef __GLOBAL_H__
#define __GLOBAL_H__

#include "hash.h"
#include "index.h"
#include "atom.h"
#include "export.h"
#include "module.h"
#include "register.h"

#include "erl_process.h"
#include "driver.h"

typedef enum {
    LNK_UNDEF = 0,
    LNK_LINK  = 1,  /* normal link */
    LNK_NODE  = 2,  /* node link */
    LNK_OMON  = 3,  /* originating object monitor */
    LNK_TMON  = 4   /* terminating object monitor */
} ErlLinkType;

typedef struct erl_link {
    struct erl_link* next;
    ErlLinkType type;       /* Type of link */
    uint32 item;            /* the linked item */
    uint32 data;            /* data depending on use */
} ErlLink;

EXTERN_FUNCTION(ErlLink*, new_link, (ErlLink*,ErlLinkType,uint32,uint32));
EXTERN_FUNCTION(void, del_link, (ErlLink**));
EXTERN_FUNCTION(ErlLink**, find_link, (ErlLink**,ErlLinkType,uint32,uint32));

/* The 9-bit node part of a pid is an index in a table pointing
   to a struct of dist_entry 
   slot 0 is reserved for ourselves allthough we don't hash ourselves to 0 
*/

#define THIS_NODE 0     /* replace the global variable "node" */

#define D_EXITING   1   /* Status field vals  for dist_enntry's */
#define D_HIDDEN    2
#define D_REAL_BUSY 4
#define D_RESERVED  8   /* Set-cookie called thing */

#define DIST_DATA   100  /* data on input command (from inet_drv) */
#define DIST_SEND   22   /* send command byte  (to inet_drv) */

#define MAXINDX 255

typedef struct cache {
    uint32 in_arr[MAXINDX];
    uint32 out_arr[MAXINDX];
} ErlCache;

typedef struct dist_entry {
    uint32 sysname;        /* pointer to name@host for efficiency */
    uint32 cid;            /* connection handler (pid or port), NIL == free */
    ErlLink* links;        /* external link/monitors/node links */
    uint32 status;         /* needed ??? */
    ErlCache* cache;       /* The atom cache */
    unsigned long version; /* Protocol version */
} DistEntry;

typedef struct _process_list {
    uint32 pid;			/* Waiting process. */
    struct _process_list* next;	/* Next waiting process. */
} ProcessList;

#define SMALL_IO_QUEUE 5   /* Number of fixed elements */

typedef struct {
    int size;       /* total size in bytes */

    SysIOVec* v_start;
    SysIOVec* v_end;
    SysIOVec* v_head;
    SysIOVec* v_tail;
    SysIOVec  v_small[SMALL_IO_QUEUE];

    DriverBinary** b_start;
    DriverBinary** b_end;
    DriverBinary** b_head;
    DriverBinary** b_tail;
    DriverBinary*  b_small[SMALL_IO_QUEUE];
} ErlIOQueue;

typedef struct line_buf {  /* Buffer used in line oriented I/O */
    int bufsiz;              /* Size of character buffer */
    int ovlen;               /* Length of overflow data */
    int ovsiz;               /* Actual size of overflow buffer */
    char data[1];            /* Starting point of buffer data,
			      data[0] is a flag indicating an unprocess CR,
			      The rest is the overflow buffer. */
} LineBuf;

typedef struct port {
    uint32 id;                   /* The Port id of this port */
    uint32 connected;            /* A connected process */
    uint32 status;   		 /* Status and type flags */
    ErlLink* links;              /* List of links */
    uint32 bytes_in;             /* Number of bytes read */
    uint32 bytes_out;            /* Number of bytes written */
    ErlTimer tm;                 /* Timer entry */
    ErlIOQueue ioq;              /* driver accessible i/o queue */
    int    dslot;                /* Dist slot used in DISTRIBUTION */
    char *name;		         /* String used in the open */
    struct driver_entry* drv_ptr;
    long drv_data;
    ProcessList *suspended;	 /* List of suspended processes. */
    LineBuf *linebuf;            /* Buffer to hold data not ready for
				    process to get (line oriented I/O)*/
} Port;

typedef struct driver_binary Binary;

/* Each process has a linked list of these in it. */
/* These structures represent objects that need to run some */
/* finalization code when deleted, i.e. binaries     */

typedef struct proc_bin {
    struct proc_bin *next;
    char mark;
    Binary *val;
    byte *bytes;
    uint32 size;
} ProcBin;

/* Atexit is pairs of function and arguments */
#define ERL_MAX_EXITS 20  /* at most 20 functions */

typedef FUNCTION(void, (*ErlExitProc), (void*));

typedef struct {
    ErlExitProc exit_proc;
    void* exit_arg;
} ErlExitStruct;


/* arrays that get malloced at startup */
extern Port*      port;
extern DistEntry* dist_addrs;
extern byte*      tmp_buf;

extern uint32 node_cookie;
extern int    tot_bin_allocated;
extern int    this_creation;
extern uint32 this_node;         /* mysyst@myhost    */
extern uint32 context_switches;	/* no of context switches */
extern uint32 bytes_out;        /* No bytes written out */
extern uint32 bytes_in;         /* No bytes sent into the system */
extern uint32 display_items;	/* no of items to display in traces etc */
extern uint32 reductions;	/* total number of reductions */
extern uint32 garbage_cols;	/* no of garbage collections */
extern uint32 reclaimed;	/* no of words reclaimes in GC's */
extern uint32 display_loads;	/* print info about loaded modules */
extern uint32 do_time;		/* set at clock interupt */
extern uint32 last_reds;	/* to calculate no of reds since last call */
extern int    MAXDIST;
extern int switch_gc_threshold; /* Switch from fullsweep GC to 
				   generational when live data >= 
				   this many words (default value)*/

#define HS_FIBONACCI 0		/* Fibonacci */
#define HS_POWER_TWO 1		/* Powers of two */
#define HS_POWER_TWO_MINUS_ONE 2 /* Powers of two minus one word */
extern int heap_series;		/* Series to use for heap size. */

extern int typeval[16];         /* tag_val_def -> type code */
extern uint32 bif_gc;           /* gc calls by bif */
extern int bif_reductions;      /* reductions + fcalls (when doing call_bif) */
extern int error_on_unregistered_send;

/* For the fix allocator */
extern int process_desc;
extern int table_desc;
extern int proc_bin_desc;
extern int atom_desc;
extern int export_desc;
extern int module_desc;
extern int preg_desc;
extern int link_desc;
extern int plist_desc;
extern int mesg_desc;


#ifdef DEBUG
extern uint32 verbose;		/* noisy mode = 1 */
#endif

#ifdef SEQ_TRACE
extern uint32 system_seq_tracer;
#endif
#ifdef INSTRUMENT
#define INSTR_SEND_SIZES_MAX 65535
extern uint32 instr_send_sizes[INSTR_SEND_SIZES_MAX];
#endif

/* flags  for the port status info*/

#define FREE          0
#define CONNECTED     (1 << 0)
#define EXITING       (1 << 1)
#define DISTRIBUTION  (1 << 2)
#define BINARY_IO     (1 << 3)
#define SOFT_EOF      (1 << 4)
#define PORT_BUSY     (1 << 5)  /* Flow control on ports */
#define CLOSING       (1 << 6)  /* Port is closing (no i/o accepted ) */
#define SEND_CLOSED   (1 << 7)  /* Send a closed message when terminating */
#define LINEBUF_IO    (1 << 8)  /* Line orinted io on port */

/* binary.c */
/* We have four different gc sweap marks on Binaries */
#define BIN_INITIAL           0
#define BIN_MARKED            1
#define BIN_OLD               2
#define BIN_FULLSWEAP_MARKED  3

EXTERN_FUNCTION(void, maybe_delete_contents, (ProcBin*));
EXTERN_FUNCTION(void, generation_bin_gc, (Process*));
EXTERN_FUNCTION(void,  fullsweap_bin_gc, (Process*));

/* binary.c */
EXTERN_FUNCTION(uint32, new_binary, (Process*, byte*, int));
EXTERN_FUNCTION(ProcBin*, alloc_binary, (ProcBin**, byte*, int));
EXTERN_FUNCTION(ProcBin*, copy_binary, (ProcBin**, ProcBin*));
EXTERN_FUNCTION(int, maybe_gc_binary, (Process*, uint32*));
EXTERN_FUNCTION(void, insert_pb, (ProcBin **, ProcBin *));
EXTERN_FUNCTION(void, proc_bin_gc, (Process *));


/* beam_load.c/jam_load.c */
EXTERN_FUNCTION(int, bin_load, (uint32, uint32, byte*, int));
EXTERN_FUNCTION(void, init_load, (_VOID_));
EXTERN_FUNCTION(int, delete_module, (uint32, int));
EXTERN_FUNCTION(int, check_process_code, (Process*, uint32, int));
EXTERN_FUNCTION(int, purge_module, (int));
#ifdef BEAM
EXTERN_FUNCTION(uint32, exported_from_module, (Process* p, uint32 mod));
EXTERN_FUNCTION(uint32, attributes_for_module, (Process* p, uint32 mod, uint32 list));
uint32* find_function_from_pc(uint32* pc);
#endif

/* break.c */
EXTERN_FUNCTION(void, init_break_handler, (_VOID_));
EXTERN_FUNCTION(void, process_info, (CIO));
EXTERN_FUNCTION(void, print_process_info, (Process*, CIO));
EXTERN_FUNCTION(void, info, (CIO));
EXTERN_FUNCTION(void, loaded, (CIO));

/* config.c */
EXTERN_FUNCTION(void, erl_exit, (int n, char*, _DOTS_));
EXTERN_FUNCTION(void, erl_error, (char*, va_list));

/* copy.c */
void init_copy(void);
EXTERN_FUNCTION(int, copy_object, (uint32, Process*, uint32, uint32*,Process*));
EXTERN_FUNCTION(int, copy_objects, (uint32*,int,Process*,uint32,uint32*,Process*));
EXTERN_FUNCTION(uint32, size_object, (uint32));
EXTERN_FUNCTION(uint32, copy_struct, (uint32,uint32,uint32**,ProcBin**));
EXTERN_FUNCTION(uint32, copy_shallow, (uint32*, uint32,
				       uint32**, ProcBin**));

/* dist.c */
EXTERN_FUNCTION(void, clear_cache, (int));
EXTERN_FUNCTION(void, create_cache, (int));
EXTERN_FUNCTION(void, delete_cache, (int));
EXTERN_FUNCTION(int, is_node_name, (char*, int));

EXTERN_FUNCTION(int,  do_net_exits, (int));
EXTERN_FUNCTION(void, init_dist, (_VOID_));
EXTERN_FUNCTION(int,  net_mess2, (int, byte*, int, byte*, int));
EXTERN_FUNCTION(int,  remove_from_link_list, (int, uint32, uint32));
EXTERN_FUNCTION(int,  add_to_link_list, (int, uint32, uint32));
EXTERN_FUNCTION(int,  sysname_to_dist_slot, (uint32));
EXTERN_FUNCTION(int,  find_or_insert_dist_slot, (uint32));
EXTERN_FUNCTION(int,  stop_dist, (_VOID_));
EXTERN_FUNCTION(int,  distribution_info, (CIO));

EXTERN_FUNCTION(void, erl_progressf, (char* format, ...));

#ifdef MESS_DEBUG
EXTERN_FUNCTION(void, print_pass_through, (int, byte*, int));
#endif

/* jam_emu.c/beam_emu.c */
EXTERN_FUNCTION(void, init_emulator, (_VOID_));
EXTERN_FUNCTION(int, process_main, (Process*, int));

/* erl91.c */
EXTERN_FUNCTION(void, erl_start, (int, char**));

/* external.c */
EXTERN_FUNCTION(int, to_external, (int, uint32, byte**));
EXTERN_FUNCTION(uint32, from_external, (int, uint32**, byte**,ProcBin**));
EXTERN_FUNCTION(uint32, encode_size_struct, (uint32));
EXTERN_FUNCTION(int, decode_size, (byte*, int));
EXTERN_FUNCTION(int, dec_size, (byte*, uint32));

/* fix_alloc.c */
EXTERN_FUNCTION(void, init_alloc, (_VOID_));
EXTERN_FUNCTION(int, init_fix_alloc, (int));
EXTERN_FUNCTION(int, fix_info, (int));
EXTERN_FUNCTION(int, new_fix_size, (int));
EXTERN_FUNCTION(void, fix_release, (int));
EXTERN_FUNCTION(void, fix_free, (int, uint32*));
EXTERN_FUNCTION(uint32*, fix_alloc, (int));

/* ggc.c */
EXTERN_FUNCTION(void, init_gc, (_VOID_));
EXTERN_FUNCTION(int, do_gc, (Process*, int));
EXTERN_FUNCTION(int, do_gc2, (Process*, int, uint32*, int));
EXTERN_FUNCTION(int, next_heap_size, (int, int));

EXTERN_FUNCTION(void, stack_shrink, (Process*, uint32));
EXTERN_FUNCTION(void, stack_grow, (Process*, uint32));

EXTERN_FUNCTION(void, heap_compact, (Process*, uint32));
EXTERN_FUNCTION(void, heap_add, (Process*, uint32));
#ifdef HARDDEBUG
EXTERN_FUNCTION(void, check_heap, (Process*));
EXTERN_FUNCTION(void, check_stack, (Process*));
EXTERN_FUNCTION(void, check_heap_before, (Process*));
#endif

/* io.c */

EXTERN_FUNCTION(void, wake_process_later, (uint32, Process*));
EXTERN_FUNCTION(int, open_driver, (struct driver_entry*,
				   uint32, char*, struct _SysDriverOpts*));
EXTERN_FUNCTION(void, close_port, (uint32));
EXTERN_FUNCTION(void, init_io, (_VOID_));
EXTERN_FUNCTION(void, cleanup_io, (_VOID_));
EXTERN_FUNCTION(void, do_exit_port, (uint32, uint32, uint32));
EXTERN_FUNCTION(void, port_command, (uint32, uint32));
EXTERN_FUNCTION(int, port_control, (Process*, Port*, uint32,
				    uint32, uint32*));
EXTERN_FUNCTION(int, write_port, (int p, uint32 list));
EXTERN_FUNCTION(void, print_port_info, (int, CIO));
EXTERN_FUNCTION(void, dist_port_command, (Port*, byte*, int));
EXTERN_FUNCTION(void, input_ready, (int, int));
EXTERN_FUNCTION(void, output_ready, (int, int));
EXTERN_FUNCTION(int, driver_output, (int, char*, int));
EXTERN_FUNCTION(int, driver_failure, (int, int));
EXTERN_FUNCTION(void, set_busy_port, (int, int));
EXTERN_FUNCTION(LineBuf *, allocate_linebuf, (int));

/* time.c */
EXTERN_FUNCTION(void, increment_time, (int));
EXTERN_FUNCTION(void, bump_timer, (_VOID_));
EXTERN_FUNCTION(void, init_time, (_VOID_));
EXTERN_FUNCTION(void, erl_set_timer, (ErlTimer*,ErlTimeoutProc,ErlCancelProc,
				      void*, uint32));
EXTERN_FUNCTION(void, erl_cancel_timer, (ErlTimer*));
EXTERN_FUNCTION(uint32, time_left, (ErlTimer *));
EXTERN_FUNCTION(int, next_time, (_VOID_));

#ifdef DEBUG
EXTERN_FUNCTION(void, p_slpq, (_VOID_));
#endif

/* utils.c */
#define erl_printf sys_printf
#define erl_putc   sys_putc

EXTERN_FUNCTION(void, erl_suspend, (Process*, uint32));
EXTERN_FUNCTION(void, erl_resume, (Process*));

EXTERN_FUNCTION(uint32*, halloc, (Process*, uint32));
EXTERN_FUNCTION(int, list_length, (uint32));
EXTERN_FUNCTION(int, find_function, (uint32, uint32, int));
EXTERN_FUNCTION(uint32, double_to_integer, (Process*, double));
EXTERN_FUNCTION(uint32, make_hash, (uint32, uint32));

EXTERN_FUNCTION(int, send_error_to_logger, (uint32));
EXTERN_FUNCTION(void*, safe_alloc, (uint32));
EXTERN_FUNCTION(void*, safe_realloc, (char*,uint32));
EXTERN_FUNCTION(int, eq, (uint32, uint32));
EXTERN_FUNCTION(int, cmp, (uint32, uint32));
EXTERN_FUNCTION(Process*, pid2proc, (uint32));
EXTERN_FUNCTION(void, display, (uint32, CIO));
EXTERN_FUNCTION(void, ldisplay, (uint32, CIO, int));
EXTERN_FUNCTION(void, print_atom, (int, CIO));

EXTERN_FUNCTION(void, trace_send, (Process*, uint32, uint32));
EXTERN_FUNCTION(void, trace_receive, (Process*, uint32));
EXTERN_FUNCTION(void, trace_proc, (Process*, uint32, uint32));
EXTERN_FUNCTION(void, trace_sched, (Process*, uint32));
void trace_gc(Process *p, uint32 what);
EXTERN_FUNCTION(int,  member, (uint32, uint32));
EXTERN_FUNCTION(double, bytes_to_float, (byte*));
EXTERN_FUNCTION(void, float_to_bytes, (byte*, double));
EXTERN_FUNCTION(void, bin_write, (CIO, byte*, int));
EXTERN_FUNCTION(int, intlist_to_buf, (uint32, byte*, int));
EXTERN_FUNCTION(char*, int_to_buf, (int, char*));
EXTERN_FUNCTION(uint32, buf_to_intlist, (uint32**, byte*, int, uint32));
EXTERN_FUNCTION(int, io_list_to_buf, (uint32, char*, int*, int));
EXTERN_FUNCTION(int, io_list_len, (uint32));
EXTERN_FUNCTION(int, is_string, (uint32));
EXTERN_FUNCTION(int, do_load, (uint32, uint32,
			       byte*, int));
EXTERN_FUNCTION(void, erl_at_exit, (FUNCTION(void,(*),(void*)), void*));
EXTERN_FUNCTION(void, erl_reset, (_VOID_));
EXTERN_FUNCTION(uint32, collect_memory, (Process *));

EXTERN_FUNCTION(int, find_bif, (int, int));
EXTERN_FUNCTION(const char*, bif_name, (int));

#ifdef DEBUG
EXTERN_FUNCTION(int, check_struct, (uint32));

EXTERN_FUNCTION(void, upp, (byte*, int));
EXTERN_FUNCTION(void, pat, (uint32));
EXTERN_FUNCTION(void, pinfo, (_VOID_));
EXTERN_FUNCTION(void, pp, (Process*));
EXTERN_FUNCTION(void, ppi, (uint32));
EXTERN_FUNCTION(void, pba, (Process*, int));
EXTERN_FUNCTION(void, td, (uint32));
EXTERN_FUNCTION(void, ps, (Process*, uint32*));
#endif

#ifdef SEQ_TRACE
#define seq_trace_output(a,b,c,d) seq_trace_output_exit(a, b, c, d, NIL)
EXTERN_FUNCTION(void, seq_trace_output_exit, (uint32, uint32, uint32, uint32, uint32));
EXTERN_FUNCTION(int, seq_trace_update_send, (Process*));
#endif

#endif
