/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
** File: export.h
** Author: Tony Rovall
**
*/

#ifndef __EXPORT_H__
#define __EXPORT_H__

#ifndef __SYS_H__
#include "sys.h"
#endif

#ifndef __INDEX_H__
#include "index.h"
#endif

/*
** Export entry
*/
typedef struct export
{
    IndexSlot slot; /* MUST BE LOCATED AT TOP OF STRUCT!!! */
    int module;
    int function;
    int arity;
    void* address;
#ifdef BEAM
    uint32 op_error_handler;	/* Call to error handler */
#endif
} Export;


EXTERN_FUNCTION(int, export_get, (int, int, int));
EXTERN_FUNCTION(int, export_put, (int, int, int));

EXTERN_FUNCTION(void, init_export_table, (_VOID_));
EXTERN_FUNCTION(void, export_info, (CIO));

extern IndexTable export_table;

#define export_list(i)    ((Export*)export_table.table[i])
#define export_list_size  export_table.sz

#endif
