/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
** File: erl_message.h
** Author: Tony Rogvall
** Description:
**     Erlang message structure
*/
#ifndef __ERL_MESSAGE_H__
#define __ERL_MESSAGE_H__

struct proc_bin;

typedef struct erl_mesg {
    struct erl_mesg* next;  /* next message */
    uint32 mesg;            /* The message (in buffer or heap) */
#ifdef SEQ_TRACE
    uint32 seq_trace_token; /* The seq_trace_token NIL if not used */
#endif
} ErlMessage;

typedef struct {
    ErlMessage* first;
    ErlMessage** last;  /* point to the last next pointer */
    ErlMessage** save;
    int len;            /* quaue length */
} ErlMessageQueue;

/* A term suitable for placing in heap */
/* Add a struct proc_bin* mso; for the multi threaded version */

typedef struct erl_mesg_buf
{
    struct erl_mesg_buf* next;  /* Next message buffer */
    struct proc_bin*     mso;   /* Associated binaries */
    uint32           size;      /* Size in words of mem */
    uint32           mem[1];    /* data */
} ErlMessageBuffer;

/* Get "current" message */
#define PEEK_MESSAGE(p)  (*(p)->msg.save)

/* Add message last in message queue */
#define LINK_MESSAGE(p, mp) do { \
    *(p)->msg.last = (mp); \
    (p)->msg.last = &(mp)->next; \
    (p)->msg.len++; \
} while(0)

/* Unlink current message */
#define UNLINK_MESSAGE(p) do { \
     ErlMessage* __mp = (*(p)->msg.save)->next; \
     *(p)->msg.save = __mp; \
     (p)->msg.len--; \
     if (__mp == NULL) \
         (p)->msg.last = (p)->msg.save; \
} while(0)

/* Reset message save point (after receive match) */
#define JOIN_MESSAGE(p) \
     (p)->msg.save = &(p)->msg.first

/* Save current message */
#define SAVE_MESSAGE(p) \
     (p)->msg.save = &(*(p)->msg.save)->next

struct process;

EXTERN_FUNCTION(void, init_message, (_VOID_));
EXTERN_FUNCTION(void, free_message, (ErlMessage*));
EXTERN_FUNCTION(ErlMessageBuffer*, new_message_buffer, (uint32));
EXTERN_FUNCTION(void, free_message_buffer, (ErlMessageBuffer*));
#ifdef SEQ_TRACE
EXTERN_FUNCTION(ErlMessage*, new_message, (uint32, uint32));
EXTERN_FUNCTION(void, queue_message_tt, (struct process*, ErlMessageBuffer*,
					 uint32, uint32));
#define queue_message(a, b, c) queue_message_tt(a, b, c, NIL)
EXTERN_FUNCTION(void, deliver_exit_message_tt, (uint32, struct process*, uint32, uint32));
#define deliver_exit_message(a, b, c) deliver_exit_message_tt(a, b, c, NIL)
#else
#define deliver_exit_message_tt(a, b, c, d) deliver_exit_message(a, b, c)
EXTERN_FUNCTION(ErlMessage*, new_message, (uint32));
EXTERN_FUNCTION(void, queue_message, (struct process*, ErlMessageBuffer*,uint32));
EXTERN_FUNCTION(void, deliver_exit_message, (uint32, struct process*, uint32));
#endif
EXTERN_FUNCTION(void, send_message,(struct process*, struct process*, uint32));
EXTERN_FUNCTION(void, send_msg, (uint32, uint32));

EXTERN_FUNCTION(void, deliver_result, (uint32, uint32, uint32));

#endif
