/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
** Interface to elib statistics
**
*/
#ifndef __ELIB_STAT_H__
#define __ELIB_STAT_H__

struct elib_stat {
    int mem_total;    /* Number of heap words  */
    int mem_blocks;   /* Number of block */
    int mem_alloc;    /* Number of words in use */
    int mem_free;     /* Number of words free */
    int min_used;     /* Size of the smallest block used */
    int max_free;     /* Size of the largest free block */
    int free_blocks;  /* Number of fragments in free list */
};

EXTERN_FUNCTION(void, elib_statistics, (void*));
EXTERN_FUNCTION(int,  elib_check_heap, (_VOID_));
EXTERN_FUNCTION(void, elib_heap_dump, (char*));
EXTERN_FUNCTION(void, elib_stat, (struct elib_stat*));
EXTERN_FUNCTION(int,  elib_heap_map, (unsigned char*, int));
EXTERN_FUNCTION(int,  elib_histo, (unsigned long*, unsigned long*, int, int));

#endif
