/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
** File: elib.h
** 
**
*/
#include <stdlib.h>

#ifndef __ELIB_H__
#define __ELIB_H__

EXTERN_FUNCTION(void, elib_init, (void*, int));

EXTERN_FUNCTION(void*, elib_memset, (void*, int, int));
EXTERN_FUNCTION(void*, elib_memcpy, (void*, void*, int));
EXTERN_FUNCTION(int,   elib_memcmp, (void*, void*, int));
EXTERN_FUNCTION(void*, elib_memmove, (void*, void*, int));

EXTERN_FUNCTION(int,   elib_strlen, (char*));
EXTERN_FUNCTION(char*, elib_strcpy, (char*, char*));
EXTERN_FUNCTION(char*, elib_strncpy, (char*, char*, int));
EXTERN_FUNCTION(int,   elib_strcmp, (char*, char*));
EXTERN_FUNCTION(int,   elib_strncmp, (char*, char*, int));
EXTERN_FUNCTION(char*, elib_strchr, (char*, int));

EXTERN_FUNCTION(void*, elib_malloc, (size_t));
EXTERN_FUNCTION(void*, elib_calloc, (size_t, size_t));
EXTERN_FUNCTION(void*, elib_realloc, (void*, size_t));
EXTERN_FUNCTION(void,  elib_free, (void*));
EXTERN_FUNCTION(void*, elib_memalign, (int, int));
EXTERN_FUNCTION(int,   elib_memsize, (void*));
EXTERN_FUNCTION(void*, elib_memresize, (void*, int));

#if defined(ELIB_IS_CLIB)

EXTERN_FUNCTION(void*, memset, (void*, int, int));
EXTERN_FUNCTION(void*, memcpy, (void*, void*, int));
EXTERN_FUNCTION(int,   memcmp, (void*, void*, int));
EXTERN_FUNCTION(void*, memmove, (void*, void*, int));

EXTERN_FUNCTION(int,   strlen, (char*));
EXTERN_FUNCTION(char*, strcpy, (char*, char*));
EXTERN_FUNCTION(char*, strncpy, (char*, char*, int));
EXTERN_FUNCTION(int,   strcmp, (char*, char*));
EXTERN_FUNCTION(int,   strncmp, (char*, char*, int));
EXTERN_FUNCTION(char*, strchr, (char*, int));

#endif

#if defined(ELIB_IS_CLIB) || defined(ELIB_ALLOC_IS_CLIB)

EXTERN_FUNCTION(void*, malloc, (size_t));
EXTERN_FUNCTION(void*, calloc, (size_t, size_t));
EXTERN_FUNCTION(void*, realloc, (void*, size_t));
EXTERN_FUNCTION(void,  free, (void*));

/* These functions are not standard but included anyway */
EXTERN_FUNCTION(void*, memalign, (int, int));
EXTERN_FUNCTION(int,   memsize, (void*));
EXTERN_FUNCTION(void*, memresize, (void*, int));

#endif


#ifdef ELIB_DEBUG

EXTERN_FUNCTION(void*, elib_dbg_memset, (void*, int, int, char*, int));
EXTERN_FUNCTION(void*, elib_dbg_memcpy, (void*, void*, int, char*, int));
EXTERN_FUNCTION(int,   elib_dbg_memcmp, (void*, void*, int, char*, int));
EXTERN_FUNCTION(void*, elib_dbg_memmove, (void*, void*, int, char*, int));

EXTERN_FUNCTION(int,   elib_dbg_strlen, (char*, char*, int));
EXTERN_FUNCTION(char*, elib_dbg_strcpy, (char*, char*, char*, int));
EXTERN_FUNCTION(char*, elib_dbg_strncpy, (char*, char*, int, char*, int));
EXTERN_FUNCTION(int,   elib_dbg_strcmp, (char*, char*, char*, int));
EXTERN_FUNCTION(int,   elib_dbg_strncmp, (char*, char*, int, char*, int));
EXTERN_FUNCTION(char*, elib_dbg_strchr, (char*, int, char*, int));

EXTERN_FUNCTION(void*, elib_dbg_malloc, (int, char*, int));
EXTERN_FUNCTION(void*, elib_dbg_calloc, (int, int, char*, int));
EXTERN_FUNCTION(void*, elib_dbg_realloc, (void*, int, char*, int));
EXTERN_FUNCTION(void,  elib_dbg_free, (void*, char*, int));
EXTERN_FUNCTION(void*, elib_dbg_memalign, (int,int, char*, int));
EXTERN_FUNCTION(int,   elib_dbg_memsize, (void*, char*, int));
EXTERN_FUNCTION(void*, elib_db_memresize, (void*, int, char*, int));

#define elib_memset(dst,c,n)    elib_dbg_memset(dst,c,n,__FILE__,__LINE__)
#define elib_memcpy(dst,src,n)  elib_dbg_memcpy(dst,src,n,__FILE__,__LINE__)
#define elib_memcmp(p1, p2, n)  elib_dbg_memcmp(p1, p2, n, __FILE__, __LINE__)
#define elib_memmove(dst,src,n) elib_deb_memmove(dst,src,n,__FILE__,__LINE__)
#define elib_strlen(s1)         elib_dbg_strlen(s1, __FILE__, __LINE__)
#define elib_strcpy(dst,src)    elib_dbg_strcpy(dst,src,__FILE__, __LINE__)
#define elib_strncpy(dst,src,n) elib_dbg_strncpy(dst,src,n,__FILE__, __LINE__)
#define elib_strcmp(s1,s2)      elib_dbg_strcmp(s1,s2,__FILE__, __LINE__)
#define elib_strncmp(s1,s2,n)   elib_dbg_strncmp(s1,s2,n,__FILE__,__LINE__)
#define elib_strchr(s,c)        elib_dbg_strchr(s,c,__FILE__,__LINE__)

#define elib_malloc(n)          elib_dbg_malloc(n, __FILE__, __LINE__)
#define elib_calloc(n,s)        elib_dbg_calloc(n, s, __FILE__, __LINE__)
#define elib_realloc(p,n)       elib_dbg_realloc(p, n, __FILE__, __LINE__)
#define elib_free(p)            elib_dbg_free(p, __FILE__, __LINE__)
#define elib_memalign(a,n)      elib_dbg_memalign(a,n,__FILE__, __LINE__)
#define elib_memsize(p)         elib_dbg_memsize(p, __FILE__, __LINE__)
#define elib_memresize(p,n)     elib_dbg_memresize(p, n,__FILE__, __LINE__)

#ifdef ELIB_IS_CLIB

#define memset(dst,c,n)    elib_dbg_memset(dst,c,n,__FILE__,__LINE__)
#define memcpy(dst,src,n)  elib_dbg_memcpy(dst,src,n,__FILE__,__LINE__)
#define memcmp(p1, p2, n)  elib_dbg_memcmp(p1, p2, n, __FILE__, __LINE__)
#define memmove(dst,src,n) elib_deb_memmove(dst,src,n,__FILE__,__LINE__)
#define strlen(s1)         elib_dbg_strlen(s1, __FILE__, __LINE__)
#define strcpy(dst,src)    elib_dbg_strcpy(dst,src,__FILE__, __LINE__)
#define strncpy(dst,src,n) elib_dbg_strncpy(dst,src,n,__FILE__, __LINE__)
#define strcmp(s1,s2)      elib_dbg_strcmp(s1,s2,__FILE__, __LINE__)
#define strncmp(s1,s2,n)   elib_dbg_strncmp(s1,s2,n,__FILE__,__LINE__)
#define strchr(s,c)        elib_dbg_strchr(s,c,__FILE__,__LINE__)

#define malloc(n)          elib_dbg_malloc(n, __FILE__, __LINE__)
#define calloc(n,s)        elib_dbg_calloc(n, s, __FILE__, __LINE__)
#define realloc(p,n)       elib_dbg_realloc(p, n, __FILE__, __LINE__)
#define free(p)            elib_dbg_free(p, __FILE__, __LINE__)
#define memalign(a,n)      elib_dbg_memalign(a,n,__FILE__, __LINE__)
#define memsize(p)         elib_dbg_memsize(p, __FILE__, __LINE__)
#define memresize(p,n)     elib_dbg_resize(p, n, __FILE__, __LINE__)

#endif /* ELIB_IS_CLIB */

#endif /* ELIB_DEBUG */

#endif /* ELIB */
