/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */

#ifndef __DIST_H__
#define __DIST_H__

/* opcodes used in distribution messages */
#define DOP_LINK		1
#define DOP_SEND		2
#define DOP_EXIT		3
#define DOP_UNLINK		4
#define DOP_NODE_LINK		5
#define DOP_REG_SEND		6
#define DOP_GROUP_LEADER	7
#define DOP_EXIT2		8

#define DOP_SEND_TT		12
#define DOP_EXIT_TT		13
#define DOP_REG_SEND_TT		16
#define DOP_EXIT2_TT		18

#ifdef __SYS_H__

/* distribution trap functions */
extern uint32 dsend_trap;
extern uint32 dlink_trap;
extern uint32 dunlink_trap;
extern uint32 dmonitor_node_trap;
extern uint32 dgroup_leader_trap;
extern uint32 dexit_trap;

EXTERN_FUNCTION(int, dist_link, (int, uint32, uint32));
EXTERN_FUNCTION(int, dist_send, (int, uint32, uint32));
#ifdef SEQ_TRACE
EXTERN_FUNCTION(int, dist_exit_tt, (int, uint32, uint32, uint32, uint32));
EXTERN_FUNCTION(int, dist_exit_old, (int, uint32, uint32, uint32));
#else
EXTERN_FUNCTION(int, dist_exit_old, (int, uint32, uint32, uint32));
#endif
#define dist_exit(a, b, c, d) dist_exit_old(a, b, c, d)
EXTERN_FUNCTION(int, dist_unlink, (int, uint32, uint32));
EXTERN_FUNCTION(int, dist_reg_send, (int, uint32, uint32, uint32));
EXTERN_FUNCTION(int, dist_group_leader, (int, uint32, uint32));
EXTERN_FUNCTION(int, dist_exit2, (int, uint32, uint32, uint32));
#endif

#endif
