/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
 * This file is copyright (c) Ellemtel in January 1994
 * 
 * Author Tony Rogvall
 * 
 */

#ifndef __DECL_H__
#define __DECL_H__

#if defined(__STDC__) || defined(_MSC_VER)
#define EXTERN_FUNCTION(t, f, x)  extern t f x
#define FUNCTION(t, f, x) t f x
#define _DOTS_ ...
#define _VOID_      void
#elif defined(__cplusplus)
#define EXTERN_FUNCTION(f, x) extern "C" { f x }
#define FUNCTION(t, f, x) t f x
#define _DOTS_ ...
#define _VOID_    void
#else
#define EXTERN_FUNCTION(t, f, x) extern t f (/*x*/)
#define FUNCTION(t, f, x) t f (/*x*/)
#define _DOTS_
#define _VOID_
#endif

/*
** Example of declarations
**
** EXTERN_FUNCTION(void, foo, (int, int, char));
** FUNCTION(void, bar, (int, char));
**
** struct funcs {
**    FUNCTION(int*, (*f1), (int, int));
**    FUNCTION(void, (*f2), (int, char));
**    FUNCTION(void, (*f3), (_VOID_));
**    FUNCTION(int,  (*f4), (char*, _DOTS_));
** };
**
*/

#endif
