/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
 * This file is copyright (c) Ellemtel in October 1994
 *
 * Author Claes Wikstrom, klacke@erix.ericsson.se
 * Special code for very large dictionaries 
 *
 */

#ifndef __DB_H__
#define __DB_H__

#include "sys.h"
#include "bif.h"

typedef struct dbterm {
    struct  dbterm* next;  /* next bucket */
    uint32* tpl;           /* untagged pointer */
    uint32  hvalue;        /* stored hash value */
    struct  proc_bin *mso; /* binary list */
    uint32  size;          /* size in words of term */
    uint32  v[1];          /* element storage */
} DbTerm;

typedef struct {
    uint32 owner;             /* Pid of the creator */
    uint32 the_name;          /* an atom   */
    uint32 id;                /* atom | integer */
    uint32 status;            /* bit masks defined  below */
    int slot;                 /* slot in db_tables */
    int keypos;               /* defaults to 1 */

    int szm;          /* current size mask */
    int nactive;      /* Number of "active" slots */
    int nslots;       /* Total number of slots */
    int nitems;       /* Total number of items */
    int p;            /* Split position */
    int nsegs;        /* Number of segments */
    DbTerm*** seg;
} DbTable;

/* These are status bit patterns */
#define DB_NORMAL        (1 << 0)
#define DB_PRIVATE       (1 << 1)
#define DB_PROTECTED     (1 << 2)
#define DB_PUBLIC        (1 << 3)
#define DB_BAG           (1 << 4)
#define DB_SET           (1 << 5)
#define DB_LHASH         (1 << 6)
#define DB_FIXED         (1 << 7)
#define DB_DUPLICATE_BAG (1 << 8)

/* This should be a prime number. Find them with super:/usr/games/prime */
#define DB_MAX_TABS 8191	/* Happen to be 13 bits set to 1 */

/* The following symbols can be manipulated to "tune" the linear hash array */
#define BASIC_SIZE 64               /* #words for empty array       */
#define CHAIN_LEN 6                 /* Medium bucket chain len      */

EXTERN_FUNCTION(void, init_db, (_VOID_));
EXTERN_FUNCTION(void, db_proc_dead, (uint32));
EXTERN_FUNCTION(void, db_info, (_VOID_));

#ifdef DEBUG
EXTERN_FUNCTION(void, check_tables, (_VOID_));
EXTERN_FUNCTION(void, check_table, (DbTable*));
EXTERN_FUNCTION(void, db_bin_check, (_VOID_));
#endif


#endif
