/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
**
** File: bif.h
*/
#ifndef __BIF_H__
#define __BIF_H__

#define BIF_RETTYPE uint32

#define BIF_P A__p

#define BIF_ALIST_0 A__p
#define BIF_ALIST_1 A__p, A_1
#define BIF_ALIST_2 A__p, A_1, A_2
#define BIF_ALIST_3 A__p, A_1, A_2, A_3

#define BIF_ADECL_0 Process* A__p;
#define BIF_ADECL_1 Process* A__p; uint32 A_1;
#define BIF_ADECL_2 Process* A__p; uint32 A_1; uint32 A_2;
#define BIF_ADECL_3 Process* A__p; uint32 A_1; uint32 A_2; uint32 A_3;

#define BIF_XDECL_0 Process*
#define BIF_XDECL_1 Process*, uint32
#define BIF_XDECL_2 Process*, uint32, uint32
#define BIF_XDECL_3 Process*, uint32, uint32, uint32

#define BIF_ARG_1  A_1
#define BIF_ARG_2  A_2
#define BIF_ARG_3  A_3

#ifdef BEAM
#define BUMP_ALL_REDS(p) \
if (((p)->fcalls -= CONTEXT_REDS) < 0) (p)->fcalls = 0

#define BIF_RET2(x, gc) do { \
     BIF_P->fcalls -= (gc); \
     if (BIF_P->fcalls < 0) BIF_P->fcalls = 0; \
     return (x); \
} while(0)

#define BIF_RET(x) return (x)

/*
 * macro for returning an error from a bif, for example when a BIF has an
 * inccorrect argument BH return(1) changed to return(0) as 1 can mean NIL
 */
#define BIF_ERROR(Reason) \
       {BIF_P->freason = Reason; error_info[0] = 0; return(0);}

#define BIF_ERROR0(Reason,BifName) \
       {BIF_P->freason = Reason; \
	  error_info[0] = 1; \
	  error_info[1] = BifName; \
	  return(0);}

#define BIF_ERROR1(Reason,BifName,Arg) \
       {BIF_P->freason = Reason; \
	  error_info[0] = 2; \
	  error_info[1] = BifName; \
	  error_info[2] = Arg; \
	  return(0);}

#define BIF_ERROR2(Reason,BifName,Arg0,Arg1) \
       {BIF_P->freason = Reason; \
	  error_info[0] = 3; \
	  error_info[1] = BifName; \
	  error_info[2] = Arg0; \
	  error_info[3] = Arg1; \
	  return(0);}

#define BIF_ERROR3(Reason,BifName,Arg0,Arg1,Arg2) \
       {BIF_P->freason = Reason; \
	  error_info[0] = 4; \
	  error_info[1] = BifName; \
	  error_info[2] = Arg0; \
	  error_info[3] = Arg1; \
	  error_info[4] = Arg2; \
	  return(0);}

#elif defined(JAM)


#define BUMP_ALL_REDS(p) bif_gc = CONTEXT_REDS
#define BIF_RET2(x, gc) do { \
     if (bif_gc == 0) bif_gc = (gc); \
     return (x); \
} while(0)

#define BIF_RET(x) BIF_RET2(x, 0)

#define BIF_ERROR(r) { BIF_P->freason = r; return 0; }

#define BIF_ERROR0(r,b)		 BIF_ERROR(r)
#define BIF_ERROR1(r,b,a1)	 BIF_ERROR(r)
#define BIF_ERROR2(r,b,a1,a2)	 BIF_ERROR(r)
#define BIF_ERROR3(r,b,a1,a2,a3) BIF_ERROR(r)

#endif

#define BIF_TRAP(ix) do { \
      BIF_P->fvalue = (ix); \
      BIF_P->freason = TRAP; \
      return 0; \
 } while(0)

#define BIF_TRAP0(ix)          BIF_TRAP(ix)
#define BIF_TRAP1(ix,a1)       BIF_TRAP(ix)
#define BIF_TRAP2(ix,a1,a2)    BIF_TRAP(ix)
#define BIF_TRAP3(ix,a1,a2,a3) BIF_TRAP(ix)

#include "bif_table.h"

#endif
