/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
** File: atom.h
** Author: Tony Rovall
**
*/

#ifndef __ATOM_H__
#define __ATOM_H__

#ifndef __INDEX_H__
#include "index.h"
#endif

#include "am.h"

#define MAX_ATOM_LENGTH 255
/*
** Atom entry
*/
typedef struct atom
{
    IndexSlot slot;  /* MUST BE LOCATED AT TOP OF STRUCT!!! */
    int len;         /* length of atom name */
    byte* name;      /* name of atom */
} Atom;

extern uint32 reserved_atom_space;
extern uint32 atom_space;

extern IndexTable atom_table;

#define atom_tab(i)       ((Atom*) atom_table.table[i])
#define atom_table_size   atom_table.sz


EXTERN_FUNCTION(int, atom_get, (byte*, int));
EXTERN_FUNCTION(int, atom_put, (byte*, int));
EXTERN_FUNCTION(int, atom_erase, (byte*, int));
EXTERN_FUNCTION(int, atom_static_put, (byte*, int));
EXTERN_FUNCTION(void, init_atom_table, (_VOID_));
EXTERN_FUNCTION(void, atom_info, (CIO));

extern uint32 am_noname;
extern uint32 am_underscore;

#define magic_word(s) atom_static_put((byte*)(s), sys_strlen(s))
#define am_magic_word(s) make_atom(atom_static_put((byte*)(s), strlen(s)))
#define am_atom_put(s,n) make_atom(atom_put((byte*)(s), n))

#endif

