/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include <stdio.h>

extern int sys_nerr;
extern char *sys_errlist[];

char*
strerror(err)
int err;
{
  static char msgstr[1024];

  if (err == 0) {
      msgstr[0] = '\0';
  } else if (0 < err && err < sys_nerr) {
      strcpy(msgstr, sys_errlist[err]);
  } else {
      sprintf(msgstr, "Unknown error %d", err);
  }
  return msgstr;
}

