/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/* 
 * This file defines the constants used in the load format
 */


#define L_FUNCTION 	1	/* Function definition                **/
#define L_STRING	2	/* String follows  2 L1 L0 Strings    **/
#define L_EXPORTED	3	/* This function is exported          **/
#define L_LOCAL		4	/* This function is local             **/
#define L_PATCH_CONSTANT 5	/* Constant 5 String patch list       **/
#define L_PATCH_LOCAL	6	/* Local function 6 String Arity Addr **/
#define L_IMPORT	7	/* Import a function                  **/
#define L_PATCH_AT	8	/* Follows a PATCH (2 byte offset)    **/
#define L_CODE_LENGTH	9	/* Code length 9 B1 B0                **/
#define L_COPYRIGHT	10	/* Copyright notice                   **/
#define L_MAGIC_STRING	11	/* Magic string for version control   **/
#define L_PATCH_FLOAT	12	/* Patch for a float                  **/

#define L_PATCH_AT_3	14	/* Follows a PATCH (3 byte offset)    **/
/* Joe is superstitious */
#define L_CODE_LENGTH_3 15      /* Code length 15 B2 B1 B0 */


#define END_OF_FILE	-1	/* return value form get_n() at eof   **/

/* 
 * And the load errors
 */

#define BAD_STRING	-1
#define BAD_MAGIC	-2
#define BAD_FUNCTION	-3
#define TRUNCATED	-4
#define TOO_MANY_FUNCTIONS	-5
#define BAD_FORMAT	-6
#define BAD_FLOAT	-7
#define TOO_LONG_FUNCTION_NAMES -8
#define NO_MODULE_NAME	-9
#define BAD_MODULE_NAME -10   /* Modulename in arg differs from code */


/*
 * Type of patch
 */


#define PATCH_CSA	1
#define PATCH_LOC	2
#define PATCH_CONST	3
#define PATCH_BIF	4
#define PATCH_APPLY	5
#define PATCH_F		6
