/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/* Copyright (C) 1997, Ericsson Telecom */

/* 
 * Interface functions to the dynamic linker using dl* functions.
 * (As far as I know it works on SunOS 4, 5, Linux and FreeBSD. /Seb) 
 */

#include "sys.h"
#include "config.h"
#include "erl_ddll.h"
#include <dlfcn.h>


/* some systems do not have RTLD_NOW defined, and require the "mode"
 * argument to dload() always be 1.
 */
#ifndef RTLD_NOW
#  define RTLD_NOW 1
#endif

#define MAX_NAME_LEN 255      /* XXX should we get the system path size? */
#define EXT_LEN      3
#define FILE_EXT     ".so"    /* extension appended to the filename */

/* the ddll driver is single threaded !! */
static int dlopen_error;      /* set if not dl error !! */

#define ERL_DLERR_NAME_TO_LONG  1

/* 
 * Open a shared object
 */
void *ddll_open(full_name)
    char *full_name;
{
    char dlname[MAX_NAME_LEN+EXT_LEN+1];
    int len;

    dlopen_error = 0;
    if ((len = sys_strlen(full_name)) >= MAX_NAME_LEN) {
	dlopen_error = ERL_DLERR_NAME_TO_LONG;
	return NULL;
    }
    sys_strcpy(dlname, full_name);
    sys_strcpy(dlname+len, FILE_EXT);
    return dlopen(dlname, RTLD_NOW);
}

/* 
 * Find a symbol in the shared object
 */
uint32 *ddll_sym(handle, func_name)
     void *handle;
     char *func_name;
{
    return dlsym(handle, func_name);
}

/* 
 * Close a chared object
 */
int ddll_close(handle)
     void *handle;
{
    return dlclose(handle);
}


/*
 * Return string that describes the (current) error
 */
char *ddll_error()
{
    char* msg;

    if (dlopen_error) {
	switch(dlopen_error) {
	case ERL_DLERR_NAME_TO_LONG:
	    return "name to long";
	default:
	    return "unknown error";
	}
    }
    msg = dlerror();
    return msg ? msg : "no error";
}
