/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/* Copyright (C) 1994, Ellemtel Telecommunications Systems Laboratories */
/* Author: Claes Wikstrom  klacke@erix.ericsson.se */
/* Purpose: demonstrate how to include interupt handlers in erlang */


#include "sys.h"
#include "driver.h"
#include <signal.h>
#include <stdio.h>

static long sig_start();
static int sig_init(),sig_stop(),doio();

const struct driver_entry sig_driver_entry = {
    sig_init,sig_start,sig_stop,null_func,
    doio,null_func,"sig_test"
    };

static long this_port;

static int sig_init()
{
    this_port = -1;
}


static sigc(ino)
int ino;
{
    driver_interrupt(this_port, ino);
}

static long sig_start(port,buf) 
int port;
char *buf;
{

    if (this_port != -1)
	return(-1);
    this_port = port;
    signal(SIGUSR1, sigc);
    return(port);
}

static int sig_stop()
{
    this_port = -1;
    signal(SIGUSR1, SIG_DFL);
}


doio(port ,ino)
int port, ino;
{
    /* First go get the io, unless we already did that */
    /* In the sighandler */

    /* Then send it to erlang */

    driver_output(this_port,"y",1);
}
